/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.plugin.hive.util.AcidBucketCodec;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAcidBucketCodec {
    @Test
    public void testGetBucketCodecVersion0() {
        AcidBucketCodec codec = AcidBucketCodec.forBucket((int)0);
        Assert.assertEquals((Object)codec, (Object)AcidBucketCodec.V0);
        Assert.assertEquals((int)codec.decodeWriterId(7), (int)7);
        Assert.assertEquals((int)codec.decodeStatementId(100), (int)0);
        Assert.assertEquals((int)codec.decodeStatementId(-10), (int)0);
    }

    @Test
    public void testGetBucketCodecVersion1() {
        AcidBucketCodec codec = AcidBucketCodec.forBucket((int)0x20000000);
        Assert.assertEquals((Object)codec, (Object)AcidBucketCodec.V1);
        Assert.assertEquals((int)codec.decodeWriterId(180092928), (int)2748);
        Assert.assertEquals((int)codec.decodeStatementId(2748), (int)2748);
    }

    @Test
    public void testGetBucketCodecInvalidVersion() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> AcidBucketCodec.forBucket((int)0x60000000)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid bucket 0x60000000. Version=3");
    }
}

