/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.filesystem.FileEntry;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.FileSystemTesting;
import io.trino.plugin.hive.util.ValidWriteIdList;
import io.trino.spi.security.ConnectorIdentity;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAcidTables {
    private static final byte[] FAKE_DATA = new byte[]{65, 66, 67};

    @Test
    public void testParseBase() {
        AcidTables.ParsedBase base = AcidTables.parseBase((String)"base_000123");
        Assert.assertEquals((long)base.writeId(), (long)123L);
        Assert.assertEquals((long)base.visibilityId(), (long)0L);
        base = AcidTables.parseBase((String)"base_123_v456");
        Assert.assertEquals((long)base.writeId(), (long)123L);
        Assert.assertEquals((long)base.visibilityId(), (long)456L);
    }

    @Test
    public void testParseDelta() {
        AcidTables.ParsedDelta delta = AcidTables.parseDelta((String)"/tbl/part1/delta_12_34", (String)"delta_", List.of());
        Assert.assertEquals((long)12L, (long)delta.min());
        Assert.assertEquals((long)34L, (long)delta.max());
        Assert.assertEquals((int)-1, (int)delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delete_delta_12_34", (String)"delete_delta_", List.of());
        Assert.assertEquals((long)12L, (long)delta.min());
        Assert.assertEquals((long)34L, (long)delta.max());
        Assert.assertEquals((int)-1, (int)delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delta_12_34_56", (String)"delta_", List.of());
        Assert.assertEquals((long)12L, (long)delta.min());
        Assert.assertEquals((long)34L, (long)delta.max());
        Assert.assertEquals((int)56, (int)delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delete_delta_12_34_56", (String)"delete_delta_", List.of());
        Assert.assertEquals((long)12L, (long)delta.min());
        Assert.assertEquals((long)34L, (long)delta.max());
        Assert.assertEquals((int)56, (int)delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delta_12_34_v78", (String)"delta_", List.of());
        Assert.assertEquals((long)12L, (long)delta.min());
        Assert.assertEquals((long)34L, (long)delta.max());
        Assert.assertEquals((int)-1, (int)delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delete_delta_12_34_v78", (String)"delete_delta_", List.of());
        Assert.assertEquals((long)12L, (long)delta.min());
        Assert.assertEquals((long)34L, (long)delta.max());
        Assert.assertEquals((int)-1, (int)delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delta_12_34_56_v78", (String)"delta_", List.of());
        Assert.assertEquals((long)12L, (long)delta.min());
        Assert.assertEquals((long)34L, (long)delta.max());
        Assert.assertEquals((int)56, (int)delta.statementId());
        delta = AcidTables.parseDelta((String)"/tbl/part1/delete_delta_12_34_56_v78", (String)"delete_delta_", List.of());
        Assert.assertEquals((long)12L, (long)delta.min());
        Assert.assertEquals((long)34L, (long)delta.max());
        Assert.assertEquals((int)56, (int)delta.statementId());
    }

    @Test
    public void testOriginal() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0_copy_1", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0_copy_2", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000002_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/random", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_done", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/subdir/000000_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).isEmpty();
        Assertions.assertThat((List)state.deltas()).isEmpty();
        List files = state.originalFiles();
        Assert.assertEquals((int)files.size(), (int)7);
        Assert.assertEquals((String)((FileEntry)files.get(0)).location(), (String)"mock:/tbl/part1/000000_0");
        Assert.assertEquals((String)((FileEntry)files.get(1)).location(), (String)"mock:/tbl/part1/000000_0_copy_1");
        Assert.assertEquals((String)((FileEntry)files.get(2)).location(), (String)"mock:/tbl/part1/000000_0_copy_2");
        Assert.assertEquals((String)((FileEntry)files.get(3)).location(), (String)"mock:/tbl/part1/000001_1");
        Assert.assertEquals((String)((FileEntry)files.get(4)).location(), (String)"mock:/tbl/part1/000002_0");
        Assert.assertEquals((String)((FileEntry)files.get(5)).location(), (String)"mock:/tbl/part1/random");
        Assert.assertEquals((String)((FileEntry)files.get(6)).location(), (String)"mock:/tbl/part1/subdir/000000_0");
    }

    @Test
    public void testOriginalDeltas() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000002_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/random", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_done", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/subdir/000000_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_100/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).isEmpty();
        List files = state.originalFiles();
        Assert.assertEquals((int)files.size(), (int)5);
        Assert.assertEquals((String)((FileEntry)files.get(0)).location(), (String)"mock:/tbl/part1/000000_0");
        Assert.assertEquals((String)((FileEntry)files.get(1)).location(), (String)"mock:/tbl/part1/000001_1");
        Assert.assertEquals((String)((FileEntry)files.get(2)).location(), (String)"mock:/tbl/part1/000002_0");
        Assert.assertEquals((String)((FileEntry)files.get(3)).location(), (String)"mock:/tbl/part1/random");
        Assert.assertEquals((String)((FileEntry)files.get(4)).location(), (String)"mock:/tbl/part1/subdir/000000_0");
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)2);
        AcidTables.ParsedDelta delta = (AcidTables.ParsedDelta)deltas.get(0);
        Assert.assertEquals((String)delta.path(), (String)"mock:/tbl/part1/delta_025_030");
        Assert.assertEquals((long)delta.min(), (long)25L);
        Assert.assertEquals((long)delta.max(), (long)30L);
        delta = (AcidTables.ParsedDelta)deltas.get(1);
        Assert.assertEquals((String)delta.path(), (String)"mock:/tbl/part1/delta_050_100");
        Assert.assertEquals((long)delta.min(), (long)50L);
        Assert.assertEquals((long)delta.max(), (long)100L);
    }

    @Test
    public void testBaseDeltas() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_90_120/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState dir = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)dir.baseDirectory()).contains((Object)"mock:/tbl/part1/base_49");
        Assert.assertEquals((int)dir.originalFiles().size(), (int)0);
        List deltas = dir.deltas();
        Assert.assertEquals((int)deltas.size(), (int)1);
        AcidTables.ParsedDelta delta = (AcidTables.ParsedDelta)deltas.get(0);
        Assert.assertEquals((String)delta.path(), (String)"mock:/tbl/part1/delta_050_105");
        Assert.assertEquals((long)delta.min(), (long)50L);
        Assert.assertEquals((long)delta.max(), (long)105L);
    }

    @Test
    public void testObsoleteOriginals() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:150:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)"mock:/tbl/part1/base_10");
    }

    @Test
    public void testOverlapingDelta() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)"mock:/tbl/part1/base_50");
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)4);
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(0)).path(), (String)"mock:/tbl/part1/delta_40_60");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(1)).path(), (String)"mock:/tbl/part1/delta_00061_61");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(2)).path(), (String)"mock:/tbl/part1/delta_000062_62");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(3)).path(), (String)"mock:/tbl/part1/delta_0000063_63");
    }

    @Test
    public void testOverlapingDelta2() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63_0/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62_0/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62_3/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61_0/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_1/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_4/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_7/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_058_58/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)"mock:/tbl/part1/base_50");
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)5);
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(0)).path(), (String)"mock:/tbl/part1/delta_40_60");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(1)).path(), (String)"mock:/tbl/part1/delta_00061_61_0");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(2)).path(), (String)"mock:/tbl/part1/delta_000062_62_0");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(3)).path(), (String)"mock:/tbl/part1/delta_000062_62_3");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(4)).path(), (String)"mock:/tbl/part1/delta_0000063_63_0");
    }

    @Test
    public void deltasWithOpenTxnInRead() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:4:4"));
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)2);
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(0)).path(), (String)"mock:/tbl/part1/delta_1_1");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(1)).path(), (String)"mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void deltasWithOpenTxnInRead2() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_1/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_3/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101_1/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:4:4"));
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)2);
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(0)).path(), (String)"mock:/tbl/part1/delta_1_1");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(1)).path(), (String)"mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void testBaseWithDeleteDeltas() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_029_029/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_025_030/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_050_105/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_110_110/bucket_0", 0, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)"mock:/tbl/part1/base_49");
        Assertions.assertThat((List)state.originalFiles()).isEmpty();
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)2);
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(0)).path(), (String)"mock:/tbl/part1/delete_delta_050_105");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(1)).path(), (String)"mock:/tbl/part1/delta_050_105");
    }

    @Test
    public void testOverlapingDeltaAndDeleteDelta() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_00064_64/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_40_60/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_052_55/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        Assertions.assertThat((Optional)state.baseDirectory()).contains((Object)"mock:/tbl/part1/base_50");
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)6);
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(0)).path(), (String)"mock:/tbl/part1/delete_delta_40_60");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(1)).path(), (String)"mock:/tbl/part1/delta_40_60");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(2)).path(), (String)"mock:/tbl/part1/delta_00061_61");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(3)).path(), (String)"mock:/tbl/part1/delta_000062_62");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(4)).path(), (String)"mock:/tbl/part1/delta_0000063_63");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(5)).path(), (String)"mock:/tbl/part1/delete_delta_00064_64");
    }

    @Test
    public void testMinorCompactedDeltaMakesInBetweenDelteDeltaObsolete() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_50_50/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:%d:".formatted(Long.MAX_VALUE)));
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)1);
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(0)).path(), (String)"mock:/tbl/part1/delta_40_60");
    }

    @Test
    public void deleteDeltasWithOpenTxnInRead() throws Exception {
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(ConfigurationInstantiator.newEmptyConfiguration(), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_2_5/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_3_3/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_1/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_3/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101_1/bucket_0", 500, FAKE_DATA, new FileSystemTesting.MockBlock[0]));
        AcidTables.AcidState state = AcidTables.getAcidState((TrinoFileSystem)TestAcidTables.testingTrinoFileSystem(fs), (String)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1").toString(), (ValidWriteIdList)new ValidWriteIdList("tbl:100:4:4"));
        List deltas = state.deltas();
        Assert.assertEquals((int)deltas.size(), (int)3);
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(0)).path(), (String)"mock:/tbl/part1/delta_1_1");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(1)).path(), (String)"mock:/tbl/part1/delete_delta_2_5");
        Assert.assertEquals((String)((AcidTables.ParsedDelta)deltas.get(2)).path(), (String)"mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void testDeleteDeltaSubdirPathGeneration() {
        String deleteDeltaSubdirPath = AcidTables.deleteDeltaSubdir((long)13L, (int)5);
        Assert.assertEquals((String)deleteDeltaSubdirPath, (String)"delete_delta_0000013_0000013_0005");
    }

    private static TrinoFileSystem testingTrinoFileSystem(final FileSystem fileSystem) {
        HdfsConfiguration hdfsConfiguration = (context, uri) -> ConfigurationInstantiator.newEmptyConfiguration();
        HdfsEnvironment environment = new HdfsEnvironment(hdfsConfiguration, new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication()){

            public FileSystem getFileSystem(ConnectorIdentity identity, Path path, Configuration configuration) {
                return fileSystem;
            }
        };
        ConnectorIdentity identity = ConnectorIdentity.forUser((String)"test").build();
        return new HdfsFileSystemFactory(environment).create(identity);
    }
}

