/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.testing.TestingConnectorSession;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveWriteUtils {
    private static final HdfsContext CONTEXT = new HdfsContext(TestingConnectorSession.SESSION);

    @Test
    public void testIsS3FileSystem() {
        Assert.assertTrue((boolean)HiveWriteUtils.isS3FileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (Path)new Path("s3://test-bucket/test-folder")));
        Assert.assertFalse((boolean)HiveWriteUtils.isS3FileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (Path)new Path("/test-dir/test-folder")));
    }

    @Test
    public void testIsViewFileSystem() {
        Path viewfsPath = new Path("viewfs://ns-default/test-folder");
        Path nonViewfsPath = new Path("hdfs://localhost/test-dir/test-folder");
        HiveTestUtils.HDFS_ENVIRONMENT.getConfiguration(CONTEXT, viewfsPath).set("fs.viewfs.mounttable.ns-default.link./test-folder", "hdfs://localhost/app");
        Assert.assertTrue((boolean)HiveWriteUtils.isViewFileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (Path)viewfsPath));
        Assert.assertFalse((boolean)HiveWriteUtils.isViewFileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (Path)nonViewfsPath));
    }
}

