/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.airlift.units.DataSize;
import io.trino.plugin.hive.util.SizeBasedSplitWeightProvider;
import io.trino.spi.SplitWeight;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSizeBasedSplitWeightProvider {
    @Test
    public void testSimpleProportions() {
        SizeBasedSplitWeightProvider provider = new SizeBasedSplitWeightProvider(0.01, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()), (Object)SplitWeight.fromProportion((double)1.0));
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()), (Object)SplitWeight.fromProportion((double)0.5));
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()), (Object)SplitWeight.fromProportion((double)0.25));
    }

    @Test
    public void testMinimumAndMaximumSplitWeightHandling() {
        double minimumWeight = 0.05;
        DataSize targetSplitSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
        SizeBasedSplitWeightProvider provider = new SizeBasedSplitWeightProvider(minimumWeight, targetSplitSize);
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(1L), (Object)SplitWeight.fromProportion((double)minimumWeight));
        DataSize largerThanTarget = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(largerThanTarget.toBytes()), (Object)SplitWeight.standard());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="^minimumWeight must be > 0 and <= 1, found: 1\\.01$")
    public void testInvalidMinimumWeight() {
        new SizeBasedSplitWeightProvider(1.01, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="^targetSplitSize must be > 0, found:.*$")
    public void testInvalidTargetSplitSize() {
        new SizeBasedSplitWeightProvider(0.01, DataSize.ofBytes((long)0L));
    }
}

