/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.metastore.BooleanStatistics;
import io.trino.plugin.hive.metastore.DateStatistics;
import io.trino.plugin.hive.metastore.DecimalStatistics;
import io.trino.plugin.hive.metastore.DoubleStatistics;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.IntegerStatistics;
import io.trino.plugin.hive.util.Statistics;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestStatistics {
    @Test
    public void testCreateRealHiveColumnStatistics() {
        HiveColumnStatistics statistics = TestStatistics.createRealColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(-2391.0f)), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(42.0f))));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.of(-2391.0), OptionalDouble.of(42.0)));
        statistics = TestStatistics.createRealColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NEGATIVE_INFINITY)), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.POSITIVE_INFINITY))));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        statistics = TestStatistics.createRealColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NaN)), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NaN))));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        statistics = TestStatistics.createRealColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(-15.0f)), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)RealType.REAL, (Object)Float.floatToIntBits(-0.0f))));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.of(-15.0), OptionalDouble.of(-0.0)));
    }

    private static HiveColumnStatistics createRealColumnStatistics(Map<HiveColumnStatisticType, Block> computedStatistics) {
        return Statistics.createHiveColumnStatistics(computedStatistics, (Type)RealType.REAL, (long)1L);
    }

    @Test
    public void testCreateDoubleHiveColumnStatistics() {
        HiveColumnStatistics statistics = TestStatistics.createDoubleColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)-2391.0), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)42.0)));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.of(-2391.0), OptionalDouble.of(42.0)));
        statistics = TestStatistics.createDoubleColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)Double.NEGATIVE_INFINITY), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)Double.POSITIVE_INFINITY)));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        statistics = TestStatistics.createDoubleColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)Double.NaN), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)Double.NaN)));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        statistics = TestStatistics.createDoubleColumnStatistics((Map<HiveColumnStatisticType, Block>)ImmutableMap.of((Object)HiveColumnStatisticType.MIN_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)-15.0), (Object)HiveColumnStatisticType.MAX_VALUE, (Object)Utils.nativeValueToBlock((Type)DoubleType.DOUBLE, (Object)-0.0)));
        Assertions.assertThat((Object)((DoubleStatistics)statistics.getDoubleStatistics().get())).isEqualTo((Object)new DoubleStatistics(OptionalDouble.of(-15.0), OptionalDouble.of(-0.0)));
    }

    private static HiveColumnStatistics createDoubleColumnStatistics(Map<HiveColumnStatisticType, Block> computedStatistics) {
        return Statistics.createHiveColumnStatistics(computedStatistics, (Type)DoubleType.DOUBLE, (long)1L);
    }

    @Test
    public void testReduce() {
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createZeroStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createZeroStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.SUBTRACT)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createZeroStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.SUBTRACT)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createZeroStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.SUBTRACT)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)new HiveBasicStatistics(11L, 9L, 7L, 5L), (HiveBasicStatistics)new HiveBasicStatistics(1L, 2L, 3L, 4L), (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).isEqualTo((Object)new HiveBasicStatistics(12L, 11L, 10L, 9L));
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)new HiveBasicStatistics(11L, 9L, 7L, 5L), (HiveBasicStatistics)new HiveBasicStatistics(1L, 2L, 3L, 4L), (Statistics.ReduceOperator)Statistics.ReduceOperator.SUBTRACT)).isEqualTo((Object)new HiveBasicStatistics(10L, 7L, 4L, 1L));
    }

    @Test
    public void testMergeEmptyColumnStatistics() {
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.empty(), HiveColumnStatistics.empty(), HiveColumnStatistics.empty());
    }

    @Test
    public void testMergeIntegerColumnStatistics() {
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(0L), OptionalLong.of(3L))).build(), HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(0L), OptionalLong.of(3L))).build());
    }

    @Test
    public void testMergeDoubleColumnStatistics() {
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(1.0), OptionalDouble.of(2.0))).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(1.0), OptionalDouble.of(2.0))).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(1.0), OptionalDouble.of(2.0))).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(0.0), OptionalDouble.of(3.0))).build(), HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(OptionalDouble.of(0.0), OptionalDouble.of(3.0))).build());
    }

    @Test
    public void testMergeDecimalColumnStatistics() {
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(1L)), Optional.of(BigDecimal.valueOf(2L)))).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(1L)), Optional.of(BigDecimal.valueOf(2L)))).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(1L)), Optional.of(BigDecimal.valueOf(2L)))).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(0L)), Optional.of(BigDecimal.valueOf(3L)))).build(), HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(Optional.of(BigDecimal.valueOf(0L)), Optional.of(BigDecimal.valueOf(3L)))).build());
    }

    @Test
    public void testMergeDateColumnStatistics() {
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(2L)))).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty())).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(2L)))).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(2L)))).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(0L)), Optional.of(LocalDate.ofEpochDay(3L)))).build(), HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(Optional.of(LocalDate.ofEpochDay(0L)), Optional.of(LocalDate.ofEpochDay(3L)))).build());
    }

    @Test
    public void testMergeBooleanColumnStatistics() {
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(1L), OptionalLong.of(2L))).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(2L), OptionalLong.of(3L))).build(), HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(OptionalLong.of(3L), OptionalLong.of(5L))).build());
    }

    @Test
    public void testMergeStringColumnStatistics() {
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.empty()).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(1L)).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(2L)).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(3L)).build(), HiveColumnStatistics.builder().setMaxValueSizeInBytes(OptionalLong.of(3L)).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.empty()).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.of(1L)).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.of(2L)).build(), HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.of(3L)).build(), HiveColumnStatistics.builder().setTotalSizeInBytes(OptionalLong.of(5L)).build());
    }

    @Test
    public void testMergeGenericColumnStatistics() {
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.empty()).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.empty()).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.of(2L)).build(), HiveColumnStatistics.builder().setDistinctValuesCount(OptionalLong.of(2L)).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setNullsCount(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.empty()).build());
        TestStatistics.assertMergeHiveColumnStatistics(HiveColumnStatistics.builder().setNullsCount(OptionalLong.of(1L)).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.of(2L)).build(), HiveColumnStatistics.builder().setNullsCount(OptionalLong.of(3L)).build());
    }

    @Test
    public void testMergeHiveColumnStatisticsMap() {
        ImmutableMap first = ImmutableMap.of((Object)"column1", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(4L)), (Object)"column2", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(2.0), (OptionalDouble)OptionalDouble.of(3.0), (OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(5L)), (Object)"column3", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(10L)), (Object)"column4", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L)));
        ImmutableMap second = ImmutableMap.of((Object)"column5", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L), (OptionalLong)OptionalLong.of(4L)), (Object)"column2", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(1.0), (OptionalDouble)OptionalDouble.of(4.0), (OptionalLong)OptionalLong.of(4L), (OptionalLong)OptionalLong.of(6L)), (Object)"column3", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(6L), (OptionalLong)OptionalLong.of(5L), (OptionalLong)OptionalLong.of(10L)), (Object)"column6", (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(2L), (OptionalLong)OptionalLong.of(3L)));
        ImmutableMap expected = ImmutableMap.of((Object)"column2", (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(1.0), (OptionalDouble)OptionalDouble.of(4.0), (OptionalLong)OptionalLong.of(8L), (OptionalLong)OptionalLong.of(6L)), (Object)"column3", (Object)HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(6L), (OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.of(20L)));
        Assertions.assertThat((Map)Statistics.merge((Map)first, (Map)second)).isEqualTo((Object)expected);
        Assertions.assertThat((Map)Statistics.merge((Map)ImmutableMap.of(), (Map)ImmutableMap.of())).isEqualTo((Object)ImmutableMap.of());
    }

    @Test
    public void testFromComputedStatistics() {
        Function<Integer, Block> singleIntegerValueBlock = value -> BigintType.BIGINT.createBlockBuilder(null, 1).writeLong((long)value.intValue()).build();
        ComputedStatistics statistics = ComputedStatistics.builder((List)ImmutableList.of(), (List)ImmutableList.of()).addTableStatistic(TableStatisticType.ROW_COUNT, singleIntegerValueBlock.apply(5)).addColumnStatistic(HiveColumnStatisticType.MIN_VALUE.createColumnStatisticMetadata("a_column"), singleIntegerValueBlock.apply(1)).addColumnStatistic(HiveColumnStatisticType.MAX_VALUE.createColumnStatisticMetadata("a_column"), singleIntegerValueBlock.apply(5)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES.createColumnStatisticMetadata("a_column"), singleIntegerValueBlock.apply(5)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES.createColumnStatisticMetadata("a_column"), singleIntegerValueBlock.apply(5)).addColumnStatistic(HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES.createColumnStatisticMetadata("b_column"), singleIntegerValueBlock.apply(4)).build();
        ImmutableMap columnTypes = ImmutableMap.of((Object)"a_column", (Object)IntegerType.INTEGER, (Object)"b_column", (Object)VarcharType.VARCHAR);
        Map columnStatistics = Statistics.fromComputedStatistics((Map)statistics.getColumnStatistics(), (Map)columnTypes, (long)5L);
        Assertions.assertThat((Map)columnStatistics).hasSize(2);
        Assertions.assertThat(columnStatistics.keySet()).contains((Object[])new String[]{"a_column", "b_column"});
        Assertions.assertThat((Object)((HiveColumnStatistics)columnStatistics.get("a_column"))).isEqualTo((Object)HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(OptionalLong.of(1L), OptionalLong.of(5L))).setNullsCount(0L).setDistinctValuesCount(5L).build());
        Assertions.assertThat((Object)((HiveColumnStatistics)columnStatistics.get("b_column"))).isEqualTo((Object)HiveColumnStatistics.builder().setNullsCount(1L).build());
    }

    private static void assertMergeHiveColumnStatistics(HiveColumnStatistics first, HiveColumnStatistics second, HiveColumnStatistics expected) {
        Assertions.assertThat((Object)Statistics.merge((HiveColumnStatistics)first, (HiveColumnStatistics)second)).isEqualTo((Object)expected);
        Assertions.assertThat((Object)Statistics.merge((HiveColumnStatistics)second, (HiveColumnStatistics)first)).isEqualTo((Object)expected);
    }
}

