/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.GenericHiveRecordCursor;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveRecordCursorProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;

public class GenericHiveRecordCursorProvider
implements HiveRecordCursorProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final int textMaxLineLengthBytes;

    @Inject
    public GenericHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment, HiveConfig config) {
        this(hdfsEnvironment, config.getTextMaxLineLength());
    }

    public GenericHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment, DataSize textMaxLineLength) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.textMaxLineLengthBytes = Math.toIntExact(textMaxLineLength.toBytes());
        Preconditions.checkArgument((this.textMaxLineLengthBytes >= 1 ? 1 : 0) != 0, (Object)"textMaxLineLength must be at least 1 byte");
    }

    @Override
    public Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> createRecordCursor(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, TypeManager typeManager, boolean s3SelectPushdownEnabled) {
        configuration.setInt("mapreduce.input.linerecordreader.line.maxlength", this.textMaxLineLengthBytes);
        try {
            this.hdfsEnvironment.getFileSystem(session.getIdentity(), path, configuration);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + path, (Throwable)e);
        }
        Optional<ReaderColumns> projections = HivePageSourceProvider.projectBaseColumns(columns);
        List<HiveColumnHandle> readerColumns = projections.map(ReaderColumns::get).map(columnHandles -> columnHandles.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns);
        RecordCursor cursor = (RecordCursor)this.hdfsEnvironment.doAs(session.getIdentity(), () -> {
            RecordReader<?, ?> recordReader = HiveUtil.createRecordReader(configuration, path, start, length, schema, readerColumns);
            try {
                return new GenericHiveRecordCursor(configuration, path, GenericHiveRecordCursorProvider.genericRecordReader(recordReader), length, schema, readerColumns);
            }
            catch (Exception e) {
                block4: {
                    try {
                        recordReader.close();
                    }
                    catch (IOException closeException) {
                        if (e == closeException) break block4;
                        e.addSuppressed(closeException);
                    }
                }
                throw e;
            }
        });
        return Optional.of(new HiveRecordCursorProvider.ReaderRecordCursorWithProjections(cursor, projections));
    }

    private static RecordReader<?, ? extends Writable> genericRecordReader(RecordReader<?, ?> recordReader) {
        return recordReader;
    }
}

