/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveInputInfo {
    private final List<String> partitionIds;
    private final boolean partitioned;
    private final Optional<String> tableDefaultFileFormat;

    @JsonCreator
    public HiveInputInfo(@JsonProperty(value="partitionIds") List<String> partitionIds, @JsonProperty(value="partitioned") boolean partitioned, @JsonProperty(value="tableDefaultFileFormat") Optional<String> tableDefaultFileFormat) {
        this.partitionIds = Objects.requireNonNull(partitionIds, "partitionIds is null");
        this.partitioned = partitioned;
        this.tableDefaultFileFormat = Objects.requireNonNull(tableDefaultFileFormat, "tableDefaultFileFormat is null");
    }

    @JsonProperty
    public List<String> getPartitionIds() {
        return this.partitionIds;
    }

    @JsonProperty
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @JsonProperty
    public Optional<String> getTableDefaultFileFormat() {
        return this.tableDefaultFileFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HiveInputInfo)) {
            return false;
        }
        HiveInputInfo that = (HiveInputInfo)o;
        return this.partitionIds.equals(that.partitionIds) && this.partitioned == that.partitioned && this.tableDefaultFileFormat.equals(that.tableDefaultFileFormat);
    }

    public int hashCode() {
        return Objects.hash(this.partitionIds, this.partitioned, this.tableDefaultFileFormat);
    }
}

