/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

public class HiveLocationService
implements LocationService {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public HiveLocationService(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    @Override
    public Path forNewTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName) {
        HdfsContext context = new HdfsContext(session);
        Path targetPath = HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName);
        if (HiveWriteUtils.pathExists(context, this.hdfsEnvironment, targetPath)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        return targetPath;
    }

    @Override
    public LocationHandle forNewTableAsSelect(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName, Optional<Path> externalLocation) {
        HdfsContext context = new HdfsContext(session);
        Path targetPath = externalLocation.orElseGet(() -> HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName));
        if (HiveWriteUtils.pathExists(context, this.hdfsEnvironment, targetPath)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        if (this.shouldUseTemporaryDirectory(session, context, targetPath, externalLocation)) {
            Path writePath = HiveWriteUtils.createTemporaryPath(session, context, this.hdfsEnvironment, targetPath);
            return new LocationHandle(targetPath, writePath, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
    }

    @Override
    public LocationHandle forExistingTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        HdfsContext context = new HdfsContext(session);
        Path targetPath = new Path(table.getStorage().getLocation());
        if (this.shouldUseTemporaryDirectory(session, context, targetPath, Optional.empty()) && !AcidTables.isTransactionalTable(table.getParameters())) {
            Path writePath = HiveWriteUtils.createTemporaryPath(session, context, this.hdfsEnvironment, targetPath);
            return new LocationHandle(targetPath, writePath, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
    }

    @Override
    public LocationHandle forOptimize(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        Path targetPath = new Path(table.getStorage().getLocation());
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
    }

    private boolean shouldUseTemporaryDirectory(ConnectorSession session, HdfsContext context, Path path, Optional<Path> externalLocation) {
        return HiveSessionProperties.isTemporaryStagingDirectoryEnabled(session) && !HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path) && !HiveWriteUtils.isHdfsEncrypted(context, this.hdfsEnvironment, path) && externalLocation.isEmpty();
    }

    @Override
    public LocationService.WriteInfo getQueryWriteInfo(LocationHandle locationHandle) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getTableWriteInfo(LocationHandle locationHandle, boolean overwrite) {
        if (overwrite && locationHandle.getWriteMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Overwriting unpartitioned table not supported when writing directly to target directory");
        }
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getPartitionWriteInfo(LocationHandle locationHandle, Optional<Partition> partition, String partitionName) {
        if (partition.isPresent()) {
            LocationHandle.WriteMode writeMode = locationHandle.getWriteMode();
            Path targetPath = new Path(partition.get().getStorage().getLocation());
            Path writePath = this.getPartitionWritePath(locationHandle, partitionName, writeMode, targetPath);
            return new LocationService.WriteInfo(targetPath, writePath, writeMode);
        }
        return new LocationService.WriteInfo(new Path(locationHandle.getTargetPath(), partitionName), new Path(locationHandle.getWritePath(), partitionName), locationHandle.getWriteMode());
    }

    private Path getPartitionWritePath(LocationHandle locationHandle, String partitionName, LocationHandle.WriteMode writeMode, Path targetPath) {
        switch (writeMode) {
            case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: {
                return new Path(locationHandle.getWritePath(), partitionName);
            }
            case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                return targetPath;
            }
            case DIRECT_TO_TARGET_NEW_DIRECTORY: {
                throw new UnsupportedOperationException(String.format("inserting into existing partition is not supported for %s", new Object[]{writeMode}));
            }
        }
        throw new UnsupportedOperationException("Unexpected write mode: " + writeMode);
    }
}

