/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public class MonitoredTrinoInputFile
implements TrinoInputFile {
    private final FileFormatDataSourceStats stats;
    private final TrinoInputFile delegate;

    public MonitoredTrinoInputFile(FileFormatDataSourceStats stats, TrinoInputFile delegate) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public TrinoInput newInput() throws IOException {
        return new MonitoredTrinoInput(this.stats, this.delegate.newInput());
    }

    public TrinoInputStream newStream() throws IOException {
        return new MonitoredTrinoInputStream(this.stats, this.delegate.newStream());
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public Instant lastModified() throws IOException {
        return this.delegate.lastModified();
    }

    public boolean exists() throws IOException {
        return this.delegate.exists();
    }

    public String location() {
        return this.delegate.location();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static final class MonitoredTrinoInput
    implements TrinoInput {
        private final FileFormatDataSourceStats stats;
        private final TrinoInput delegate;

        public MonitoredTrinoInput(FileFormatDataSourceStats stats, TrinoInput delegate) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
            long readStart = System.nanoTime();
            this.delegate.readFully(position, buffer, bufferOffset, bufferLength);
            this.stats.readDataBytesPerSecond(bufferLength, System.nanoTime() - readStart);
        }

        public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
            long readStart = System.nanoTime();
            int size = this.delegate.readTail(buffer, bufferOffset, bufferLength);
            this.stats.readDataBytesPerSecond(size, System.nanoTime() - readStart);
            return size;
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static final class MonitoredTrinoInputStream
    extends TrinoInputStream {
        private final FileFormatDataSourceStats stats;
        private final TrinoInputStream delegate;

        public MonitoredTrinoInputStream(FileFormatDataSourceStats stats, TrinoInputStream delegate) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public long getPosition() throws IOException {
            return this.delegate.getPosition();
        }

        public void seek(long position) throws IOException {
            this.delegate.seek(position);
        }

        public int read() throws IOException {
            long readStart = System.nanoTime();
            int value = this.delegate.read();
            this.stats.readDataBytesPerSecond(1L, System.nanoTime() - readStart);
            return value;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            long readStart = System.nanoTime();
            int size = this.delegate.read(b, off, len);
            this.stats.readDataBytesPerSecond(size, System.nanoTime() - readStart);
            return size;
        }

        public long skip(long n) throws IOException {
            long readStart = System.nanoTime();
            long size = this.delegate.skip(n);
            this.stats.readDataBytesPerSecond(size, System.nanoTime() - readStart);
            return size;
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

