/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.hive.formats.encodings.ColumnEncodingFactory;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextEncodingOptions;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.RcFileFileWriter;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class RcFileFileWriterFactory
implements HiveFileWriterFactory {
    private final DateTimeZone timeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;

    @Inject
    public RcFileFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, HiveConfig hiveConfig) {
        this(hdfsEnvironment, typeManager, nodeVersion, hiveConfig.getRcfileDateTimeZone());
    }

    public RcFileFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, DateTimeZone timeZone) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    public Optional<FileWriter> createFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, JobConf configuration, ConnectorSession session, OptionalInt bucketNumber, AcidTransaction transaction, boolean useAcidSchema, WriterKind writerKind) {
        BinaryColumnEncodingFactory columnEncodingFactory;
        if (!"org.apache.hadoop.hive.ql.io.RCFileOutputFormat".equals(storageFormat.getOutputFormat())) {
            return Optional.empty();
        }
        if ("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe".equals(storageFormat.getSerde())) {
            columnEncodingFactory = new BinaryColumnEncodingFactory(this.timeZone);
        } else if ("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe".equals(storageFormat.getSerde())) {
            columnEncodingFactory = new TextColumnEncodingFactory(TextEncodingOptions.fromSchema((Map)Maps.fromProperties((Properties)schema)));
        } else {
            return Optional.empty();
        }
        Optional<CompressionKind> compressionKind = Optional.ofNullable(configuration.get("mapreduce.output.fileoutputformat.compress.codec")).map(CompressionKind::fromHadoopClassName);
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<Type> fileColumnTypes = HiveUtil.getColumnTypes(schema).stream().map(hiveType -> hiveType.getType(this.typeManager, HiveSessionProperties.getTimestampPrecision(session))).collect(Collectors.toList());
        int[] fileInputColumnIndexes = fileColumnNames.stream().mapToInt(inputColumnNames::indexOf).toArray();
        try {
            TrinoFileSystem fileSystem = new HdfsFileSystemFactory(this.hdfsEnvironment).create(session.getIdentity());
            AggregatedMemoryContext outputStreamMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            OutputStream outputStream = fileSystem.newOutputFile(path.toString()).create(outputStreamMemoryContext);
            Optional<Supplier<TrinoInputFile>> validationInputFactory = Optional.empty();
            if (HiveSessionProperties.isRcfileOptimizedWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> fileSystem.newInputFile(path.toString()));
            }
            Closeable rollbackAction = () -> fileSystem.deleteFile(path.toString());
            return Optional.of(new RcFileFileWriter(outputStream, outputStreamMemoryContext, rollbackAction, (ColumnEncodingFactory)columnEncodingFactory, fileColumnTypes, compressionKind, fileInputColumnIndexes, (Map<String, String>)ImmutableMap.builder().put((Object)"presto_version", (Object)this.nodeVersion.toString()).put((Object)"presto_query_id", (Object)session.getQueryId()).buildOrThrow(), validationInputFactory));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating RCFile file", (Throwable)e);
        }
    }
}

