/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ReaderProjectionsAdapter {
    private final List<ChannelMapping> outputToInputMapping;
    private final List<Type> outputTypes;
    private final List<Type> inputTypes;

    public ReaderProjectionsAdapter(List<? extends ColumnHandle> expectedColumns, ReaderColumns readColumns, ColumnTypeGetter typeGetter, ProjectionGetter projectionGetter) {
        Objects.requireNonNull(expectedColumns, "expectedColumns is null");
        Objects.requireNonNull(readColumns, "readColumns is null");
        ImmutableList.Builder mappingBuilder = ImmutableList.builder();
        for (int i = 0; i < expectedColumns.size(); ++i) {
            ColumnHandle projectedColumnHandle = readColumns.getForColumnAt(i);
            int inputChannel = readColumns.getPositionForColumnAt(i);
            List<Integer> dereferences = projectionGetter.get(expectedColumns.get(i), projectedColumnHandle);
            mappingBuilder.add((Object)new ChannelMapping(inputChannel, dereferences));
        }
        this.outputToInputMapping = mappingBuilder.build();
        this.outputTypes = (List)expectedColumns.stream().map(typeGetter::get).collect(ImmutableList.toImmutableList());
        this.inputTypes = (List)readColumns.get().stream().map(typeGetter::get).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    public Page adaptPage(@Nullable Page input) {
        if (input == null) {
            return null;
        }
        Block[] blocks = new Block[this.outputToInputMapping.size()];
        for (int i = 0; i < this.outputToInputMapping.size(); ++i) {
            ChannelMapping mapping = this.outputToInputMapping.get(i);
            Block inputBlock = input.getBlock(mapping.getInputChannelIndex());
            blocks[i] = ReaderProjectionsAdapter.createAdaptedLazyBlock(inputBlock, mapping.getDereferenceSequence(), this.outputTypes.get(i));
        }
        return new Page(input.getPositionCount(), blocks);
    }

    private static Block createAdaptedLazyBlock(Block inputBlock, List<Integer> dereferenceSequence, Type type) {
        if (dereferenceSequence.size() == 0) {
            return inputBlock;
        }
        if (inputBlock == null) {
            return null;
        }
        return new LazyBlock(inputBlock.getPositionCount(), (LazyBlockLoader)new DereferenceBlockLoader(inputBlock, dereferenceSequence, type));
    }

    List<ChannelMapping> getOutputToInputMapping() {
        return this.outputToInputMapping;
    }

    List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    List<Type> getInputTypes() {
        return this.inputTypes;
    }

    public static interface ProjectionGetter {
        public List<Integer> get(ColumnHandle var1, ColumnHandle var2);
    }

    @VisibleForTesting
    static class ChannelMapping {
        private final int inputChannelIndex;
        private final List<Integer> dereferenceSequence;

        public ChannelMapping(int inputBlockIndex, List<Integer> dereferenceSequence) {
            Preconditions.checkArgument((inputBlockIndex >= 0 ? 1 : 0) != 0, (Object)"inputBlockIndex cannot be negative");
            this.inputChannelIndex = inputBlockIndex;
            this.dereferenceSequence = ImmutableList.copyOf((Collection)Objects.requireNonNull(dereferenceSequence, "dereferenceSequence is null"));
        }

        public int getInputChannelIndex() {
            return this.inputChannelIndex;
        }

        public List<Integer> getDereferenceSequence() {
            return this.dereferenceSequence;
        }
    }

    public static interface ColumnTypeGetter {
        public Type get(ColumnHandle var1);
    }

    private static class DereferenceBlockLoader
    implements LazyBlockLoader {
        private final List<Integer> dereferenceSequence;
        private final Type type;
        private boolean loaded;
        private Block inputBlock;

        DereferenceBlockLoader(Block inputBlock, List<Integer> dereferenceSequence, Type type) {
            this.inputBlock = Objects.requireNonNull(inputBlock, "inputBlock is null");
            this.dereferenceSequence = Objects.requireNonNull(dereferenceSequence, "dereferenceSequence is null");
            this.type = type;
        }

        public Block load() {
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Block loadedBlock = this.loadInternalBlock(this.dereferenceSequence, this.inputBlock);
            this.inputBlock = null;
            this.loaded = true;
            return loadedBlock;
        }

        private Block loadInternalBlock(List<Integer> dereferences, Block parentBlock) {
            if (dereferences.size() == 0) {
                return parentBlock.getLoadedBlock();
            }
            ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)parentBlock);
            int dereferenceIndex = dereferences.get(0);
            List<Integer> remainingDereferences = dereferences.subList(1, dereferences.size());
            Block fieldBlock = columnarRow.getField(dereferenceIndex);
            Block loadedInternalBlock = this.loadInternalBlock(remainingDereferences, fieldBlock);
            return this.adaptNulls(columnarRow, loadedInternalBlock);
        }

        private Block adaptNulls(ColumnarRow columnarRow, Block loadedInternalBlock) {
            if (!columnarRow.mayHaveNull()) {
                return loadedInternalBlock;
            }
            BlockBuilder newlyCreatedBlock = null;
            int fieldBlockPosition = 0;
            for (int i = 0; i < columnarRow.getPositionCount(); ++i) {
                boolean isRowNull = columnarRow.isNull(i);
                if (isRowNull) {
                    if (newlyCreatedBlock == null) {
                        newlyCreatedBlock = this.type.createBlockBuilder(null, columnarRow.getPositionCount());
                        for (int j = 0; j < i; ++j) {
                            this.type.appendTo(loadedInternalBlock, j, newlyCreatedBlock);
                        }
                    }
                    newlyCreatedBlock.appendNull();
                    continue;
                }
                if (newlyCreatedBlock != null) {
                    this.type.appendTo(loadedInternalBlock, fieldBlockPosition, newlyCreatedBlock);
                }
                ++fieldBlockPosition;
            }
            if (newlyCreatedBlock == null) {
                return loadedInternalBlock;
            }
            return newlyCreatedBlock.build();
        }
    }
}

