/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena.projection;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class Projection {
    private final String columnName;

    public Projection(String columnName) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    public String getColumnName() {
        return this.columnName;
    }

    public abstract List<String> getProjectedValues(Optional<Domain> var1);

    protected TrinoException unsupportedProjectionColumnTypeException(Type columnType) {
        return Projection.unsupportedProjectionColumnTypeException(this.columnName, columnType);
    }

    public static TrinoException unsupportedProjectionColumnTypeException(String columnName, Type columnType) {
        return Projection.invalidProjectionException(columnName, "Unsupported column type: " + columnType.getDisplayName());
    }

    public static TrinoException invalidProjectionException(String columnName, String message) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, Projection.invalidProjectionMessage(columnName, message));
    }

    public static String invalidProjectionMessage(String columnName, String message) {
        return String.format("Column projection for column '%s' failed. %s", columnName, message);
    }
}

