/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.HivePageSource;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;

public class CharCoercer
extends TypeCoercer<CharType, CharType> {
    public CharCoercer(CharType fromType, CharType toType) {
        super(fromType, toType);
        Preconditions.checkArgument((boolean)HivePageSource.narrowerThan(toType, fromType), (Object)"Coercer to a wider char type should not be required");
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        Slice value = ((CharType)this.fromType).getSlice(block, position);
        ((CharType)this.toType).writeSlice(blockBuilder, Chars.truncateToLengthAndTrimSpaces((Slice)value, (CharType)((CharType)this.toType)));
    }
}

