/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.gcs;

import io.trino.hdfs.DynamicConfigurationProvider;
import io.trino.hdfs.HdfsContext;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class GcsConfigurationProvider
implements DynamicConfigurationProvider {
    public static final String GCS_OAUTH_KEY = "hive.gcs.oauth";

    public void updateConfiguration(Configuration configuration, HdfsContext context, URI uri) {
        if (!uri.getScheme().equals("gs")) {
            return;
        }
        String accessToken = (String)context.getIdentity().getExtraCredentials().get(GCS_OAUTH_KEY);
        if (accessToken != null) {
            configuration.set("trino.gcs.oauth-access-token", accessToken);
            DynamicConfigurationProvider.setCacheKey((Configuration)configuration, (String)accessToken);
        }
    }
}

