/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.line;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.memory.MemoryInputFile;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.hive.formats.line.LineDeserializerFactory;
import io.trino.hive.formats.line.LineReader;
import io.trino.hive.formats.line.LineReaderFactory;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.MonitoredTrinoInputFile;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.line.LinePageSource;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public abstract class LinePageSourceFactory
implements HivePageSourceFactory {
    private static final DataSize SMALL_FILE_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final TrinoFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats stats;
    private final LineDeserializerFactory lineDeserializerFactory;
    private final LineReaderFactory lineReaderFactory;
    private final Predicate<ConnectorSession> activation;

    protected LinePageSourceFactory(TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, LineDeserializerFactory lineDeserializerFactory, LineReaderFactory lineReaderFactory, Predicate<ConnectorSession> activation) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.lineDeserializerFactory = Objects.requireNonNull(lineDeserializerFactory, "lineDeserializerFactory is null");
        this.activation = Objects.requireNonNull(activation, "activation is null");
        this.lineReaderFactory = Objects.requireNonNull(lineReaderFactory, "lineReaderFactory is null");
    }

    @Override
    public Optional<ReaderPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long estimatedFileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        MonitoredTrinoInputFile inputFile;
        LineDeserializer lineDeserializer;
        Optional<ReaderColumns> readerProjections;
        int footerCount;
        int headerCount;
        block19: {
            if (!(this.lineReaderFactory.getHiveOutputFormatClassName().equals(schema.getProperty("file.inputformat")) && this.lineDeserializerFactory.getHiveSerDeClassNames().contains(HiveUtil.getDeserializerClassName(schema)) && this.activation.test(session))) {
                return Optional.empty();
            }
            Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
            headerCount = HiveUtil.getHeaderCount(schema);
            if (headerCount > 1) {
                Preconditions.checkArgument((start == 0L ? 1 : 0) != 0, (Object)"Multiple header rows are not supported for a split file");
            }
            if ((footerCount = HiveUtil.getFooterCount(schema)) > 0) {
                Preconditions.checkArgument((start == 0L ? 1 : 0) != 0, (Object)"Footer not supported for a split file");
            }
            List projectedReaderColumns = columns;
            readerProjections = HivePageSourceProvider.projectBaseColumns(columns);
            if (readerProjections.isPresent()) {
                projectedReaderColumns = (List)readerProjections.get().get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            }
            lineDeserializer = LineDeserializer.EMPTY_LINE_DESERIALIZER;
            if (!columns.isEmpty()) {
                lineDeserializer = this.lineDeserializerFactory.create((List)projectedReaderColumns.stream().map(column -> new Column(column.getName(), column.getType(), column.getBaseHiveColumnIndex())).collect(ImmutableList.toImmutableList()), (Map)Maps.fromProperties((Properties)schema));
            }
            TrinoFileSystem trinoFileSystem = this.fileSystemFactory.create(session.getIdentity());
            inputFile = new MonitoredTrinoInputFile(this.stats, trinoFileSystem.newInputFile(path.toString()));
            try {
                length = Math.min(inputFile.length() - start, length);
                if (!inputFile.exists()) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "File does not exist");
                }
                if (estimatedFileSize >= SMALL_FILE_SIZE.toBytes()) break block19;
                try (TrinoInputStream inputStream = inputFile.newStream();){
                    byte[] data = inputStream.readAllBytes();
                    inputFile = new MemoryInputFile(path.toString(), Slices.wrappedBuffer((byte[])data));
                }
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, LinePageSourceFactory.splitError(e, path, start, length), (Throwable)e);
            }
        }
        if (length <= 0L) {
            return Optional.of(ReaderPageSource.noProjectionAdaptation((ConnectorPageSource)new EmptyPageSource()));
        }
        try {
            LineReader lineReader = this.lineReaderFactory.createLineReader((TrinoInputFile)inputFile, start, length, headerCount, footerCount);
            LinePageSource pageSource = new LinePageSource(lineReader, lineDeserializer, this.lineReaderFactory.createLineBuffer(), path.toString());
            return Optional.of(new ReaderPageSource(pageSource, readerProjections));
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, LinePageSourceFactory.splitError(e, path, start, length), (Throwable)e);
        }
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }
}

