/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.security.PrincipalType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Database {
    public static final String DEFAULT_DATABASE_NAME = "default";
    private final String databaseName;
    private final Optional<String> location;
    private final Optional<String> ownerName;
    private final Optional<PrincipalType> ownerType;
    private final Optional<String> comment;
    private final Map<String, String> parameters;

    @JsonCreator
    public Database(@JsonProperty(value="databaseName") String databaseName, @JsonProperty(value="location") Optional<String> location, @JsonProperty(value="ownerName") Optional<String> ownerName, @JsonProperty(value="ownerType") Optional<PrincipalType> ownerType, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="parameters") Map<String, String> parameters) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(location, "location is null");
        Preconditions.checkArgument((location.isEmpty() || !location.get().isEmpty() ? 1 : 0) != 0, (Object)"location cannot be an empty string");
        this.location = location;
        this.ownerName = Objects.requireNonNull(ownerName, "ownerName is null");
        this.ownerType = Objects.requireNonNull(ownerType, "ownerType is null");
        Preconditions.checkArgument((ownerName.isPresent() == ownerType.isPresent() ? 1 : 0) != 0, (Object)"Both ownerName and ownerType must be present or empty");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @JsonProperty
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty
    public Optional<String> getLocation() {
        return this.location;
    }

    @JsonProperty
    public Optional<String> getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty
    public Optional<PrincipalType> getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Database database) {
        return new Builder(database);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("location", this.location).add("ownerName", this.ownerName).add("ownerType", this.ownerType).add("comment", this.comment).add("parameters", this.parameters).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Database database = (Database)o;
        return Objects.equals(this.databaseName, database.databaseName) && Objects.equals(this.location, database.location) && Objects.equals(this.ownerName, database.ownerName) && Objects.equals(this.ownerType, database.ownerType) && Objects.equals(this.comment, database.comment) && Objects.equals(this.parameters, database.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.location, this.ownerName, this.ownerType, this.comment, this.parameters);
    }

    public static class Builder {
        private String databaseName;
        private Optional<String> location = Optional.empty();
        private Optional<String> ownerName;
        private Optional<PrincipalType> ownerType;
        private Optional<String> comment = Optional.empty();
        private Map<String, String> parameters = new LinkedHashMap<String, String>();

        public Builder() {
        }

        public Builder(Database database) {
            this.databaseName = database.databaseName;
            this.location = database.location;
            this.ownerName = database.ownerName;
            this.ownerType = database.ownerType;
            this.comment = database.comment;
            this.parameters = database.parameters;
        }

        public Builder setDatabaseName(String databaseName) {
            Objects.requireNonNull(databaseName, "databaseName is null");
            this.databaseName = databaseName;
            return this;
        }

        public Builder setLocation(Optional<String> location) {
            Objects.requireNonNull(location, "location is null");
            this.location = location;
            return this;
        }

        public Builder setOwnerName(Optional<String> ownerName) {
            Objects.requireNonNull(ownerName, "ownerName is null");
            this.ownerName = ownerName;
            return this;
        }

        public Builder setOwnerType(Optional<PrincipalType> ownerType) {
            Objects.requireNonNull(ownerType, "ownerType is null");
            this.ownerType = ownerType;
            return this;
        }

        public Builder setComment(Optional<String> comment) {
            Objects.requireNonNull(comment, "comment is null");
            this.comment = comment;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            Objects.requireNonNull(parameters, "parameters is null");
            this.parameters = parameters;
            return this;
        }

        public Database build() {
            return new Database(this.databaseName, this.location, this.ownerName, this.ownerType, this.comment, this.parameters);
        }
    }
}

