/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.plugin.hive.metastore.HivePrincipal;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UserTableKey {
    private final Optional<HivePrincipal> principal;
    private final String database;
    private final String table;
    private final Optional<String> owner;

    @JsonCreator
    public UserTableKey(@JsonProperty(value="principal") Optional<HivePrincipal> principal, @JsonProperty(value="database") String database, @JsonProperty(value="table") String table, @JsonProperty(value="owner") Optional<String> owner) {
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.database = Objects.requireNonNull(database, "database is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
    }

    @JsonProperty
    public Optional<HivePrincipal> getPrincipal() {
        return this.principal;
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public Optional<String> getOwner() {
        return this.owner;
    }

    public boolean matches(String databaseName, String tableName) {
        return this.database.equals(databaseName) && this.table.equals(tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTableKey that = (UserTableKey)o;
        return Objects.equals(this.principal, that.principal) && Objects.equals(this.table, that.table) && Objects.equals(this.database, that.database) && Objects.equals(this.owner, that.owner);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.table, this.database, this.owner);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("principal", this.principal).add("table", (Object)this.table).add("database", (Object)this.database).add("owner", this.owner.orElse(null)).toString();
    }
}

