/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.AWSGlueAsync;
import io.trino.plugin.hive.metastore.glue.DefaultGlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.ForGlueColumnStatisticsRead;
import io.trino.plugin.hive.metastore.glue.ForGlueColumnStatisticsWrite;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class DefaultGlueColumnStatisticsProviderFactory
implements GlueColumnStatisticsProviderFactory {
    private final Executor statisticsReadExecutor;
    private final Executor statisticsWriteExecutor;

    @Inject
    public DefaultGlueColumnStatisticsProviderFactory(@ForGlueColumnStatisticsRead Executor statisticsReadExecutor, @ForGlueColumnStatisticsWrite Executor statisticsWriteExecutor) {
        this.statisticsReadExecutor = Objects.requireNonNull(statisticsReadExecutor, "statisticsReadExecutor is null");
        this.statisticsWriteExecutor = Objects.requireNonNull(statisticsWriteExecutor, "statisticsWriteExecutor is null");
    }

    @Override
    public GlueColumnStatisticsProvider createGlueColumnStatisticsProvider(AWSGlueAsync glueClient, GlueMetastoreStats stats) {
        return new DefaultGlueColumnStatisticsProvider(glueClient, this.statisticsReadExecutor, this.statisticsWriteExecutor, stats);
    }
}

