/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.procedure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class FlushHiveMetastoreCacheProcedure
implements Provider<Procedure> {
    private static final String PROCEDURE_NAME = "flush_metadata_cache";
    private static final String PARAM_SCHEMA_NAME = "SCHEMA_NAME";
    private static final String PARAM_TABLE_NAME = "TABLE_NAME";
    @Deprecated
    private static final String PARAM_PARTITION_COLUMN = "PARTITION_COLUMN";
    @Deprecated
    private static final String PARAM_PARTITION_VALUE = "PARTITION_VALUE";
    private static final String PARAM_PARTITION_COLUMNS = "PARTITION_COLUMNS";
    private static final String PARAM_PARTITION_VALUES = "PARTITION_VALUES";
    private static final String PROCEDURE_USAGE_EXAMPLES = String.format("Valid usages:%n - '%1$s()'%n - %1$s(%2$s => ..., %3$s => ...) - %1$s(%2$s => ..., %3$s => ..., %4$s => ARRAY['...'], %5$s => ARRAY['...'])", "flush_metadata_cache", "SCHEMA_NAME".toLowerCase(Locale.ENGLISH), "TABLE_NAME".toLowerCase(Locale.ENGLISH), "PARTITION_COLUMNS".toLowerCase(Locale.ENGLISH), "PARTITION_VALUES".toLowerCase(Locale.ENGLISH));
    private static final String INVALID_PARTITION_PARAMS_ERROR_MESSAGE = String.format("Procedure should only be invoked with single pair of partition definition named params: %1$s and %2$s or %3$s and %4$s", "PARTITION_COLUMNS".toLowerCase(Locale.ENGLISH), "PARTITION_VALUES".toLowerCase(Locale.ENGLISH), "PARTITION_COLUMN".toLowerCase(Locale.ENGLISH), "PARTITION_VALUE".toLowerCase(Locale.ENGLISH));
    private static final MethodHandle FLUSH_HIVE_METASTORE_CACHE;
    private final Optional<CachingHiveMetastore> cachingHiveMetastore;

    @Inject
    public FlushHiveMetastoreCacheProcedure(Optional<CachingHiveMetastore> cachingHiveMetastore) {
        this.cachingHiveMetastore = Objects.requireNonNull(cachingHiveMetastore, "cachingHiveMetastore is null");
    }

    public Procedure get() {
        return new Procedure("system", PROCEDURE_NAME, (List)ImmutableList.of((Object)new Procedure.Argument(PARAM_SCHEMA_NAME, (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument(PARAM_TABLE_NAME, (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument(PARAM_PARTITION_COLUMNS, (Type)new ArrayType((Type)VarcharType.VARCHAR), false, null), (Object)new Procedure.Argument(PARAM_PARTITION_VALUES, (Type)new ArrayType((Type)VarcharType.VARCHAR), false, null), (Object)new Procedure.Argument(PARAM_PARTITION_COLUMN, (Type)new ArrayType((Type)VarcharType.VARCHAR), false, null), (Object)new Procedure.Argument(PARAM_PARTITION_VALUE, (Type)new ArrayType((Type)VarcharType.VARCHAR), false, null)), FLUSH_HIVE_METASTORE_CACHE.bindTo(this), true);
    }

    public void flushMetadataCache(String schemaName, String tableName, List<String> partitionColumns, List<String> partitionValues, List<String> partitionColumn, List<String> partitionValue) {
        Optional<List<String>> optionalPartitionValue;
        Optional<List<String>> optionalPartitionColumn;
        Optional<List<String>> optionalPartitionValues;
        Optional<List<String>> optionalPartitionColumns = Optional.ofNullable(partitionColumns);
        Preconditions.checkState((this.partitionParamsUsed(optionalPartitionColumns, optionalPartitionValues = Optional.ofNullable(partitionValues), optionalPartitionColumn = Optional.ofNullable(partitionColumn), optionalPartitionValue = Optional.ofNullable(partitionValue)) || this.deprecatedPartitionParamsUsed(optionalPartitionColumns, optionalPartitionValues, optionalPartitionColumn, optionalPartitionValue) || this.partitionParamsNotUsed(optionalPartitionColumns, optionalPartitionValues, optionalPartitionColumn, optionalPartitionValue) ? 1 : 0) != 0, (Object)INVALID_PARTITION_PARAMS_ERROR_MESSAGE);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doFlushMetadataCache(Optional.ofNullable(schemaName), Optional.ofNullable(tableName), optionalPartitionColumns.or(() -> optionalPartitionColumn).orElse((List<String>)ImmutableList.of()), optionalPartitionValues.or(() -> optionalPartitionValue).orElse((List<String>)ImmutableList.of()));
        }
    }

    private void doFlushMetadataCache(Optional<String> schemaName, Optional<String> tableName, List<String> partitionColumns, List<String> partitionValues) {
        CachingHiveMetastore cachingHiveMetastore = this.cachingHiveMetastore.orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Cannot flush, metastore cache is not enabled"));
        Preconditions.checkState((partitionColumns.size() == partitionValues.size() ? 1 : 0) != 0, (Object)"Parameters partition_column and partition_value should have same length");
        if (schemaName.isEmpty() && tableName.isEmpty() && partitionColumns.isEmpty()) {
            cachingHiveMetastore.flushCache();
        } else if (schemaName.isPresent() && tableName.isPresent()) {
            if (!partitionColumns.isEmpty()) {
                cachingHiveMetastore.flushPartitionCache(schemaName.get(), tableName.get(), partitionColumns, partitionValues);
            } else {
                cachingHiveMetastore.invalidateTable(schemaName.get(), tableName.get());
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Illegal parameter set passed. " + PROCEDURE_USAGE_EXAMPLES);
        }
    }

    private boolean partitionParamsNotUsed(Optional<List<String>> partitionColumns, Optional<List<String>> partitionValues, Optional<List<String>> partitionColumn, Optional<List<String>> partitionValue) {
        return partitionColumns.isEmpty() && partitionValues.isEmpty() && partitionColumn.isEmpty() && partitionValue.isEmpty();
    }

    private boolean partitionParamsUsed(Optional<List<String>> partitionColumns, Optional<List<String>> partitionValues, Optional<List<String>> partitionColumn, Optional<List<String>> partitionValue) {
        return (partitionColumns.isPresent() || partitionValues.isPresent()) && partitionColumn.isEmpty() && partitionValue.isEmpty();
    }

    private boolean deprecatedPartitionParamsUsed(Optional<List<String>> partitionColumns, Optional<List<String>> partitionValues, Optional<List<String>> partitionColumn, Optional<List<String>> partitionValue) {
        return (partitionColumn.isPresent() || partitionValue.isPresent()) && partitionColumns.isEmpty() && partitionValues.isEmpty();
    }

    static {
        try {
            FLUSH_HIVE_METASTORE_CACHE = MethodHandles.lookup().unreflect(FlushHiveMetastoreCacheProcedure.class.getMethod("flushMetadataCache", String.class, String.class, List.class, List.class, List.class, List.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

