/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hive.formats.ReadWriteUtils;
import io.trino.plugin.hive.ForHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.MetastoreKerberosConfig;
import io.trino.plugin.hive.metastore.thrift.TUgiAssumingTransport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class KerberosHiveMetastoreAuthentication
implements HiveMetastoreAuthentication {
    private final String hiveMetastoreServicePrincipal;
    private final HadoopAuthentication authentication;

    @Inject
    public KerberosHiveMetastoreAuthentication(MetastoreKerberosConfig config, @ForHiveMetastore HadoopAuthentication authentication) {
        this(config.getHiveMetastoreServicePrincipal(), authentication);
    }

    public KerberosHiveMetastoreAuthentication(String hiveMetastoreServicePrincipal, HadoopAuthentication authentication) {
        this.hiveMetastoreServicePrincipal = Objects.requireNonNull(hiveMetastoreServicePrincipal, "hiveMetastoreServicePrincipal is null");
        this.authentication = Objects.requireNonNull(authentication, "authentication is null");
    }

    @Override
    public TTransport authenticate(TTransport rawTransport, String hiveMetastoreHost, Optional<String> delegationToken) {
        try {
            String serverPrincipal = SecurityUtil.getServerPrincipal((String)this.hiveMetastoreServicePrincipal, (String)hiveMetastoreHost);
            String[] names = serverPrincipal.split("[/@]");
            Preconditions.checkState((names.length == 3 ? 1 : 0) != 0, (String)"Kerberos principal name does NOT have the expected hostname part: %s", (Object)serverPrincipal);
            ImmutableMap saslProps = ImmutableMap.of((Object)"javax.security.sasl.qop", (Object)"auth-conf,auth", (Object)"javax.security.sasl.server.authentication", (Object)"true");
            TSaslClientTransport saslTransport = delegationToken.isPresent() ? new TSaslClientTransport("DIGEST-MD5", null, null, "default", (Map)saslProps, (CallbackHandler)new SaslClientCallbackHandler(delegationToken.get()), rawTransport) : new TSaslClientTransport("GSSAPI", null, names[0], names[1], (Map)saslProps, null, rawTransport);
            return new TUgiAssumingTransport((TTransport)saslTransport, this.authentication.getUserGroupInformation());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (TTransportException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public SaslClientCallbackHandler(String token) {
            byte[] decoded = Base64.getUrlDecoder().decode(token);
            BasicSliceInput in = new BasicSliceInput(Slices.wrappedBuffer((byte[])decoded));
            byte[] username = new byte[Math.toIntExact(ReadWriteUtils.readVInt((SliceInput)in))];
            in.readFully(username);
            byte[] password = new byte[Math.toIntExact(ReadWriteUtils.readVInt((SliceInput)in))];
            in.readFully(password);
            this.username = Base64.getEncoder().encodeToString(username);
            this.password = Base64.getEncoder().encodeToString(password);
        }

        @Override
        public void handle(Callback[] callbacks) {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.username);
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    passwordCallback.setPassword(this.password.toCharArray());
                }
                if (!(callback instanceof RealmCallback)) continue;
                RealmCallback realmCallback = (RealmCallback)callback;
                realmCallback.setText(realmCallback.getDefaultText());
            }
        }
    }
}

