/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;

public class ParquetWriterConfig {
    private boolean parquetOptimizedWriterEnabled;
    private DataSize blockSize = DataSize.ofBytes((long)0x8000000L);
    private DataSize pageSize = DataSize.ofBytes((long)0x100000L);
    private int batchSize = 10000;
    private double validationPercentage = 5.0;

    public DataSize getBlockSize() {
        return this.blockSize;
    }

    @Config(value="parquet.writer.block-size")
    @LegacyConfig(value={"hive.parquet.writer.block-size"})
    public ParquetWriterConfig setBlockSize(DataSize blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public DataSize getPageSize() {
        return this.pageSize;
    }

    @Config(value="parquet.writer.page-size")
    @LegacyConfig(value={"hive.parquet.writer.page-size"})
    public ParquetWriterConfig setPageSize(DataSize pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public boolean isParquetOptimizedWriterEnabled() {
        return this.parquetOptimizedWriterEnabled;
    }

    @Config(value="parquet.optimized-writer.enabled")
    @LegacyConfig(value={"hive.parquet.optimized-writer.enabled", "parquet.experimental-optimized-writer.enabled"})
    @ConfigDescription(value="Enable optimized Parquet writer")
    public ParquetWriterConfig setParquetOptimizedWriterEnabled(boolean parquetOptimizedWriterEnabled) {
        this.parquetOptimizedWriterEnabled = parquetOptimizedWriterEnabled;
        return this;
    }

    @Config(value="parquet.writer.batch-size")
    @ConfigDescription(value="Maximum number of rows passed to the writer in each batch")
    public ParquetWriterConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="100.0") double getValidationPercentage() {
        return this.validationPercentage;
    }

    @Config(value="parquet.optimized-writer.validation-percentage")
    @ConfigDescription(value="Percentage of parquet files to validate after write by re-reading the whole file")
    public ParquetWriterConfig setValidationPercentage(double validationPercentage) {
        this.validationPercentage = validationPercentage;
        return this;
    }
}

