/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.rcfile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.filesystem.memory.MemoryInputFile;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.encodings.ColumnEncodingFactory;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextEncodingOptions;
import io.trino.hive.formats.rcfile.RcFileReader;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.MonitoredTrinoInputFile;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.rcfile.RcFilePageSource;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class RcFilePageSourceFactory
implements HivePageSourceFactory {
    private static final DataSize BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final DateTimeZone timeZone;

    @Inject
    public RcFilePageSourceFactory(TypeManager typeManager, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, HiveConfig hiveConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.timeZone = hiveConfig.getRcfileDateTimeZone();
    }

    public static Properties stripUnnecessaryProperties(Properties schema) {
        if ("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe".equals(HiveUtil.getDeserializerClassName(schema))) {
            Properties stripped = new Properties();
            stripped.put("serialization.lib", schema.getProperty("serialization.lib"));
            return stripped;
        }
        return schema;
    }

    @Override
    public Optional<ReaderPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long estimatedFileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        MonitoredTrinoInputFile inputFile;
        Optional<ReaderColumns> readerProjections;
        List projectedReaderColumns;
        BinaryColumnEncodingFactory columnEncodingFactory;
        block21: {
            String deserializerClassName = HiveUtil.getDeserializerClassName(schema);
            if (deserializerClassName.equals("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe")) {
                columnEncodingFactory = new BinaryColumnEncodingFactory(this.timeZone);
            } else if (deserializerClassName.equals("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe")) {
                columnEncodingFactory = new TextColumnEncodingFactory(TextEncodingOptions.fromSchema((Map)Maps.fromProperties((Properties)schema)));
            } else {
                return Optional.empty();
            }
            Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
            projectedReaderColumns = columns;
            readerProjections = HivePageSourceProvider.projectBaseColumns(columns);
            if (readerProjections.isPresent()) {
                projectedReaderColumns = (List)readerProjections.get().get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            }
            TrinoFileSystem trinoFileSystem = new HdfsFileSystemFactory(this.hdfsEnvironment).create(session.getIdentity());
            inputFile = new MonitoredTrinoInputFile(this.stats, trinoFileSystem.newInputFile(path.toString()));
            try {
                length = Math.min(inputFile.length() - start, length);
                if (!inputFile.exists()) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "File does not exist");
                }
                if (estimatedFileSize >= BUFFER_SIZE.toBytes()) break block21;
                try (TrinoInputStream inputStream = inputFile.newStream();){
                    byte[] data = inputStream.readAllBytes();
                    inputFile = new MemoryInputFile(path.toString(), Slices.wrappedBuffer((byte[])data));
                }
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, RcFilePageSourceFactory.splitError(e, path, start, length), (Throwable)e);
            }
        }
        if (length <= 0L) {
            return Optional.of(ReaderPageSource.noProjectionAdaptation((ConnectorPageSource)new EmptyPageSource()));
        }
        try {
            ImmutableMap.Builder readColumns = ImmutableMap.builder();
            HiveTimestampPrecision timestampPrecision = HiveSessionProperties.getTimestampPrecision(session);
            for (HiveColumnHandle column : projectedReaderColumns) {
                readColumns.put((Object)column.getBaseHiveColumnIndex(), (Object)column.getHiveType().getType(this.typeManager, timestampPrecision));
            }
            RcFileReader rcFileReader = new RcFileReader((TrinoInputFile)inputFile, (ColumnEncodingFactory)columnEncodingFactory, (Map)readColumns.buildOrThrow(), start, length);
            RcFilePageSource pageSource = new RcFilePageSource(rcFileReader, projectedReaderColumns);
            return Optional.of(new ReaderPageSource(pageSource, readerProjections));
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (Throwable e) {
            String message = RcFilePageSourceFactory.splitError(e, path, start, length);
            if (e instanceof FileCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, message, e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, e);
        }
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }
}

