/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.amazonaws.auth.BasicAWSCredentials;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.s3.TrinoS3FileSystem;
import io.trino.spi.security.ConnectorIdentity;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class S3SecurityMapping {
    private final Predicate<String> user;
    private final Predicate<Collection<String>> group;
    private final Predicate<URI> prefix;
    private final Optional<String> iamRole;
    private final Set<String> allowedIamRoles;
    private final Optional<String> kmsKeyId;
    private final Set<String> allowedKmsKeyIds;
    private final Optional<BasicAWSCredentials> credentials;
    private final boolean useClusterDefault;
    private final Optional<String> endpoint;
    private final Optional<String> roleSessionName;

    @JsonCreator
    public S3SecurityMapping(@JsonProperty(value="user") Optional<Pattern> user, @JsonProperty(value="group") Optional<Pattern> group, @JsonProperty(value="prefix") Optional<URI> prefix, @JsonProperty(value="iamRole") Optional<String> iamRole, @JsonProperty(value="roleSessionName") Optional<String> roleSessionName, @JsonProperty(value="allowedIamRoles") Optional<List<String>> allowedIamRoles, @JsonProperty(value="kmsKeyId") Optional<String> kmsKeyId, @JsonProperty(value="allowedKmsKeyIds") Optional<List<String>> allowedKmsKeyIds, @JsonProperty(value="accessKey") Optional<String> accessKey, @JsonProperty(value="secretKey") Optional<String> secretKey, @JsonProperty(value="useClusterDefault") Optional<Boolean> useClusterDefault, @JsonProperty(value="endpoint") Optional<String> endpoint) {
        this.user = user.map(S3SecurityMapping::toPredicate).orElse(x -> true);
        this.group = group.map(S3SecurityMapping::toPredicate).map(S3SecurityMapping::anyMatch).orElse(x -> true);
        this.prefix = prefix.map(S3SecurityMapping::prefixPredicate).orElse(x -> true);
        this.iamRole = Objects.requireNonNull(iamRole, "iamRole is null");
        this.roleSessionName = Objects.requireNonNull(roleSessionName, "roleSessionName is null");
        Preconditions.checkArgument((!iamRole.isEmpty() || !roleSessionName.isPresent() ? 1 : 0) != 0, (Object)"iamRole must be provided when roleSessionName is provided");
        this.allowedIamRoles = ImmutableSet.copyOf((Collection)allowedIamRoles.orElse((List<String>)ImmutableList.of()));
        this.kmsKeyId = Objects.requireNonNull(kmsKeyId, "kmsKeyId is null");
        this.allowedKmsKeyIds = ImmutableSet.copyOf((Collection)allowedKmsKeyIds.orElse((List<String>)ImmutableList.of()));
        Objects.requireNonNull(accessKey, "accessKey is null");
        Objects.requireNonNull(secretKey, "secretKey is null");
        Preconditions.checkArgument((accessKey.isPresent() == secretKey.isPresent() ? 1 : 0) != 0, (Object)"accessKey and secretKey must be provided together");
        this.credentials = accessKey.map(access -> new BasicAWSCredentials(access, (String)secretKey.get()));
        this.useClusterDefault = useClusterDefault.orElse(false);
        boolean roleOrCredentialsArePresent = !this.allowedIamRoles.isEmpty() || iamRole.isPresent() || this.credentials.isPresent();
        Preconditions.checkArgument((boolean)(this.useClusterDefault ^ roleOrCredentialsArePresent), (Object)"must either allow useClusterDefault role or provide role and/or credentials");
        Preconditions.checkArgument((!this.useClusterDefault || !this.kmsKeyId.isPresent() ? 1 : 0) != 0, (Object)"KMS key ID cannot be provided together with useClusterDefault");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint is null");
    }

    public boolean matches(ConnectorIdentity identity, URI uri) {
        return this.user.test(identity.getUser()) && this.group.test(identity.getGroups()) && this.prefix.test(uri);
    }

    public Optional<String> getIamRole() {
        return this.iamRole;
    }

    public Set<String> getAllowedIamRoles() {
        return this.allowedIamRoles;
    }

    public Optional<String> getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Set<String> getAllowedKmsKeyIds() {
        return this.allowedKmsKeyIds;
    }

    public Optional<BasicAWSCredentials> getCredentials() {
        return this.credentials;
    }

    public boolean isUseClusterDefault() {
        return this.useClusterDefault;
    }

    public Optional<String> getEndpoint() {
        return this.endpoint;
    }

    public Optional<String> getRoleSessionName() {
        return this.roleSessionName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", this.user).add("group", this.group).add("prefix", this.prefix).add("iamRole", this.iamRole).add("roleSessionName", this.roleSessionName.orElse(null)).add("allowedIamRoles", this.allowedIamRoles).add("kmsKeyId", this.kmsKeyId).add("allowedKmsKeyIds", this.allowedKmsKeyIds).add("credentials", this.credentials).add("useClusterDefault", this.useClusterDefault).add("endpoint", this.endpoint.orElse(null)).toString();
    }

    private static Predicate<URI> prefixPredicate(URI prefix) {
        Preconditions.checkArgument((boolean)"s3".equals(prefix.getScheme()), (String)"prefix URI scheme is not 's3': %s", (Object)prefix);
        Preconditions.checkArgument((prefix.getQuery() == null ? 1 : 0) != 0, (String)"prefix URI must not contain query: %s", (Object)prefix);
        Preconditions.checkArgument((prefix.getFragment() == null ? 1 : 0) != 0, (String)"prefix URI must not contain fragment: %s", (Object)prefix);
        return value -> TrinoS3FileSystem.extractBucketName(prefix).equals(TrinoS3FileSystem.extractBucketName(value)) && value.getPath().startsWith(prefix.getPath());
    }

    private static Predicate<String> toPredicate(Pattern pattern) {
        return value -> pattern.matcher((CharSequence)value).matches();
    }

    private static <T> Predicate<Collection<T>> anyMatch(Predicate<T> predicate) {
        return values -> values.stream().anyMatch(predicate);
    }
}

