/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.trino.hdfs.ConfigurationUtils;
import io.trino.orc.OrcWriter;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveWriterFactory;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidSchema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.orc.OrcFileWriter;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public abstract class AbstractHiveAcidWriters {
    protected static final Block DELETE_OPERATION_BLOCK = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcWriter.OrcOperation.DELETE.getOperationNumber());
    protected static final Block INSERT_OPERATION_BLOCK = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcWriter.OrcOperation.INSERT.getOperationNumber());
    public static final Pattern BUCKET_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<dirStart>delta_[\\d]+_[\\d]+)_(?<statementId>[\\d]+)/(?<filenameBase>bucket_(?<bucketNumber>[\\d]+))(?<attemptId>_[\\d]+)?$");
    public static final Pattern ORIGINAL_FILE_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<filename>(?<bucketNumber>[\\d]+)_(?<rest>.*)?)$");
    public static final Pattern BASE_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<dirStart>base_[-]?[\\d]+(_v[\\d]+)?)/(?<filenameBase>bucket_(?<bucketNumber>[\\d]+))(?<attemptId>_[\\d]+)?$");
    protected final AcidTransaction transaction;
    protected final OptionalInt bucketNumber;
    protected final int statementId;
    protected final Block bucketValueBlock;
    private final Optional<HiveWriterFactory.RowIdSortingFileWriterMaker> sortingFileWriterMaker;
    private final OrcFileWriterFactory orcFileWriterFactory;
    private final Configuration configuration;
    protected final ConnectorSession session;
    private final AcidOperation updateKind;
    private final Properties hiveAcidSchema;
    protected final Block hiveRowTypeNullsBlock;
    protected Path deltaDirectory;
    protected final Path deleteDeltaDirectory;
    private final String bucketFilename;
    protected Optional<FileWriter> deleteFileWriter = Optional.empty();
    protected Optional<FileWriter> insertFileWriter = Optional.empty();

    public AbstractHiveAcidWriters(AcidTransaction transaction, int statementId, OptionalInt bucketNumber, Optional<HiveWriterFactory.RowIdSortingFileWriterMaker> sortingFileWriterMaker, Path bucketPath, boolean originalFile, OrcFileWriterFactory orcFileWriterFactory, Configuration configuration, ConnectorSession session, TypeManager typeManager, HiveType hiveRowType, AcidOperation updateKind) {
        Matcher matcher;
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.statementId = statementId;
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.sortingFileWriterMaker = Objects.requireNonNull(sortingFileWriterMaker, "sortingFileWriterMaker is null");
        this.bucketValueBlock = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcFileWriter.computeBucketValue(bucketNumber.orElse(0), statementId));
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.session = Objects.requireNonNull(session, "session is null");
        Preconditions.checkArgument((boolean)transaction.isTransactional(), (String)"Not in a transaction: %s", (Object)transaction);
        this.updateKind = Objects.requireNonNull(updateKind, "updateKind is null");
        this.hiveAcidSchema = AcidSchema.createAcidSchema(hiveRowType);
        this.hiveRowTypeNullsBlock = Utils.nativeValueToBlock((Type)hiveRowType.getType(typeManager), null);
        Objects.requireNonNull(bucketPath, "bucketPath is null");
        Preconditions.checkArgument((updateKind != AcidOperation.MERGE || sortingFileWriterMaker.isPresent() ? 1 : 0) != 0, (Object)"updateKind is MERGE but sortingFileWriterMaker is not present");
        if (originalFile) {
            matcher = ORIGINAL_FILE_PATH_MATCHER.matcher(bucketPath.toString());
            Preconditions.checkArgument((boolean)matcher.matches(), (String)"Original file bucketPath doesn't have the required format: %s", (Object)bucketPath);
            this.bucketFilename = String.format("bucket_%05d", bucketNumber.isEmpty() ? 0 : bucketNumber.getAsInt());
        } else {
            matcher = BASE_PATH_MATCHER.matcher(bucketPath.toString());
            if (matcher.matches()) {
                this.bucketFilename = matcher.group("filenameBase");
            } else {
                matcher = BUCKET_PATH_MATCHER.matcher(bucketPath.toString());
                Preconditions.checkArgument((boolean)matcher.matches(), (String)"bucketPath doesn't have the required format: %s", (Object)bucketPath);
                this.bucketFilename = matcher.group("filenameBase");
            }
        }
        long writeId = transaction.getWriteId();
        this.deltaDirectory = new Path(String.format("%s/%s", matcher.group("rootDir"), AcidTables.deltaSubdir(writeId, statementId)));
        this.deleteDeltaDirectory = new Path(String.format("%s/%s", matcher.group("rootDir"), AcidTables.deleteDeltaSubdir(writeId, statementId)));
    }

    protected Page buildDeletePage(Block rowIds, long writeId) {
        return AbstractHiveAcidWriters.buildDeletePage(rowIds, writeId, this.hiveRowTypeNullsBlock);
    }

    @VisibleForTesting
    public static Page buildDeletePage(Block rowIdsRowBlock, long writeId, Block rowTypeNullsBlock) {
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)rowIdsRowBlock);
        Preconditions.checkArgument((!columnarRow.mayHaveNull() ? 1 : 0) != 0, (Object)"The rowIdsRowBlock may not have null rows");
        int positionCount = rowIdsRowBlock.getPositionCount();
        Block[] blockArray = new Block[]{RunLengthEncodedBlock.create((Block)DELETE_OPERATION_BLOCK, (int)positionCount), columnarRow.getField(0), columnarRow.getField(1), columnarRow.getField(2), RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)writeId, (int)positionCount), RunLengthEncodedBlock.create((Block)rowTypeNullsBlock, (int)positionCount)};
        return new Page(blockArray);
    }

    @VisibleForTesting
    public static Block createRowIdBlock(int positionCount, int rowCounter) {
        long[] rowIds = new long[positionCount];
        for (int index = 0; index < positionCount; ++index) {
            rowIds[index] = rowCounter;
            ++rowCounter;
        }
        return new LongArrayBlock(positionCount, Optional.empty(), rowIds);
    }

    protected FileWriter getOrCreateDeleteFileWriter() {
        if (this.deleteFileWriter.isEmpty()) {
            Properties schemaCopy = new Properties();
            schemaCopy.putAll((Map<?, ?>)this.hiveAcidSchema);
            Path deletePath = new Path(String.format("%s/%s", this.deleteDeltaDirectory, this.bucketFilename));
            this.deleteFileWriter = this.orcFileWriterFactory.createFileWriter(deletePath, AcidSchema.ACID_COLUMN_NAMES, StorageFormat.fromHiveStorageFormat(HiveStorageFormat.ORC), schemaCopy, ConfigurationUtils.toJobConf((Configuration)this.configuration), this.session, this.bucketNumber, this.transaction, true, WriterKind.DELETE);
            if (this.updateKind == AcidOperation.MERGE) {
                this.deleteFileWriter = Optional.of(this.sortingFileWriterMaker.orElseThrow(() -> new IllegalArgumentException("sortingFileWriterMaker not present")).makeFileWriter(this.getWriter(this.deleteFileWriter), deletePath));
            }
        }
        return this.getWriter(this.deleteFileWriter);
    }

    private FileWriter getWriter(Optional<FileWriter> writer) {
        return writer.orElseThrow(() -> new IllegalArgumentException("writer is not present"));
    }

    protected FileWriter getOrCreateInsertFileWriter() {
        if (this.insertFileWriter.isEmpty()) {
            Properties schemaCopy = new Properties();
            schemaCopy.putAll((Map<?, ?>)this.hiveAcidSchema);
            this.insertFileWriter = this.orcFileWriterFactory.createFileWriter(new Path(String.format("%s/%s", this.deltaDirectory, this.bucketFilename)), AcidSchema.ACID_COLUMN_NAMES, StorageFormat.fromHiveStorageFormat(HiveStorageFormat.ORC), schemaCopy, ConfigurationUtils.toJobConf((Configuration)this.configuration), this.session, this.bucketNumber, this.transaction, true, WriterKind.INSERT);
        }
        return this.getWriter(this.insertFileWriter);
    }
}

