/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.util.ForwardingRecordCursor;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.Path;

public class HiveBucketValidationRecordCursor
extends ForwardingRecordCursor {
    private final RecordCursor delegate;
    private final Path path;
    private final int[] bucketColumnIndices;
    private final List<Class<?>> javaTypeList;
    private final List<TypeInfo> typeInfoList;
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int bucketCount;
    private final int expectedBucket;
    private final Object[] scratch;
    private int validationCounter;

    public HiveBucketValidationRecordCursor(Path path, int[] bucketColumnIndices, List<HiveType> bucketColumnTypes, HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, int expectedBucket, TypeManager typeManager, RecordCursor delegate) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.bucketColumnIndices = Objects.requireNonNull(bucketColumnIndices, "bucketColumnIndices is null");
        Objects.requireNonNull(bucketColumnTypes, "bucketColumnTypes is null");
        this.javaTypeList = (List)bucketColumnTypes.stream().map(HiveType::getTypeSignature).map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).map(Type::getJavaType).collect(ImmutableList.toImmutableList());
        this.typeInfoList = (List)bucketColumnTypes.stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.bucketCount = bucketCount;
        this.expectedBucket = expectedBucket;
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.scratch = new Object[bucketColumnTypes.size()];
    }

    @Override
    @VisibleForTesting
    public RecordCursor delegate() {
        return this.delegate;
    }

    @Override
    public boolean advanceNextPosition() {
        if (!this.delegate.advanceNextPosition()) {
            return false;
        }
        if (this.validationCounter > 0) {
            --this.validationCounter;
            return true;
        }
        this.validationCounter = 96;
        for (int i = 0; i < this.scratch.length; ++i) {
            int index = this.bucketColumnIndices[i];
            if (this.delegate.isNull(index)) {
                this.scratch[i] = null;
                continue;
            }
            Class<?> javaType = this.javaTypeList.get(i);
            if (javaType == Boolean.TYPE) {
                this.scratch[i] = this.delegate.getBoolean(index);
                continue;
            }
            if (javaType == Long.TYPE) {
                this.scratch[i] = this.delegate.getLong(index);
                continue;
            }
            if (javaType == Double.TYPE) {
                this.scratch[i] = this.delegate.getDouble(index);
                continue;
            }
            if (javaType == Slice.class) {
                this.scratch[i] = this.delegate.getSlice(index);
                continue;
            }
            if (javaType == Block.class) {
                this.scratch[i] = this.delegate.getObject(index);
                continue;
            }
            throw new VerifyException("Unknown Java type: " + javaType);
        }
        int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.bucketCount, this.typeInfoList, this.scratch);
        if (bucket != this.expectedBucket) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table is corrupt. File '%s' is for bucket %s, but contains a row for bucket %s.", this.path, this.expectedBucket, bucket));
        }
        return true;
    }
}

