/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.units.Duration;
import io.trino.collect.cache.CacheUtils;
import io.trino.collect.cache.EvictableCacheBuilder;
import io.trino.hive.thrift.metastore.DataOperationType;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.AcidTransactionOwner;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePartitionName;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.HiveTableName;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionFilter;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.TablesWithParameterCacheKey;
import io.trino.plugin.hive.metastore.UserTableKey;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class CachingHiveMetastore
implements HiveMetastore {
    protected final HiveMetastore delegate;
    private final boolean cacheMissing;
    private final LoadingCache<String, Optional<Database>> databaseCache;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<HiveTableName, Optional<Table>> tableCache;
    private final LoadingCache<String, List<String>> tableNamesCache;
    private final LoadingCache<TablesWithParameterCacheKey, List<String>> tablesWithParameterCache;
    private final Cache<HiveTableName, AtomicReference<PartitionStatistics>> tableStatisticsCache;
    private final Cache<HivePartitionName, AtomicReference<PartitionStatistics>> partitionStatisticsCache;
    private final LoadingCache<String, List<String>> viewNamesCache;
    private final Cache<HivePartitionName, AtomicReference<Optional<Partition>>> partitionCache;
    private final LoadingCache<PartitionFilter, Optional<List<String>>> partitionFilterCache;
    private final LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final LoadingCache<String, Set<String>> rolesCache;
    private final LoadingCache<HivePrincipal, Set<RoleGrant>> roleGrantsCache;
    private final LoadingCache<String, Set<RoleGrant>> grantedPrincipalsCache;
    private final LoadingCache<String, Optional<String>> configValuesCache;

    public static CachingHiveMetastoreBuilder builder() {
        return new CachingHiveMetastoreBuilder();
    }

    public static CachingHiveMetastoreBuilder builder(CachingHiveMetastoreBuilder other) {
        return new CachingHiveMetastoreBuilder(other.delegate, other.executor, other.metadataCacheEnabled, other.statsCacheEnabled, other.expiresAfterWriteMillis, other.statsExpiresAfterWriteMillis, other.refreshMills, other.maximumSize, other.statsRecording, other.cacheMissing, other.partitionCacheEnabled);
    }

    public static CachingHiveMetastore memoizeMetastore(HiveMetastore delegate, long maximumSize) {
        return CachingHiveMetastore.builder().delegate(delegate).metadataCacheEnabled(true).statsCacheEnabled(true).maximumSize(maximumSize).statsRecording(StatsRecording.DISABLED).cacheMissing(true).partitionCacheEnabled(true).build();
    }

    protected CachingHiveMetastore(HiveMetastore delegate, boolean metadataCacheEnabled, boolean statsCacheEnabled, OptionalLong expiresAfterWriteMillis, OptionalLong statsExpiresAfterWriteMillis, OptionalLong refreshMills, Optional<Executor> executor, long maximumSize, StatsRecording statsRecording, boolean cacheMissing, boolean partitionCacheEnabled) {
        CacheFactory partitionStatsCacheFactory;
        CacheFactory statsCacheFactory;
        CacheFactory partitionCacheFactory;
        CacheFactory cacheFactory;
        Preconditions.checkArgument((metadataCacheEnabled || statsCacheEnabled ? 1 : 0) != 0, (Object)"Cache not enabled");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cacheMissing = cacheMissing;
        Objects.requireNonNull(executor, "executor is null");
        if (metadataCacheEnabled) {
            cacheFactory = CachingHiveMetastore.cacheFactory(expiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording);
            partitionCacheFactory = partitionCacheEnabled ? cacheFactory : CachingHiveMetastore.neverCacheFactory();
        } else {
            cacheFactory = CachingHiveMetastore.neverCacheFactory();
            partitionCacheFactory = CachingHiveMetastore.neverCacheFactory();
        }
        if (statsCacheEnabled) {
            statsCacheFactory = CachingHiveMetastore.cacheFactory(statsExpiresAfterWriteMillis, refreshMills, executor, maximumSize, statsRecording);
            partitionStatsCacheFactory = partitionCacheEnabled ? statsCacheFactory : CachingHiveMetastore.neverCacheFactory();
        } else {
            statsCacheFactory = CachingHiveMetastore.neverCacheFactory();
            partitionStatsCacheFactory = CachingHiveMetastore.neverCacheFactory();
        }
        this.databaseNamesCache = cacheFactory.buildCache(ignored -> this.loadAllDatabases());
        this.databaseCache = cacheFactory.buildCache(this::loadDatabase);
        this.tableNamesCache = cacheFactory.buildCache(this::loadAllTables);
        this.tablesWithParameterCache = cacheFactory.buildCache(this::loadTablesMatchingParameter);
        this.tableStatisticsCache = statsCacheFactory.buildCache(this::refreshTableStatistics);
        this.tableCache = cacheFactory.buildCache(this::loadTable);
        this.viewNamesCache = cacheFactory.buildCache(this::loadAllViews);
        this.tablePrivilegesCache = cacheFactory.buildCache(key -> this.loadTablePrivileges(key.getDatabase(), key.getTable(), key.getOwner(), key.getPrincipal()));
        this.rolesCache = cacheFactory.buildCache(ignored -> this.loadRoles());
        this.roleGrantsCache = cacheFactory.buildCache(this::loadRoleGrants);
        this.grantedPrincipalsCache = cacheFactory.buildCache(this::loadPrincipals);
        this.configValuesCache = cacheFactory.buildCache(this::loadConfigValue);
        this.partitionStatisticsCache = partitionStatsCacheFactory.buildBulkCache();
        this.partitionFilterCache = partitionCacheFactory.buildCache(this::loadPartitionNamesByFilter);
        this.partitionCache = partitionCacheFactory.buildBulkCache();
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.tablePrivilegesCache.invalidateAll();
        this.tableStatisticsCache.invalidateAll();
        this.partitionStatisticsCache.invalidateAll();
        this.rolesCache.invalidateAll();
    }

    public void flushPartitionCache(String schemaName, String tableName, List<String> partitionColumns, List<String> partitionValues) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        String providedPartitionName = HiveUtil.makePartName(partitionColumns, partitionValues);
        this.invalidatePartitionCache(schemaName, tableName, partitionNameToCheck -> partitionNameToCheck.map(value -> value.equals(providedPartitionName)).orElse(false));
    }

    private AtomicReference<PartitionStatistics> refreshTableStatistics(HiveTableName tableName, AtomicReference<PartitionStatistics> currentValueHolder) {
        PartitionStatistics currentValue = currentValueHolder.get();
        if (currentValue == null) {
            return currentValueHolder;
        }
        PartitionStatistics reloaded = this.getTable(tableName.getDatabaseName(), tableName.getTableName()).map(table -> table.withSelectedDataColumnsOnly(currentValue.getColumnStatistics().keySet())).map(this.delegate::getTableStatistics).orElseThrow();
        return new AtomicReference<PartitionStatistics>(reloaded);
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            Object value = cache.getUnchecked(key);
            Preconditions.checkState((!(value instanceof Optional) ? 1 : 0) != 0, (Object)"This must not be used for caches with Optional values, as it doesn't implement cacheMissing logic. Use getOptional()");
            return (V)value;
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
    }

    private <K, V> Optional<V> getOptional(LoadingCache<K, Optional<V>> cache, K key) {
        try {
            boolean valueIsPresent;
            Optional value = (Optional)cache.getIfPresent(key);
            boolean bl = valueIsPresent = value != null;
            if (valueIsPresent) {
                if (value.isPresent() || this.cacheMissing) {
                    return value;
                }
                cache.invalidate(key);
            }
            return (Optional)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
    }

    private static <K, V> V getWithValueHolder(Cache<K, AtomicReference<V>> cache, K key, Supplier<V> loader) {
        AtomicReference valueHolder = (AtomicReference)CacheUtils.uncheckedCacheGet(cache, key, AtomicReference::new);
        Object value = valueHolder.get();
        if (value != null) {
            return value;
        }
        value = loader.get();
        if (value == null) {
            throw new CacheLoader.InvalidCacheLoadException("Failed to return a value for " + key);
        }
        valueHolder.compareAndSet(null, value);
        return value;
    }

    private static <K, V> V getIncrementally(Cache<K, AtomicReference<V>> cache, K key, Predicate<V> isSufficient, Supplier<V> loader, java.util.function.Function<V, V> incrementalLoader, BinaryOperator<V> merger) {
        AtomicReference valueHolder = (AtomicReference)CacheUtils.uncheckedCacheGet(cache, key, AtomicReference::new);
        Object oldValue = valueHolder.get();
        if (oldValue != null && isSufficient.test(oldValue)) {
            return oldValue;
        }
        V newValue = oldValue == null ? loader.get() : incrementalLoader.apply(oldValue);
        Verify.verifyNotNull(newValue, (String)"loader returned null for %s", (Object[])new Object[]{key});
        Object merged = merger.apply(oldValue, newValue);
        if (!valueHolder.compareAndSet(oldValue, merged)) {
            valueHolder.accumulateAndGet(newValue, merger);
        }
        return (V)merged;
    }

    private static <K, V> Map<K, V> getAll(Cache<K, AtomicReference<V>> cache, Iterable<K> keys, java.util.function.Function<Set<K>, Map<K, V>> bulkLoader) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        HashMap<Object, AtomicReference> toLoad = new HashMap<Object, AtomicReference>();
        for (K key2 : keys) {
            AtomicReference valueHolder2 = (AtomicReference)CacheUtils.uncheckedCacheGet(cache, key2, AtomicReference::new);
            Object value = valueHolder2.get();
            if (value != null) {
                result.put(key2, value);
                continue;
            }
            toLoad.put(key2, valueHolder2);
        }
        if (toLoad.isEmpty()) {
            return result.buildOrThrow();
        }
        Map newEntries = bulkLoader.apply(Collections.unmodifiableSet(toLoad.keySet()));
        toLoad.forEach((key, valueHolder) -> {
            Object value = newEntries.get(key);
            if (value == null) {
                throw new CacheLoader.InvalidCacheLoadException("Failed to return a value for " + key);
            }
            result.put(key, value);
            valueHolder.compareAndSet(null, value);
        });
        return result.buildOrThrow();
    }

    private static <K, V> Map<K, V> getAll(Cache<K, AtomicReference<V>> cache, Iterable<K> keys, java.util.function.Function<Collection<K>, Map<K, V>> bulkLoader, Predicate<V> isSufficient, BinaryOperator<V> merger) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        HashMap<Object, AtomicReference> toLoad = new HashMap<Object, AtomicReference>();
        keys.forEach(key -> {
            AtomicReference currentValueHolder = (AtomicReference)CacheUtils.uncheckedCacheGet((Cache)cache, (Object)key, AtomicReference::new);
            Object currentValue = currentValueHolder.get();
            if (currentValue != null && isSufficient.test(currentValue)) {
                result.put(key, currentValue);
            } else {
                toLoad.put(key, currentValueHolder);
            }
        });
        if (toLoad.isEmpty()) {
            return result.buildOrThrow();
        }
        Map newEntries = bulkLoader.apply(toLoad.keySet());
        toLoad.forEach((key, valueHolder) -> {
            Object newValue = newEntries.get(key);
            Verify.verifyNotNull(newValue, (String)"loader returned null for %s", (Object[])new Object[]{key});
            Object merged = valueHolder.accumulateAndGet(newValue, merger);
            result.put(key, merged);
        });
        return result.buildOrThrow();
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.getOptional(this.databaseCache, databaseName);
    }

    private Optional<Database> loadDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "");
    }

    private List<String> loadAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    private Table getExistingTable(String databaseName, String tableName) {
        return this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return this.getOptional(this.tableCache, HiveTableName.hiveTableName(databaseName, tableName));
    }

    @Override
    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    private Optional<Table> loadTable(HiveTableName hiveTableName) {
        return this.delegate.getTable(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
    }

    @Override
    public PartitionStatistics getTableStatistics(Table table) {
        Set dataColumns = (Set)table.getDataColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet());
        return CachingHiveMetastore.getIncrementally(this.tableStatisticsCache, HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), currentStatistics -> currentStatistics.getColumnStatistics().keySet().containsAll(dataColumns), () -> this.delegate.getTableStatistics(table), currentStatistics -> {
            Sets.SetView missingColumns = Sets.difference((Set)dataColumns, currentStatistics.getColumnStatistics().keySet());
            Table tableWithOnlyMissingColumns = table.withSelectedDataColumnsOnly((Set<String>)missingColumns);
            return this.delegate.getTableStatistics(tableWithOnlyMissingColumns);
        }, CachingHiveMetastore::mergePartitionColumnStatistics);
    }

    private PartitionStatistics loadTableColumnStatistics(HiveTableName tableName) {
        Table table = this.getExistingTable(tableName.getDatabaseName(), tableName.getTableName());
        return this.delegate.getTableStatistics(table);
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName());
        Map partitionsByName = (Map)partitions.stream().collect(ImmutableMap.toImmutableMap(partition -> HivePartitionName.hivePartitionName(hiveTableName, MetastoreUtil.makePartitionName(table, partition)), UnaryOperator.identity()));
        Set dataColumns = (Set)table.getDataColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet());
        Map<HivePartitionName, PartitionStatistics> statistics = CachingHiveMetastore.getAll(this.partitionStatisticsCache, partitionsByName.keySet(), missingPartitions -> this.loadPartitionsColumnStatistics(table, partitionsByName, (Collection<HivePartitionName>)missingPartitions), currentStats -> currentStats.getColumnStatistics().keySet().containsAll(dataColumns), CachingHiveMetastore::mergePartitionColumnStatistics);
        return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)entry.getKey()).getPartitionName().orElseThrow(), Map.Entry::getValue));
    }

    private static PartitionStatistics mergePartitionColumnStatistics(PartitionStatistics currentStats, PartitionStatistics newStats) {
        Objects.requireNonNull(newStats, "newStats is null");
        if (currentStats == null) {
            return newStats;
        }
        return new PartitionStatistics(newStats.getBasicStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.builder().putAll(currentStats.getColumnStatistics()).putAll(newStats.getColumnStatistics()).buildKeepingLast());
    }

    private Map<HivePartitionName, PartitionStatistics> loadPartitionsColumnStatistics(Table table, Map<HivePartitionName, Partition> partitionsByName, Collection<HivePartitionName> partitionNamesToLoad) {
        if (partitionNamesToLoad.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        List partitionsToLoad = (List)partitionNamesToLoad.stream().map(partitionsByName::get).collect(ImmutableList.toImmutableList());
        Map<String, PartitionStatistics> statisticsByPartitionName = this.delegate.getPartitionStatistics(table, partitionsToLoad);
        for (HivePartitionName partitionName : partitionNamesToLoad) {
            String stringNameForPartition = partitionName.getPartitionName().orElseThrow();
            result.put((Object)partitionName, (Object)statisticsByPartitionName.get(stringNameForPartition));
        }
        return result.buildOrThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, java.util.function.Function<PartitionStatistics, PartitionStatistics> update) {
        try {
            this.delegate.updateTableStatistics(databaseName, tableName, transaction, update);
        }
        finally {
            HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
            this.tableStatisticsCache.invalidate((Object)hiveTableName);
            this.tableCache.invalidate((Object)hiveTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionStatistics(Table table, String partitionName, java.util.function.Function<PartitionStatistics, PartitionStatistics> update) {
        try {
            this.delegate.updatePartitionStatistics(table, partitionName, update);
        }
        finally {
            HivePartitionName hivePartitionName = HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionName);
            this.partitionStatisticsCache.invalidate((Object)hivePartitionName);
            this.partitionCache.invalidate((Object)hivePartitionName);
        }
    }

    @Override
    public void updatePartitionStatistics(Table table, Map<String, java.util.function.Function<PartitionStatistics, PartitionStatistics>> updates) {
        try {
            this.delegate.updatePartitionStatistics(table, updates);
        }
        finally {
            updates.forEach((partitionName, update) -> {
                HivePartitionName hivePartitionName = HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionName);
                this.partitionStatisticsCache.invalidate((Object)hivePartitionName);
                this.partitionCache.invalidate((Object)hivePartitionName);
            });
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName);
    }

    private List<String> loadAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        TablesWithParameterCacheKey key = new TablesWithParameterCacheKey(databaseName, parameterKey, parameterValue);
        return CachingHiveMetastore.get(this.tablesWithParameterCache, key);
    }

    private List<String> loadTablesMatchingParameter(TablesWithParameterCacheKey key) {
        return this.delegate.getTablesWithParameter(key.getDatabaseName(), key.getParameterKey(), key.getParameterValue());
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        return CachingHiveMetastore.get(this.viewNamesCache, databaseName);
    }

    private List<String> loadAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(Database database) {
        try {
            this.delegate.createDatabase(database);
        }
        finally {
            this.invalidateDatabase(database.getDatabaseName());
        }
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        try {
            this.delegate.dropDatabase(databaseName, deleteData);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            this.delegate.renameDatabase(databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
            this.invalidateDatabase(newDatabaseName);
        }
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        try {
            this.delegate.setDatabaseOwner(databaseName, principal);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    protected void invalidateDatabase(String databaseName) {
        this.databaseCache.invalidate((Object)databaseName);
        this.databaseNamesCache.invalidateAll();
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.createTable(table, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        try {
            this.delegate.dropTable(databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        try {
            this.delegate.commentTable(databaseName, tableName, comment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        try {
            this.delegate.setTableOwner(databaseName, tableName, principal);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        try {
            this.delegate.commentColumn(databaseName, tableName, columnName, comment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        try {
            this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        try {
            this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        try {
            this.delegate.dropColumn(databaseName, tableName, columnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    public void invalidateTable(String databaseName, String tableName) {
        this.invalidateTableCache(databaseName, tableName);
        this.tableNamesCache.invalidate((Object)databaseName);
        this.viewNamesCache.invalidate((Object)databaseName);
        this.tablePrivilegesCache.asMap().keySet().stream().filter(userTableKey -> userTableKey.matches(databaseName, tableName)).forEach(arg_0 -> this.tablePrivilegesCache.invalidate(arg_0));
        this.invalidateTableStatisticsCache(databaseName, tableName);
        this.invalidateTablesWithParameterCache(databaseName, tableName);
        this.invalidatePartitionCache(databaseName, tableName);
    }

    private void invalidateTableCache(String databaseName, String tableName) {
        this.tableCache.asMap().keySet().stream().filter(table -> table.getDatabaseName().equals(databaseName) && table.getTableName().equals(tableName)).forEach(arg_0 -> this.tableCache.invalidate(arg_0));
    }

    private void invalidateTableStatisticsCache(String databaseName, String tableName) {
        this.tableStatisticsCache.asMap().keySet().stream().filter(table -> table.getDatabaseName().equals(databaseName) && table.getTableName().equals(tableName)).forEach(arg_0 -> this.tableCache.invalidate(arg_0));
    }

    private void invalidateTablesWithParameterCache(String databaseName, String tableName) {
        this.tablesWithParameterCache.asMap().keySet().stream().filter(cacheKey -> cacheKey.getDatabaseName().equals(databaseName)).filter(cacheKey -> {
            List cacheValue = (List)this.tablesWithParameterCache.getIfPresent(cacheKey);
            return cacheValue != null && cacheValue.contains(tableName);
        }).forEach(arg_0 -> this.tablesWithParameterCache.invalidate(arg_0));
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        return CachingHiveMetastore.getWithValueHolder(this.partitionCache, HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionValues), () -> this.delegate.getPartition(table, partitionValues));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.getOptional(this.partitionFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, columnNames, partitionKeysFilter));
    }

    private Optional<List<String>> loadPartitionNamesByFilter(PartitionFilter partitionFilter) {
        return this.delegate.getPartitionNamesByFilter(partitionFilter.getHiveTableName().getDatabaseName(), partitionFilter.getHiveTableName().getTableName(), partitionFilter.getPartitionColumnNames(), partitionFilter.getPartitionKeysFilter());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        List names = (List)partitionNames.stream().map(name -> HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), name)).collect(ImmutableList.toImmutableList());
        Map<HivePartitionName, Optional<Partition>> all = CachingHiveMetastore.getAll(this.partitionCache, names, namesToLoad -> this.loadPartitionsByNames(table, (Iterable<? extends HivePartitionName>)namesToLoad));
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        for (Map.Entry<HivePartitionName, Optional<Partition>> entry : all.entrySet()) {
            partitionsByName.put((Object)entry.getKey().getPartitionName().orElseThrow(), entry.getValue());
        }
        return partitionsByName.buildOrThrow();
    }

    private Map<HivePartitionName, Optional<Partition>> loadPartitionsByNames(Table table, Iterable<? extends HivePartitionName> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        HivePartitionName firstPartition = (HivePartitionName)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = firstPartition.getHiveTableName();
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (HivePartitionName hivePartitionName : partitionNames) {
            Preconditions.checkArgument((boolean)hivePartitionName.getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object)hiveTableName, (Object)hivePartitionName.getHiveTableName());
            partitionsToFetch.add(hivePartitionName.getPartitionName().orElseThrow());
        }
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        Map<String, Optional<Partition>> map = this.delegate.getPartitionsByNames(table, partitionsToFetch);
        for (HivePartitionName hivePartitionName : partitionNames) {
            partitions.put((Object)hivePartitionName, map.getOrDefault(hivePartitionName.getPartitionName().orElseThrow(), Optional.empty()));
        }
        return partitions.buildOrThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            this.delegate.addPartitions(databaseName, tableName, partitions);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            this.delegate.alterPartition(databaseName, tableName, partition);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.delegate.createRole(role, grantor);
        }
        finally {
            this.rolesCache.invalidateAll();
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.delegate.dropRole(role);
        }
        finally {
            this.rolesCache.invalidateAll();
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<String> listRoles() {
        return CachingHiveMetastore.get(this.rolesCache, "");
    }

    private Set<String> loadRoles() {
        return this.delegate.listRoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        try {
            this.delegate.grantRoles(roles, grantees, adminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        try {
            this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        return CachingHiveMetastore.get(this.grantedPrincipalsCache, role);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return CachingHiveMetastore.get(this.roleGrantsCache, principal);
    }

    private Set<RoleGrant> loadRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    private Set<RoleGrant> loadPrincipals(String role) {
        return this.delegate.listGrantedPrincipals(role);
    }

    private void invalidatePartitionCache(String databaseName, String tableName) {
        this.invalidatePartitionCache(databaseName, tableName, partitionName -> true);
    }

    private void invalidatePartitionCache(String databaseName, String tableName, Predicate<Optional<String>> partitionPredicate) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        Predicate<HivePartitionName> hivePartitionPredicate = partitionName -> partitionName.getHiveTableName().equals(hiveTableName) && partitionPredicate.test(partitionName.getPartitionName());
        this.partitionCache.asMap().keySet().stream().filter(hivePartitionPredicate).forEach(arg_0 -> this.partitionCache.invalidate(arg_0));
        this.partitionFilterCache.asMap().keySet().stream().filter(partitionFilter -> partitionFilter.getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionFilterCache.invalidate(arg_0));
        this.partitionStatisticsCache.asMap().keySet().stream().filter(hivePartitionPredicate).forEach(arg_0 -> this.partitionStatisticsCache.invalidate(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        try {
            this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
        }
        finally {
            this.invalidateTablePrivilegeCacheEntries(databaseName, tableName, tableOwner, grantee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        try {
            this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
        }
        finally {
            this.invalidateTablePrivilegeCacheEntries(databaseName, tableName, tableOwner, grantee);
        }
    }

    private void invalidateTablePrivilegeCacheEntries(String databaseName, String tableName, String tableOwner, HivePrincipal grantee) {
        this.tablePrivilegesCache.invalidate((Object)new UserTableKey(Optional.of(grantee), databaseName, tableName, Optional.of(tableOwner)));
        this.tablePrivilegesCache.invalidate((Object)new UserTableKey(Optional.empty(), databaseName, tableName, Optional.of(tableOwner)));
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return CachingHiveMetastore.get(this.tablePrivilegesCache, new UserTableKey(principal, databaseName, tableName, tableOwner));
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        return this.getOptional(this.configValuesCache, name);
    }

    private Optional<String> loadConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    @Override
    public void checkSupportsTransactions() {
        this.delegate.checkSupportsTransactions();
    }

    @Override
    public long openTransaction(AcidTransactionOwner transactionOwner) {
        return this.delegate.openTransaction(transactionOwner);
    }

    @Override
    public void commitTransaction(long transactionId) {
        this.delegate.commitTransaction(transactionId);
    }

    @Override
    public void abortTransaction(long transactionId) {
        this.delegate.abortTransaction(transactionId);
    }

    @Override
    public void sendTransactionHeartbeat(long transactionId) {
        this.delegate.sendTransactionHeartbeat(transactionId);
    }

    @Override
    public void acquireSharedReadLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(transactionOwner, queryId, transactionId, fullTables, partitions);
    }

    @Override
    public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(tables, currentTransactionId);
    }

    private Set<HivePrivilegeInfo> loadTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    @Override
    public long allocateWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(dbName, tableName, transactionId);
    }

    @Override
    public void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        this.delegate.acquireTableWriteLock(transactionOwner, queryId, transactionId, dbName, tableName, operation, isDynamicPartitionWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        try {
            this.delegate.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange);
        }
        finally {
            this.invalidateTable(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartitions(String dbName, String tableName, List<Partition> partitions, long writeId) {
        try {
            this.delegate.alterPartitions(dbName, tableName, partitions, writeId);
        }
        finally {
            this.invalidatePartitionCache(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        try {
            this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation);
        }
        finally {
            this.invalidatePartitionCache(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTransactionalTable(Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.alterTransactionalTable(table, transactionId, writeId, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    private static CacheFactory cacheFactory(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, Optional<Executor> refreshExecutor, long maximumSize, StatsRecording statsRecording) {
        return new CacheFactory(expiresAfterWriteMillis, refreshMillis, refreshExecutor, maximumSize, statsRecording);
    }

    private static CacheFactory neverCacheFactory() {
        return CachingHiveMetastore.cacheFactory(OptionalLong.of(0L), OptionalLong.empty(), Optional.empty(), 0L, StatsRecording.DISABLED);
    }

    private static <K, V> LoadingCache<K, V> buildCache(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, Optional<Executor> refreshExecutor, long maximumSize, StatsRecording statsRecording, CacheLoader<K, V> cacheLoader) {
        EvictableCacheBuilder cacheBuilder = EvictableCacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        Preconditions.checkArgument((refreshMillis.isEmpty() || refreshExecutor.isPresent() ? 1 : 0) != 0, (Object)"refreshMillis is provided but refreshExecutor is not");
        if (refreshMillis.isPresent() && (expiresAfterWriteMillis.isEmpty() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
            cacheLoader = CacheLoader.asyncReloading(cacheLoader, (Executor)refreshExecutor.orElseThrow(() -> new IllegalArgumentException("Executor not provided")));
        }
        cacheBuilder.maximumSize(maximumSize);
        if (statsRecording == StatsRecording.ENABLED) {
            cacheBuilder.recordStats();
        }
        cacheBuilder.shareNothingWhenDisabled();
        return cacheBuilder.build(cacheLoader);
    }

    private static <K, V> Cache<K, AtomicReference<V>> buildBulkCache(OptionalLong expiresAfterWriteMillis, long maximumSize, StatsRecording statsRecording) {
        EvictableCacheBuilder cacheBuilder = EvictableCacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder.maximumSize(maximumSize);
        if (statsRecording == StatsRecording.ENABLED) {
            cacheBuilder.recordStats();
        }
        cacheBuilder.shareNothingWhenDisabled();
        return cacheBuilder.build();
    }

    @Managed
    @Nested
    public CacheStatsMBean getDatabaseStats() {
        return new CacheStatsMBean(this.databaseCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getDatabaseNamesStats() {
        return new CacheStatsMBean(this.databaseNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableStats() {
        return new CacheStatsMBean(this.tableCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableNamesStats() {
        return new CacheStatsMBean(this.tableNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableWithParameterStats() {
        return new CacheStatsMBean(this.tablesWithParameterCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableStatisticsStats() {
        return new CacheStatsMBean(this.tableStatisticsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionStatisticsStats() {
        return new CacheStatsMBean(this.partitionStatisticsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getViewNamesStats() {
        return new CacheStatsMBean(this.viewNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionStats() {
        return new CacheStatsMBean(this.partitionCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionFilterStats() {
        return new CacheStatsMBean(this.partitionFilterCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTablePrivilegesStats() {
        return new CacheStatsMBean(this.tablePrivilegesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getRolesStats() {
        return new CacheStatsMBean(this.rolesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getRoleGrantsStats() {
        return new CacheStatsMBean(this.roleGrantsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getGrantedPrincipalsStats() {
        return new CacheStatsMBean(this.grantedPrincipalsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getConfigValuesStats() {
        return new CacheStatsMBean(this.configValuesCache);
    }

    LoadingCache<String, Optional<Database>> getDatabaseCache() {
        return this.databaseCache;
    }

    LoadingCache<String, List<String>> getDatabaseNamesCache() {
        return this.databaseNamesCache;
    }

    LoadingCache<HiveTableName, Optional<Table>> getTableCache() {
        return this.tableCache;
    }

    LoadingCache<String, List<String>> getTableNamesCache() {
        return this.tableNamesCache;
    }

    LoadingCache<TablesWithParameterCacheKey, List<String>> getTablesWithParameterCache() {
        return this.tablesWithParameterCache;
    }

    Cache<HiveTableName, AtomicReference<PartitionStatistics>> getTableStatisticsCache() {
        return this.tableStatisticsCache;
    }

    Cache<HivePartitionName, AtomicReference<PartitionStatistics>> getPartitionStatisticsCache() {
        return this.partitionStatisticsCache;
    }

    LoadingCache<String, List<String>> getViewNamesCache() {
        return this.viewNamesCache;
    }

    Cache<HivePartitionName, AtomicReference<Optional<Partition>>> getPartitionCache() {
        return this.partitionCache;
    }

    LoadingCache<PartitionFilter, Optional<List<String>>> getPartitionFilterCache() {
        return this.partitionFilterCache;
    }

    LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> getTablePrivilegesCache() {
        return this.tablePrivilegesCache;
    }

    LoadingCache<String, Set<String>> getRolesCache() {
        return this.rolesCache;
    }

    LoadingCache<HivePrincipal, Set<RoleGrant>> getRoleGrantsCache() {
        return this.roleGrantsCache;
    }

    LoadingCache<String, Set<RoleGrant>> getGrantedPrincipalsCache() {
        return this.grantedPrincipalsCache;
    }

    LoadingCache<String, Optional<String>> getConfigValuesCache() {
        return this.configValuesCache;
    }

    @Immutable
    public static class CachingHiveMetastoreBuilder {
        private HiveMetastore delegate;
        private Optional<Executor> executor = Optional.empty();
        private Boolean metadataCacheEnabled;
        private Boolean statsCacheEnabled;
        private OptionalLong expiresAfterWriteMillis = OptionalLong.empty();
        private OptionalLong statsExpiresAfterWriteMillis = OptionalLong.empty();
        private OptionalLong refreshMills = OptionalLong.empty();
        private Long maximumSize;
        private StatsRecording statsRecording = StatsRecording.ENABLED;
        private Boolean cacheMissing;
        private Boolean partitionCacheEnabled;

        public CachingHiveMetastoreBuilder() {
        }

        private CachingHiveMetastoreBuilder(HiveMetastore delegate, Optional<Executor> executor, boolean metadataCacheEnabled, boolean statsCacheEnabled, OptionalLong expiresAfterWriteMillis, OptionalLong statsExpiresAfterWriteMillis, OptionalLong refreshMills, Long maximumSize, StatsRecording statsRecording, Boolean cacheMissing, Boolean partitionCacheEnabled) {
            this.delegate = delegate;
            this.executor = executor;
            this.metadataCacheEnabled = metadataCacheEnabled;
            this.statsCacheEnabled = statsCacheEnabled;
            this.expiresAfterWriteMillis = expiresAfterWriteMillis;
            this.statsExpiresAfterWriteMillis = statsExpiresAfterWriteMillis;
            this.refreshMills = refreshMills;
            this.maximumSize = maximumSize;
            this.statsRecording = statsRecording;
            this.cacheMissing = cacheMissing;
            this.partitionCacheEnabled = partitionCacheEnabled;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder delegate(HiveMetastore delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder executor(Executor executor) {
            this.executor = Optional.of(Objects.requireNonNull(executor, "executor is null"));
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder metadataCacheEnabled(boolean metadataCacheEnabled) {
            this.metadataCacheEnabled = metadataCacheEnabled;
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder statsCacheEnabled(boolean statsCacheEnabled) {
            this.statsCacheEnabled = statsCacheEnabled;
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder cacheTtl(Duration cacheTtl) {
            this.expiresAfterWriteMillis = OptionalLong.of(Objects.requireNonNull(cacheTtl, "cacheTtl is null").toMillis());
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder statsCacheTtl(Duration statsCacheTtl) {
            this.statsExpiresAfterWriteMillis = OptionalLong.of(Objects.requireNonNull(statsCacheTtl, "statsCacheTtl is null").toMillis());
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder refreshInterval(Duration refreshInterval) {
            return this.refreshInterval(Optional.of(refreshInterval));
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder refreshInterval(Optional<Duration> refreshInterval) {
            this.refreshMills = Objects.requireNonNull(refreshInterval, "refreshInterval is null").map(Duration::toMillis).map(OptionalLong::of).orElse(OptionalLong.empty());
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder maximumSize(long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder statsRecording(StatsRecording statsRecording) {
            this.statsRecording = Objects.requireNonNull(statsRecording, "statsRecording is null");
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder cacheMissing(boolean cacheMissing) {
            this.cacheMissing = cacheMissing;
            return this;
        }

        @CanIgnoreReturnValue
        public CachingHiveMetastoreBuilder partitionCacheEnabled(boolean partitionCacheEnabled) {
            this.partitionCacheEnabled = partitionCacheEnabled;
            return this;
        }

        public CachingHiveMetastore build() {
            Objects.requireNonNull(this.metadataCacheEnabled, "metadataCacheEnabled not set");
            Objects.requireNonNull(this.statsCacheEnabled, "statsCacheEnabled is null");
            Objects.requireNonNull(this.delegate, "delegate not set");
            Objects.requireNonNull(this.maximumSize, "maximumSize not set");
            Objects.requireNonNull(this.cacheMissing, "cacheMissing not set");
            Objects.requireNonNull(this.partitionCacheEnabled, "partitionCacheEnabled not set");
            return new CachingHiveMetastore(this.delegate, this.metadataCacheEnabled, this.statsCacheEnabled, this.expiresAfterWriteMillis, this.statsExpiresAfterWriteMillis, this.refreshMills, this.executor, this.maximumSize, this.statsRecording, this.cacheMissing, this.partitionCacheEnabled);
        }
    }

    public static enum StatsRecording {
        ENABLED,
        DISABLED;

    }

    private static class CacheFactory {
        private final OptionalLong expiresAfterWriteMillis;
        private final OptionalLong refreshMillis;
        private final Optional<Executor> refreshExecutor;
        private final long maximumSize;
        private final StatsRecording statsRecording;

        public CacheFactory(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, Optional<Executor> refreshExecutor, long maximumSize, StatsRecording statsRecording) {
            this.expiresAfterWriteMillis = Objects.requireNonNull(expiresAfterWriteMillis, "expiresAfterWriteMillis is null");
            this.refreshMillis = Objects.requireNonNull(refreshMillis, "refreshMillis is null");
            this.refreshExecutor = Objects.requireNonNull(refreshExecutor, "refreshExecutor is null");
            this.maximumSize = maximumSize;
            this.statsRecording = Objects.requireNonNull(statsRecording, "statsRecording is null");
        }

        public <K, V> LoadingCache<K, V> buildCache(Function<K, V> loader) {
            return CachingHiveMetastore.buildCache(this.expiresAfterWriteMillis, this.refreshMillis, this.refreshExecutor, this.maximumSize, this.statsRecording, CacheLoader.from(loader));
        }

        public <K, V> Cache<K, V> buildCache(final BiFunction<K, V, V> reloader) {
            CacheLoader onlyReloader = new CacheLoader<K, V>(){

                public V load(K key) {
                    throw new UnsupportedOperationException();
                }

                public ListenableFuture<V> reload(K key, V oldValue) {
                    Objects.requireNonNull(key);
                    Objects.requireNonNull(oldValue);
                    return Futures.immediateFuture(reloader.apply(key, oldValue));
                }
            };
            return CachingHiveMetastore.buildCache(this.expiresAfterWriteMillis, this.refreshMillis, this.refreshExecutor, this.maximumSize, this.statsRecording, onlyReloader);
        }

        public <K, V> Cache<K, AtomicReference<V>> buildBulkCache() {
            return CachingHiveMetastore.buildBulkCache(this.expiresAfterWriteMillis, this.maximumSize, this.statsRecording);
        }
    }
}

