/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.recording;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.RateLimiter;
import io.trino.plugin.hive.metastore.recording.HiveMetastoreRecording;
import io.trino.spi.procedure.Procedure;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class WriteHiveMetastoreRecordingProcedure
implements Provider<Procedure> {
    private static final MethodHandle WRITE_HIVE_METASTORE_RECORDING;
    private final RateLimiter rateLimiter = RateLimiter.create((double)0.2);
    private final HiveMetastoreRecording hiveMetastoreRecording;

    @Inject
    public WriteHiveMetastoreRecordingProcedure(HiveMetastoreRecording hiveMetastoreRecording) {
        this.hiveMetastoreRecording = Objects.requireNonNull(hiveMetastoreRecording, "hiveMetastoreRecording is null");
    }

    public Procedure get() {
        return new Procedure("system", "write_hive_metastore_recording", (List)ImmutableList.of(), WRITE_HIVE_METASTORE_RECORDING.bindTo(this));
    }

    public void writeHiveMetastoreRecording() {
        try {
            this.rateLimiter.acquire();
            this.hiveMetastoreRecording.writeRecording();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            WRITE_HIVE_METASTORE_RECORDING = MethodHandles.lookup().unreflect(WriteHiveMetastoreRecordingProcedure.class.getMethod("writeHiveMetastoreRecording", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

