/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.MinDataSize;
import io.trino.parquet.ParquetReaderOptions;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"hive.parquet.fail-on-corrupted-statistics", "parquet.fail-on-corrupted-statistics"})
public class ParquetReaderConfig {
    private ParquetReaderOptions options = new ParquetReaderOptions();

    @Deprecated
    public boolean isIgnoreStatistics() {
        return this.options.isIgnoreStatistics();
    }

    @Deprecated
    @Config(value="parquet.ignore-statistics")
    @ConfigDescription(value="Ignore statistics from Parquet to allow querying files with corrupted or incorrect statistics")
    public ParquetReaderConfig setIgnoreStatistics(boolean ignoreStatistics) {
        this.options = this.options.withIgnoreStatistics(ignoreStatistics);
        return this;
    }

    @NotNull
    public DataSize getMaxReadBlockSize() {
        return this.options.getMaxReadBlockSize();
    }

    @Config(value="parquet.max-read-block-size")
    @LegacyConfig(value={"hive.parquet.max-read-block-size"})
    public ParquetReaderConfig setMaxReadBlockSize(DataSize maxReadBlockSize) {
        this.options = this.options.withMaxReadBlockSize(maxReadBlockSize);
        return this;
    }

    @Min(value=128L)
    @Max(value=65536L)
    public @Min(value=128L) @Max(value=65536L) int getMaxReadBlockRowCount() {
        return this.options.getMaxReadBlockRowCount();
    }

    @Config(value="parquet.max-read-block-row-count")
    @ConfigDescription(value="Maximum number of rows read in a batch")
    public ParquetReaderConfig setMaxReadBlockRowCount(int length) {
        this.options = this.options.withMaxReadBlockRowCount(length);
        return this;
    }

    @NotNull
    public DataSize getMaxMergeDistance() {
        return this.options.getMaxMergeDistance();
    }

    @Config(value="parquet.max-merge-distance")
    public ParquetReaderConfig setMaxMergeDistance(DataSize distance) {
        this.options = this.options.withMaxMergeDistance(distance);
        return this;
    }

    @NotNull
    @MinDataSize(value="1MB")
    public @NotNull @MinDataSize(value="1MB") DataSize getMaxBufferSize() {
        return this.options.getMaxBufferSize();
    }

    @Config(value="parquet.max-buffer-size")
    public ParquetReaderConfig setMaxBufferSize(DataSize size) {
        this.options = this.options.withMaxBufferSize(size);
        return this;
    }

    @Config(value="parquet.use-column-index")
    @ConfigDescription(value="Enable using Parquet column indexes")
    public ParquetReaderConfig setUseColumnIndex(boolean useColumnIndex) {
        this.options = this.options.withUseColumnIndex(useColumnIndex);
        return this;
    }

    public boolean isUseColumnIndex() {
        return this.options.isUseColumnIndex();
    }

    @Config(value="parquet.optimized-reader.enabled")
    @ConfigDescription(value="Use optimized Parquet reader")
    public ParquetReaderConfig setOptimizedReaderEnabled(boolean optimizedReaderEnabled) {
        this.options = this.options.withBatchColumnReaders(optimizedReaderEnabled);
        return this;
    }

    public boolean isOptimizedReaderEnabled() {
        return this.options.useBatchColumnReaders();
    }

    @Config(value="parquet.optimized-nested-reader.enabled")
    @ConfigDescription(value="Use optimized Parquet reader for nested columns")
    public ParquetReaderConfig setOptimizedNestedReaderEnabled(boolean optimizedNestedReaderEnabled) {
        this.options = this.options.withBatchNestedColumnReaders(optimizedNestedReaderEnabled);
        return this;
    }

    public boolean isOptimizedNestedReaderEnabled() {
        return this.options.useBatchNestedColumnReaders();
    }

    @Config(value="parquet.use-bloom-filter")
    @ConfigDescription(value="Enable using Parquet bloom filter")
    public ParquetReaderConfig setUseBloomFilter(boolean useBloomFilter) {
        this.options = this.options.withBloomFilter(useBloomFilter);
        return this;
    }

    public boolean isUseBloomFilter() {
        return this.options.useBloomFilter();
    }

    public ParquetReaderOptions toParquetReaderOptions() {
        return this.options;
    }
}

