/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SyncPartitionMetadataProcedure
implements Provider<Procedure> {
    private static final int BATCH_GET_PARTITIONS_BY_NAMES_MAX_PAGE_SIZE = 1000;
    private static final MethodHandle SYNC_PARTITION_METADATA;
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public SyncPartitionMetadataProcedure(TransactionalMetadataFactory hiveMetadataFactory, HdfsEnvironment hdfsEnvironment) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public Procedure get() {
        return new Procedure("system", "sync_partition_metadata", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("MODE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("CASE_SENSITIVE", (Type)BooleanType.BOOLEAN, false, (Object)Boolean.TRUE)), SYNC_PARTITION_METADATA.bindTo(this));
    }

    public void syncPartitionMetadata(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, String mode, boolean caseSensitive) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doSyncPartitionMetadata(session, accessControl, schemaName, tableName, mode, caseSensitive);
        }
    }

    private void doSyncPartitionMetadata(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, String mode, boolean caseSensitive) {
        Set<String> partitionsToDrop;
        Set<String> partitionsToAdd;
        Procedures.checkProcedureArgument((schemaName != null ? 1 : 0) != 0, (String)"schema_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((tableName != null ? 1 : 0) != 0, (String)"table_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((mode != null ? 1 : 0) != 0, (String)"mode cannot be null", (Object[])new Object[0]);
        SyncMode syncMode = SyncPartitionMetadataProcedure.toSyncMode(mode);
        HdfsContext hdfsContext = new HdfsContext(session);
        SemiTransactionalHiveMetastore metastore = this.hiveMetadataFactory.create(session.getIdentity(), true).getMetastore();
        SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
        Table table = metastore.getTable(schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (table.getPartitionColumns().isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is not partitioned: " + schemaTableName);
        }
        if (syncMode == SyncMode.ADD || syncMode == SyncMode.FULL) {
            accessControl.checkCanInsertIntoTable(null, new SchemaTableName(schemaName, tableName));
        }
        if (syncMode == SyncMode.DROP || syncMode == SyncMode.FULL) {
            accessControl.checkCanDeleteFromTable(null, new SchemaTableName(schemaName, tableName));
        }
        Path tableLocation = new Path(table.getStorage().getLocation());
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(hdfsContext, tableLocation);
            List<String> partitionsNamesInMetastore = metastore.getPartitionNames(schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            List<String> partitionsInMetastore = this.getPartitionsInMetastore(schemaTableName, tableLocation, partitionsNamesInMetastore, metastore);
            List partitionsInFileSystem = (List)SyncPartitionMetadataProcedure.listDirectory(fileSystem, fileSystem.getFileStatus(tableLocation), table.getPartitionColumns(), table.getPartitionColumns().size(), caseSensitive).stream().map(fileStatus -> fileStatus.getPath().toUri()).map(uri -> tableLocation.toUri().relativize((URI)uri).getPath()).collect(ImmutableList.toImmutableList());
            partitionsToAdd = SyncPartitionMetadataProcedure.difference(partitionsInFileSystem, partitionsInMetastore);
            partitionsToDrop = SyncPartitionMetadataProcedure.difference(partitionsInMetastore, partitionsInFileSystem);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
        SyncPartitionMetadataProcedure.syncPartitions(partitionsToAdd, partitionsToDrop, syncMode, metastore, session, table);
    }

    private List<String> getPartitionsInMetastore(SchemaTableName schemaTableName, Path tableLocation, List<String> partitionsNames, SemiTransactionalHiveMetastore metastore) {
        ImmutableList.Builder partitionsInMetastoreBuilder = ImmutableList.builderWithExpectedSize((int)partitionsNames.size());
        for (List partitionsNamesBatch : Lists.partition(partitionsNames, (int)1000)) {
            metastore.getPartitionsByNames(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionsNamesBatch).values().stream().filter(Optional::isPresent).map(Optional::get).map(partition -> new Path(partition.getStorage().getLocation()).toUri()).map(uri -> tableLocation.toUri().relativize((URI)uri).getPath()).forEach(arg_0 -> ((ImmutableList.Builder)partitionsInMetastoreBuilder).add(arg_0));
        }
        return partitionsInMetastoreBuilder.build();
    }

    private static List<FileStatus> listDirectory(FileSystem fileSystem, FileStatus current, List<Column> partitionColumns, int depth, boolean caseSensitive) {
        if (depth == 0) {
            return ImmutableList.of((Object)current);
        }
        try {
            return (List)Stream.of(fileSystem.listStatus(current.getPath())).filter(fileStatus -> SyncPartitionMetadataProcedure.isValidPartitionPath(fileStatus, (Column)partitionColumns.get(partitionColumns.size() - depth), caseSensitive)).flatMap(directory -> SyncPartitionMetadataProcedure.listDirectory(fileSystem, directory, partitionColumns, depth - 1, caseSensitive).stream()).collect(ImmutableList.toImmutableList());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
    }

    private static boolean isValidPartitionPath(FileStatus file, Column column, boolean caseSensitive) {
        String path = file.getPath().getName();
        if (!caseSensitive) {
            path = path.toLowerCase(Locale.ENGLISH);
        }
        String prefix = column.getName() + "=";
        return file.isDirectory() && path.startsWith(prefix);
    }

    private static Set<String> difference(List<String> a, List<String> b) {
        return Sets.difference(new HashSet<String>(a), new HashSet<String>(b));
    }

    private static void syncPartitions(Set<String> partitionsToAdd, Set<String> partitionsToDrop, SyncMode syncMode, SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        if (syncMode == SyncMode.ADD || syncMode == SyncMode.FULL) {
            SyncPartitionMetadataProcedure.addPartitions(metastore, session, table, partitionsToAdd);
        }
        if (syncMode == SyncMode.DROP || syncMode == SyncMode.FULL) {
            SyncPartitionMetadataProcedure.dropPartitions(metastore, session, table, partitionsToDrop);
        }
        metastore.commit();
    }

    private static void addPartitions(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Set<String> partitions) {
        for (String name : partitions) {
            metastore.addPartition(session, table.getDatabaseName(), table.getTableName(), SyncPartitionMetadataProcedure.buildPartitionObject(session, table, name), new Path(table.getStorage().getLocation(), name), Optional.empty(), PartitionStatistics.empty(), false);
        }
    }

    private static void dropPartitions(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Set<String> partitions) {
        for (String name : partitions) {
            metastore.dropPartition(session, table.getDatabaseName(), table.getTableName(), HivePartitionManager.extractPartitionValues(name), false);
        }
    }

    private static Partition buildPartitionObject(ConnectorSession session, Table table, String partitionName) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionValues(partitionName)).setParameters((Map<String, String>)ImmutableMap.of((Object)"presto_query_id", (Object)session.getQueryId())).withStorage(storage -> storage.setStorageFormat(table.getStorage().getStorageFormat()).setLocation(new Path(table.getStorage().getLocation(), partitionName).toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private static SyncMode toSyncMode(String mode) {
        try {
            return SyncMode.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Invalid partition metadata sync mode: " + mode);
        }
    }

    static {
        try {
            SYNC_PARTITION_METADATA = MethodHandles.lookup().unreflect(SyncPartitionMetadataProcedure.class.getMethod("syncPartitionMetadata", ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, String.class, Boolean.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum SyncMode {
        ADD,
        DROP,
        FULL;

    }
}

