/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.type;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.TypeInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class UnionTypeInfo
extends TypeInfo {
    private final List<TypeInfo> objectTypeInfos;

    UnionTypeInfo(List<TypeInfo> objectTypeInfos) {
        this.objectTypeInfos = ImmutableList.copyOf((Collection)Objects.requireNonNull(objectTypeInfos, "objectTypeInfos is null"));
    }

    @Override
    public String getTypeName() {
        return this.objectTypeInfos.stream().map(TypeInfo::getTypeName).collect(Collectors.joining(",", "uniontype<", ">"));
    }

    @Override
    public Category getCategory() {
        return Category.UNION;
    }

    public List<TypeInfo> getAllUnionObjectTypeInfos() {
        return this.objectTypeInfos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UnionTypeInfo)) return false;
        UnionTypeInfo o = (UnionTypeInfo)other;
        if (!this.objectTypeInfos.equals(o.objectTypeInfos)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.objectTypeInfos.hashCode();
    }
}

