/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;

public final class ValidWriteIdList {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private final String tableName;
    private final long[] exceptions;
    private final long minOpenWriteId;
    private final long highWatermark;

    public ValidWriteIdList(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            this.highWatermark = Long.MAX_VALUE;
            this.exceptions = new long[0];
            this.minOpenWriteId = Long.MAX_VALUE;
            this.tableName = null;
            return;
        }
        List values = COLON_SPLITTER.splitToList((CharSequence)value);
        Preconditions.checkArgument((values.size() >= 3 ? 1 : 0) != 0, (String)"invalid write ID list: %s", (Object)value);
        this.tableName = ((String)values.get(0)).equalsIgnoreCase("null") ? null : (String)values.get(0);
        this.highWatermark = Long.parseLong((String)values.get(1));
        this.minOpenWriteId = Long.parseLong((String)values.get(2));
        List openWriteIds = List.of();
        List abortedWriteIds = List.of();
        if (values.size() >= 4) {
            if (values.size() == 4) {
                if (!((String)values.get(3)).isEmpty()) {
                    openWriteIds = COMMA_SPLITTER.splitToList((CharSequence)values.get(3));
                }
            } else {
                if (!((String)values.get(3)).isEmpty()) {
                    openWriteIds = COMMA_SPLITTER.splitToList((CharSequence)values.get(3));
                }
                if (!((String)values.get(4)).isEmpty()) {
                    abortedWriteIds = COMMA_SPLITTER.splitToList((CharSequence)values.get(4));
                }
            }
        }
        this.exceptions = new long[openWriteIds.size() + abortedWriteIds.size()];
        int i = 0;
        for (String open : openWriteIds) {
            this.exceptions[i] = Long.parseLong(open);
            ++i;
        }
        for (String abort : abortedWriteIds) {
            this.exceptions[i] = Long.parseLong(abort);
            ++i;
        }
        Arrays.sort(this.exceptions);
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getHighWatermark() {
        return this.highWatermark;
    }

    public long[] getInvalidWriteIds() {
        return this.exceptions;
    }

    public boolean isWriteIdValid(long writeId) {
        if (writeId > this.highWatermark) {
            return false;
        }
        return Arrays.binarySearch(this.exceptions, writeId) < 0;
    }

    public boolean isValidBase(long writeId) {
        return writeId < this.minOpenWriteId && writeId <= this.highWatermark;
    }

    public boolean isWriteIdRangeValid(long minWriteId, long maxWriteId) {
        if (minWriteId > this.highWatermark) {
            return false;
        }
        if (this.exceptions.length > 0 && maxWriteId < this.exceptions[0]) {
            return true;
        }
        long count = Math.max(0L, maxWriteId - this.highWatermark);
        for (long txn : this.exceptions) {
            if (minWriteId > txn || txn > maxWriteId) continue;
            ++count;
        }
        return count == 0L || count != maxWriteId - minWriteId + 1L;
    }
}

