/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.GenericHiveRecordCursorProvider;
import io.trino.plugin.hive.HiveBucketAdapterRecordCursor;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePageSource;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveReaderProjectionsAdaptingRecordCursor;
import io.trino.plugin.hive.HiveRecordCursor;
import io.trino.plugin.hive.HiveRecordCursorProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class HivePageSourceProvider
implements ConnectorPageSourceProvider {
    private static final Pattern ORIGINAL_FILE_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<filename>(?<bucketNumber>\\d+)_(?<rest>.*)?)$");
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final int domainCompactionThreshold;
    private final Set<HivePageSourceFactory> pageSourceFactories;
    private final Set<HiveRecordCursorProvider> cursorProviders;

    @Inject
    public HivePageSourceProvider(TypeManager typeManager, HdfsEnvironment hdfsEnvironment, HiveConfig hiveConfig, Set<HivePageSourceFactory> pageSourceFactories, Set<HiveRecordCursorProvider> cursorProviders, GenericHiveRecordCursorProvider genericCursorProvider) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.domainCompactionThreshold = hiveConfig.getDomainCompactionThreshold();
        this.pageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(pageSourceFactories, "pageSourceFactories is null"));
        this.cursorProviders = ImmutableSet.builder().addAll((Iterable)Objects.requireNonNull(cursorProviders, "cursorProviders is null")).add((Object)genericCursorProvider).build();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        HiveSplit hiveSplit = (HiveSplit)split;
        if (HivePageSourceProvider.shouldSkipBucket(hiveTable, hiveSplit, dynamicFilter)) {
            return new EmptyPageSource();
        }
        List<HiveColumnHandle> hiveColumns = columns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        boolean originalFile = ORIGINAL_FILE_PATH_MATCHER.matcher(hiveSplit.getPath()).matches();
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(hiveSplit.getPartitionName(), hiveSplit.getPartitionKeys(), hiveColumns, hiveSplit.getBucketConversion().map(HiveSplit.BucketConversion::bucketColumnHandles).orElse((List)ImmutableList.of()), hiveSplit.getTableToPartitionMapping(), hiveSplit.getPath(), hiveSplit.getTableBucketNumber(), hiveSplit.getEstimatedFileSize(), hiveSplit.getFileModifiedTime());
        if (HivePageSourceProvider.shouldSkipSplit(columnMappings, dynamicFilter)) {
            return new EmptyPageSource();
        }
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsContext(session), new Path(hiveSplit.getPath()));
        TupleDomain simplifiedDynamicFilter = dynamicFilter.getCurrentPredicate().transformKeys(HiveColumnHandle.class::cast).simplify(this.domainCompactionThreshold);
        Optional<ConnectorPageSource> pageSource = HivePageSourceProvider.createHivePageSource(this.pageSourceFactories, this.cursorProviders, configuration, session, Location.of((String)hiveSplit.getPath()), hiveSplit.getTableBucketNumber(), hiveSplit.getStart(), hiveSplit.getLength(), hiveSplit.getEstimatedFileSize(), hiveSplit.getSchema(), (TupleDomain<HiveColumnHandle>)hiveTable.getCompactEffectivePredicate().intersect(simplifiedDynamicFilter), hiveColumns, this.typeManager, hiveSplit.getBucketConversion(), hiveSplit.getBucketValidation(), hiveSplit.isS3SelectPushdownEnabled(), hiveSplit.getAcidInfo(), originalFile, hiveTable.getTransaction(), columnMappings);
        if (pageSource.isPresent()) {
            return pageSource.get();
        }
        throw new RuntimeException("Could not find a file reader for split " + hiveSplit);
    }

    public static Optional<ConnectorPageSource> createHivePageSource(Set<HivePageSourceFactory> pageSourceFactories, Set<HiveRecordCursorProvider> cursorProviders, Configuration configuration, ConnectorSession session, Location path, OptionalInt tableBucketNumber, long start, long length, long estimatedFileSize, Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> columns, TypeManager typeManager, Optional<HiveSplit.BucketConversion> bucketConversion, Optional<HiveSplit.BucketValidation> bucketValidation, boolean s3SelectPushdownEnabled, Optional<AcidInfo> acidInfo, boolean originalFile, AcidTransaction transaction, List<ColumnMapping> columnMappings) {
        Optional<Object> readerWithProjections;
        List<HiveColumnHandle> desiredColumns;
        if (effectivePredicate.isNone()) {
            return Optional.of(new EmptyPageSource());
        }
        List<ColumnMapping> regularAndInterimColumnMappings = ColumnMapping.extractRegularAndInterimColumnMappings(columnMappings);
        Optional<BucketAdaptation> bucketAdaptation = HivePageSourceProvider.createBucketAdaptation(bucketConversion, tableBucketNumber, regularAndInterimColumnMappings);
        Optional<HivePageSource.BucketValidator> bucketValidator = HivePageSourceProvider.createBucketValidator(path, bucketValidation, tableBucketNumber, regularAndInterimColumnMappings);
        for (HivePageSourceFactory pageSourceFactory : pageSourceFactories) {
            readerWithProjections = pageSourceFactory.createPageSource(configuration, session, path, start, length, estimatedFileSize, schema, desiredColumns = ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, true, typeManager), effectivePredicate, acidInfo, tableBucketNumber, originalFile, transaction);
            if (!readerWithProjections.isPresent()) continue;
            ConnectorPageSource pageSource = readerWithProjections.get().get();
            Optional<ReaderColumns> readerProjections = ((ReaderPageSource)readerWithProjections.get()).getReaderColumns();
            Optional<ReaderProjectionsAdapter> adapter = Optional.empty();
            if (readerProjections.isPresent()) {
                adapter = Optional.of(HivePageSourceProvider.hiveProjectionsAdapter(desiredColumns, readerProjections.get()));
            }
            return Optional.of(new HivePageSource(columnMappings, bucketAdaptation, bucketValidator, adapter, typeManager, HiveSessionProperties.getTimestampPrecision(session), pageSource));
        }
        for (HiveRecordCursorProvider provider : cursorProviders) {
            readerWithProjections = provider.createRecordCursor(configuration, session, path, start, length, estimatedFileSize, schema, desiredColumns = ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, false, typeManager), effectivePredicate, typeManager, s3SelectPushdownEnabled);
            if (!readerWithProjections.isPresent()) continue;
            RecordCursor delegate = ((HiveRecordCursorProvider.ReaderRecordCursorWithProjections)readerWithProjections.get()).getRecordCursor();
            Optional<ReaderColumns> projections = ((HiveRecordCursorProvider.ReaderRecordCursorWithProjections)readerWithProjections.get()).getProjectedReaderColumns();
            if (projections.isPresent()) {
                ReaderProjectionsAdapter projectionsAdapter = HivePageSourceProvider.hiveProjectionsAdapter(desiredColumns, projections.get());
                delegate = new HiveReaderProjectionsAdaptingRecordCursor(delegate, projectionsAdapter);
            }
            Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
            if (bucketAdaptation.isPresent()) {
                delegate = new HiveBucketAdapterRecordCursor(bucketAdaptation.get().getBucketColumnIndices(), bucketAdaptation.get().getBucketColumnHiveTypes(), bucketAdaptation.get().getBucketingVersion(), bucketAdaptation.get().getTableBucketCount(), bucketAdaptation.get().getPartitionBucketCount(), bucketAdaptation.get().getBucketToKeep(), typeManager, delegate);
            }
            if (bucketAdaptation.isEmpty() && bucketValidator.isPresent()) {
                delegate = bucketValidator.get().wrapRecordCursor(delegate, typeManager);
            }
            HiveRecordCursor hiveRecordCursor = new HiveRecordCursor(columnMappings, delegate);
            List columnTypes = columns.stream().map(HiveColumnHandle::getType).collect(Collectors.toList());
            return Optional.of(new RecordPageSource(columnTypes, (RecordCursor)hiveRecordCursor));
        }
        return Optional.empty();
    }

    private static boolean shouldSkipBucket(HiveTableHandle hiveTable, HiveSplit hiveSplit, DynamicFilter dynamicFilter) {
        if (hiveSplit.getTableBucketNumber().isEmpty()) {
            return false;
        }
        Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter = HiveBucketing.getHiveBucketFilter(hiveTable, (TupleDomain<ColumnHandle>)dynamicFilter.getCurrentPredicate());
        return hiveBucketFilter.map(filter -> !filter.getBucketsToKeep().contains(hiveSplit.getTableBucketNumber().getAsInt())).orElse(false);
    }

    private static boolean shouldSkipSplit(List<ColumnMapping> columnMappings, DynamicFilter dynamicFilter) {
        TupleDomain predicate = dynamicFilter.getCurrentPredicate();
        if (predicate.isNone()) {
            return true;
        }
        Map domains = (Map)predicate.getDomains().get();
        for (ColumnMapping columnMapping : columnMappings) {
            if (columnMapping.getKind() != ColumnMappingKind.PREFILLED) continue;
            Object value = columnMapping.getPrefilledValue().getValue();
            Domain allowedDomain = (Domain)domains.get(columnMapping.getHiveColumnHandle());
            if (allowedDomain == null || allowedDomain.includesNullableValue(value)) continue;
            return true;
        }
        return false;
    }

    private static ReaderProjectionsAdapter hiveProjectionsAdapter(List<HiveColumnHandle> expectedColumns, ReaderColumns readColumns) {
        return new ReaderProjectionsAdapter((List)expectedColumns.stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), readColumns, column -> ((HiveColumnHandle)column).getType(), HivePageSourceProvider::getProjection);
    }

    public static List<Integer> getProjection(ColumnHandle expected, ColumnHandle read) {
        HiveColumnHandle expectedColumn = (HiveColumnHandle)expected;
        HiveColumnHandle readColumn = (HiveColumnHandle)read;
        Preconditions.checkArgument((boolean)expectedColumn.getBaseColumn().equals(readColumn.getBaseColumn()), (Object)"reader column is not valid for expected column");
        List expectedDereferences = expectedColumn.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
        List readerDereferences = readColumn.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
        Preconditions.checkArgument((readerDereferences.size() <= expectedDereferences.size() ? 1 : 0) != 0, (Object)"Field returned by the reader should include expected field");
        Preconditions.checkArgument((boolean)expectedDereferences.subList(0, readerDereferences.size()).equals(readerDereferences), (Object)"Field returned by the reader should be a prefix of expected field");
        return expectedDereferences.subList(readerDereferences.size(), expectedDereferences.size());
    }

    private static Optional<BucketAdaptation> createBucketAdaptation(Optional<HiveSplit.BucketConversion> bucketConversion, OptionalInt bucketNumber, List<ColumnMapping> columnMappings) {
        return bucketConversion.map(conversion -> {
            List baseColumnMapping = columnMappings.stream().filter(mapping -> mapping.getHiveColumnHandle().isBaseColumn()).collect(Collectors.toList());
            ImmutableMap baseHiveColumnToBlockIndex = Maps.uniqueIndex(baseColumnMapping, mapping -> mapping.getHiveColumnHandle().getBaseHiveColumnIndex());
            int[] bucketColumnIndices = conversion.bucketColumnHandles().stream().mapToInt(arg_0 -> HivePageSourceProvider.lambda$createBucketAdaptation$4((Map)baseHiveColumnToBlockIndex, arg_0)).toArray();
            List bucketColumnHiveTypes = (List)conversion.bucketColumnHandles().stream().map(arg_0 -> HivePageSourceProvider.lambda$createBucketAdaptation$5((Map)baseHiveColumnToBlockIndex, arg_0)).collect(ImmutableList.toImmutableList());
            return new BucketAdaptation(bucketColumnIndices, bucketColumnHiveTypes, conversion.bucketingVersion(), conversion.tableBucketCount(), conversion.partitionBucketCount(), bucketNumber.getAsInt());
        });
    }

    private static Optional<HivePageSource.BucketValidator> createBucketValidator(Location path, Optional<HiveSplit.BucketValidation> bucketValidation, OptionalInt bucketNumber, List<ColumnMapping> columnMappings) {
        return bucketValidation.flatMap(validation -> {
            Map baseHiveColumnToBlockIndex = (Map)columnMappings.stream().filter(mapping -> mapping.getHiveColumnHandle().isBaseColumn()).collect(ImmutableMap.toImmutableMap(mapping -> mapping.getHiveColumnHandle().getBaseHiveColumnIndex(), Function.identity()));
            int[] bucketColumnIndices = new int[validation.bucketColumns().size()];
            ArrayList<TypeInfo> bucketColumnTypes = new ArrayList<TypeInfo>();
            for (int i = 0; i < validation.bucketColumns().size(); ++i) {
                HiveColumnHandle column = validation.bucketColumns().get(i);
                ColumnMapping mapping2 = (ColumnMapping)baseHiveColumnToBlockIndex.get(column.getBaseHiveColumnIndex());
                if (mapping2 == null) {
                    return Optional.empty();
                }
                bucketColumnIndices[i] = mapping2.getIndex();
                bucketColumnTypes.add(mapping2.getHiveColumnHandle().getHiveType().getTypeInfo());
            }
            return Optional.of(new HivePageSource.BucketValidator(path, bucketColumnIndices, bucketColumnTypes, validation.bucketingVersion(), validation.bucketCount(), bucketNumber.orElseThrow()));
        });
    }

    public static Optional<ReaderColumns> projectBaseColumns(List<HiveColumnHandle> columns) {
        return HivePageSourceProvider.projectBaseColumns(columns, false);
    }

    public static Optional<ReaderColumns> projectBaseColumns(List<HiveColumnHandle> columns, boolean useColumnNames) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(HiveColumnHandle::isBaseColumn)) {
            return Optional.empty();
        }
        ImmutableList.Builder projectedColumns = ImmutableList.builder();
        ImmutableList.Builder outputColumnMapping = ImmutableList.builder();
        HashMap<Object, Integer> mappedHiveBaseColumnKeys = new HashMap<Object, Integer>();
        int projectedColumnCount = 0;
        for (HiveColumnHandle column : columns) {
            Object baseColumnKey = useColumnNames ? column.getBaseColumnName() : Integer.valueOf(column.getBaseHiveColumnIndex());
            Integer mapped = (Integer)mappedHiveBaseColumnKeys.get(baseColumnKey);
            if (mapped == null) {
                projectedColumns.add((Object)column.getBaseColumn());
                mappedHiveBaseColumnKeys.put(baseColumnKey, projectedColumnCount);
                outputColumnMapping.add((Object)projectedColumnCount);
                ++projectedColumnCount;
                continue;
            }
            outputColumnMapping.add((Object)mapped);
        }
        return Optional.of(new ReaderColumns((List<? extends ColumnHandle>)projectedColumns.build(), (List<Integer>)outputColumnMapping.build()));
    }

    public static Optional<ReaderColumns> projectSufficientColumns(List<HiveColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(HiveColumnHandle::isBaseColumn)) {
            return Optional.empty();
        }
        ImmutableBiMap.Builder dereferenceChainsBuilder = ImmutableBiMap.builder();
        for (HiveColumnHandle column : columns) {
            List indices = column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
            DereferenceChain dereferenceChain = new DereferenceChain(column.getBaseColumnName(), indices);
            dereferenceChainsBuilder.put((Object)dereferenceChain, (Object)column);
        }
        ImmutableBiMap dereferenceChains = dereferenceChainsBuilder.build();
        ArrayList<ColumnHandle> sufficientColumns = new ArrayList<ColumnHandle>();
        ImmutableList.Builder outputColumnMapping = ImmutableList.builder();
        HashMap<DereferenceChain, Integer> pickedColumns = new HashMap<DereferenceChain, Integer>();
        for (HiveColumnHandle columnHandle : columns) {
            int inputBlockIndex;
            DereferenceChain column = (DereferenceChain)dereferenceChains.inverse().get((Object)columnHandle);
            List<DereferenceChain> orderedPrefixes = column.getOrderedPrefixes();
            DereferenceChain chosenColumn = null;
            for (DereferenceChain prefix : orderedPrefixes) {
                if (!dereferenceChains.containsKey((Object)prefix)) continue;
                chosenColumn = prefix;
                break;
            }
            Preconditions.checkState((chosenColumn != null ? 1 : 0) != 0, (Object)"chosenColumn is null");
            if (pickedColumns.containsKey(chosenColumn)) {
                inputBlockIndex = (Integer)pickedColumns.get(chosenColumn);
            } else {
                sufficientColumns.add((ColumnHandle)dereferenceChains.get((Object)chosenColumn));
                pickedColumns.put(chosenColumn, sufficientColumns.size() - 1);
                inputBlockIndex = sufficientColumns.size() - 1;
            }
            outputColumnMapping.add((Object)inputBlockIndex);
        }
        return Optional.of(new ReaderColumns(sufficientColumns, (List<Integer>)outputColumnMapping.build()));
    }

    private static /* synthetic */ HiveType lambda$createBucketAdaptation$5(Map baseHiveColumnToBlockIndex, HiveColumnHandle columnHandle) {
        return ((ColumnMapping)baseHiveColumnToBlockIndex.get(columnHandle.getBaseHiveColumnIndex())).getHiveColumnHandle().getHiveType();
    }

    private static /* synthetic */ int lambda$createBucketAdaptation$4(Map baseHiveColumnToBlockIndex, HiveColumnHandle columnHandle) {
        return ((ColumnMapping)baseHiveColumnToBlockIndex.get(columnHandle.getBaseHiveColumnIndex())).getIndex();
    }

    public static class ColumnMapping {
        private final ColumnMappingKind kind;
        private final HiveColumnHandle hiveColumnHandle;
        private final Optional<NullableValue> prefilledValue;
        private final OptionalInt index;
        private final Optional<HiveType> baseTypeCoercionFrom;

        public static ColumnMapping regular(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.REGULAR, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), baseTypeCoercionFrom);
        }

        public static ColumnMapping synthesized(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.SYNTHESIZED, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), baseTypeCoercionFrom);
        }

        public static ColumnMapping prefilled(HiveColumnHandle hiveColumnHandle, NullableValue prefilledValue, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.PARTITION_KEY || hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)hiveColumnHandle.isBaseColumn(), (Object)"prefilled values not supported for projected columns");
            return new ColumnMapping(ColumnMappingKind.PREFILLED, hiveColumnHandle, Optional.of(prefilledValue), OptionalInt.empty(), baseTypeCoercionFrom);
        }

        public static ColumnMapping interim(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.INTERIM, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), baseTypeCoercionFrom);
        }

        public static ColumnMapping empty(HiveColumnHandle hiveColumnHandle) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.EMPTY, hiveColumnHandle, Optional.empty(), OptionalInt.empty(), Optional.empty());
        }

        private ColumnMapping(ColumnMappingKind kind, HiveColumnHandle hiveColumnHandle, Optional<NullableValue> prefilledValue, OptionalInt index, Optional<HiveType> baseTypeCoercionFrom) {
            this.kind = Objects.requireNonNull(kind, "kind is null");
            this.hiveColumnHandle = Objects.requireNonNull(hiveColumnHandle, "hiveColumnHandle is null");
            this.prefilledValue = Objects.requireNonNull(prefilledValue, "prefilledValue is null");
            this.index = Objects.requireNonNull(index, "index is null");
            this.baseTypeCoercionFrom = Objects.requireNonNull(baseTypeCoercionFrom, "baseTypeCoercionFrom is null");
        }

        public ColumnMappingKind getKind() {
            return this.kind;
        }

        public NullableValue getPrefilledValue() {
            Preconditions.checkState((this.kind == ColumnMappingKind.PREFILLED ? 1 : 0) != 0);
            return this.prefilledValue.get();
        }

        public HiveColumnHandle getHiveColumnHandle() {
            return this.hiveColumnHandle;
        }

        public int getIndex() {
            Preconditions.checkState((this.kind == ColumnMappingKind.REGULAR || this.kind == ColumnMappingKind.INTERIM || HiveColumnHandle.isRowIdColumnHandle(this.hiveColumnHandle) ? 1 : 0) != 0);
            return this.index.getAsInt();
        }

        public Optional<HiveType> getBaseTypeCoercionFrom() {
            return this.baseTypeCoercionFrom;
        }

        public static List<ColumnMapping> buildColumnMappings(String partitionName, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, List<HiveColumnHandle> requiredInterimColumns, TableToPartitionMapping tableToPartitionMapping, String path, OptionalInt bucketNumber, long estimatedFileSize, long fileModifiedTime) {
            ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
            HashSet<Integer> baseColumnHiveIndices = new HashSet<Integer>();
            HashMap<Integer, Set> projectionsForColumn = new HashMap<Integer, Set>();
            ImmutableList.Builder columnMappings = ImmutableList.builder();
            int regularIndex = 0;
            for (HiveColumnHandle column : columns) {
                Optional<HiveType> baseTypeCoercionFrom = tableToPartitionMapping.getCoercion(column.getBaseHiveColumnIndex());
                if (column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR) {
                    if (column.isBaseColumn()) {
                        baseColumnHiveIndices.add(column.getBaseHiveColumnIndex());
                    }
                    Preconditions.checkArgument((boolean)projectionsForColumn.computeIfAbsent(column.getBaseHiveColumnIndex(), columnIndex -> new HashSet()).add(column.getHiveColumnProjectionInfo()), (Object)"duplicate column in columns list");
                    if (baseTypeCoercionFrom.isEmpty() || ColumnMapping.projectionValidForType(baseTypeCoercionFrom.get(), column.getHiveColumnProjectionInfo())) {
                        columnMappings.add((Object)ColumnMapping.regular(column, regularIndex, baseTypeCoercionFrom));
                        ++regularIndex;
                        continue;
                    }
                    columnMappings.add((Object)ColumnMapping.empty(column));
                    continue;
                }
                if (HiveColumnHandle.isRowIdColumnHandle(column)) {
                    baseColumnHiveIndices.add(column.getBaseHiveColumnIndex());
                    Preconditions.checkArgument((boolean)projectionsForColumn.computeIfAbsent(column.getBaseHiveColumnIndex(), index -> new HashSet()).add(column.getHiveColumnProjectionInfo()), (Object)"duplicate column in columns list");
                    if (!baseTypeCoercionFrom.isEmpty() && !ColumnMapping.projectionValidForType(baseTypeCoercionFrom.get(), column.getHiveColumnProjectionInfo())) {
                        throw new RuntimeException("baseTypeCoercisionFrom was empty for the rowId column");
                    }
                    columnMappings.add((Object)ColumnMapping.synthesized(column, regularIndex, baseTypeCoercionFrom));
                    ++regularIndex;
                    continue;
                }
                columnMappings.add((Object)ColumnMapping.prefilled(column, HiveUtil.getPrefilledColumnValue(column, (HivePartitionKey)partitionKeysByName.get(column.getName()), path, bucketNumber, estimatedFileSize, fileModifiedTime, partitionName), baseTypeCoercionFrom));
            }
            for (HiveColumnHandle column : requiredInterimColumns) {
                Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)column.isBaseColumn(), (Object)"bucketed columns should be base columns");
                if (baseColumnHiveIndices.contains(column.getBaseHiveColumnIndex())) continue;
                if (projectionsForColumn.containsKey(column.getBaseHiveColumnIndex())) {
                    columnMappings.add((Object)ColumnMapping.interim(column, regularIndex, tableToPartitionMapping.getCoercion(column.getBaseHiveColumnIndex())));
                } else {
                    columnMappings.add((Object)ColumnMapping.interim(column, regularIndex, Optional.empty()));
                }
                ++regularIndex;
            }
            return columnMappings.build();
        }

        private static boolean projectionValidForType(HiveType baseType, Optional<HiveColumnProjectionInfo> projection) {
            List dereferences = projection.map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
            Optional<HiveType> targetType = baseType.getHiveTypeForDereferences(dereferences);
            return targetType.isPresent();
        }

        public static List<ColumnMapping> extractRegularAndInterimColumnMappings(List<ColumnMapping> columnMappings) {
            return (List)columnMappings.stream().filter(columnMapping -> columnMapping.getKind() == ColumnMappingKind.REGULAR || columnMapping.getKind() == ColumnMappingKind.INTERIM).collect(ImmutableList.toImmutableList());
        }

        public static List<HiveColumnHandle> toColumnHandles(List<ColumnMapping> regularColumnMappings, boolean doCoercion, TypeManager typeManager) {
            return regularColumnMappings.stream().map(columnMapping -> {
                HiveColumnHandle columnHandle = columnMapping.getHiveColumnHandle();
                if (!doCoercion || columnMapping.getBaseTypeCoercionFrom().isEmpty()) {
                    return columnHandle;
                }
                HiveType fromHiveTypeBase = columnMapping.getBaseTypeCoercionFrom().get();
                Optional<HiveColumnProjectionInfo> newColumnProjectionInfo = columnHandle.getHiveColumnProjectionInfo().map(projectedColumn -> {
                    HiveType fromHiveType = fromHiveTypeBase.getHiveTypeForDereferences(projectedColumn.getDereferenceIndices()).get();
                    return new HiveColumnProjectionInfo(projectedColumn.getDereferenceIndices(), projectedColumn.getDereferenceNames(), fromHiveType, fromHiveType.getType(typeManager));
                });
                return new HiveColumnHandle(columnHandle.getBaseColumnName(), columnHandle.getBaseHiveColumnIndex(), fromHiveTypeBase, fromHiveTypeBase.getType(typeManager), newColumnProjectionInfo, columnHandle.getColumnType(), columnHandle.getComment());
            }).collect(Collectors.toList());
        }
    }

    public static class BucketAdaptation {
        private final int[] bucketColumnIndices;
        private final List<HiveType> bucketColumnHiveTypes;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final int bucketToKeep;

        public BucketAdaptation(int[] bucketColumnIndices, List<HiveType> bucketColumnHiveTypes, HiveBucketing.BucketingVersion bucketingVersion, int tableBucketCount, int partitionBucketCount, int bucketToKeep) {
            this.bucketColumnIndices = bucketColumnIndices;
            this.bucketColumnHiveTypes = bucketColumnHiveTypes;
            this.bucketingVersion = bucketingVersion;
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
            this.bucketToKeep = bucketToKeep;
        }

        public int[] getBucketColumnIndices() {
            return this.bucketColumnIndices;
        }

        public List<HiveType> getBucketColumnHiveTypes() {
            return this.bucketColumnHiveTypes;
        }

        public HiveBucketing.BucketingVersion getBucketingVersion() {
            return this.bucketingVersion;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getPartitionBucketCount() {
            return this.partitionBucketCount;
        }

        public int getBucketToKeep() {
            return this.bucketToKeep;
        }
    }

    public static enum ColumnMappingKind {
        REGULAR,
        PREFILLED,
        INTERIM,
        SYNTHESIZED,
        EMPTY;

    }

    private static class DereferenceChain {
        private final String name;
        private final List<Integer> indices;

        public DereferenceChain(String name, List<Integer> indices) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.indices = ImmutableList.copyOf((Collection)Objects.requireNonNull(indices, "indices is null"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DereferenceChain that = (DereferenceChain)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.indices, that.indices);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.indices);
        }

        public List<DereferenceChain> getOrderedPrefixes() {
            ImmutableList.Builder prefixes = ImmutableList.builder();
            for (int prefixLen = 0; prefixLen <= this.indices.size(); ++prefixLen) {
                prefixes.add((Object)new DereferenceChain(this.name, this.indices.subList(0, prefixLen)));
            }
            return prefixes.build();
        }
    }
}

