/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimaps;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.Path;

public class PartitionUpdate {
    private final String name;
    private final UpdateMode updateMode;
    private final Path writePath;
    private final Path targetPath;
    private final List<String> fileNames;
    private final long rowCount;
    private final long inMemoryDataSizeInBytes;
    private final long onDiskDataSizeInBytes;

    @JsonCreator
    public PartitionUpdate(@JsonProperty(value="name") String name, @JsonProperty(value="updateMode") UpdateMode updateMode, @JsonProperty(value="writePath") String writePath, @JsonProperty(value="targetPath") String targetPath, @JsonProperty(value="fileNames") List<String> fileNames, @JsonProperty(value="rowCount") long rowCount, @JsonProperty(value="inMemoryDataSizeInBytes") long inMemoryDataSizeInBytes, @JsonProperty(value="onDiskDataSizeInBytes") long onDiskDataSizeInBytes) {
        this(name, updateMode, new Path(Objects.requireNonNull(writePath, "writePath is null")), new Path(Objects.requireNonNull(targetPath, "targetPath is null")), fileNames, rowCount, inMemoryDataSizeInBytes, onDiskDataSizeInBytes);
    }

    public PartitionUpdate(String name, UpdateMode updateMode, Path writePath, Path targetPath, List<String> fileNames, long rowCount, long inMemoryDataSizeInBytes, long onDiskDataSizeInBytes) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.updateMode = Objects.requireNonNull(updateMode, "updateMode is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.fileNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fileNames, "fileNames is null"));
        this.rowCount = rowCount;
        Preconditions.checkArgument((inMemoryDataSizeInBytes >= 0L ? 1 : 0) != 0, (String)"inMemoryDataSizeInBytes is negative: %s", (long)inMemoryDataSizeInBytes);
        this.inMemoryDataSizeInBytes = inMemoryDataSizeInBytes;
        Preconditions.checkArgument((onDiskDataSizeInBytes >= 0L ? 1 : 0) != 0, (String)"onDiskDataSizeInBytes is negative: %s", (long)onDiskDataSizeInBytes);
        this.onDiskDataSizeInBytes = onDiskDataSizeInBytes;
    }

    public PartitionUpdate withRowCount(int rowCount) {
        return new PartitionUpdate(this.name, this.updateMode, this.writePath, this.targetPath, this.fileNames, (long)rowCount, this.inMemoryDataSizeInBytes, this.onDiskDataSizeInBytes);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public Path getWritePath() {
        return this.writePath;
    }

    public Path getTargetPath() {
        return this.targetPath;
    }

    @JsonProperty
    public List<String> getFileNames() {
        return this.fileNames;
    }

    @JsonProperty(value="targetPath")
    public String getJsonSerializableTargetPath() {
        return this.targetPath.toString();
    }

    @JsonProperty(value="writePath")
    public String getJsonSerializableWritePath() {
        return this.writePath.toString();
    }

    @JsonProperty
    public long getRowCount() {
        return this.rowCount;
    }

    @JsonProperty
    public long getInMemoryDataSizeInBytes() {
        return this.inMemoryDataSizeInBytes;
    }

    @JsonProperty
    public long getOnDiskDataSizeInBytes() {
        return this.onDiskDataSizeInBytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("updateMode", (Object)this.updateMode).add("writePath", (Object)this.writePath).add("targetPath", (Object)this.targetPath).add("fileNames", this.fileNames).add("rowCount", this.rowCount).add("inMemoryDataSizeInBytes", this.inMemoryDataSizeInBytes).add("onDiskDataSizeInBytes", this.onDiskDataSizeInBytes).toString();
    }

    public HiveBasicStatistics getStatistics() {
        return new HiveBasicStatistics(this.fileNames.size(), this.rowCount, this.inMemoryDataSizeInBytes, this.onDiskDataSizeInBytes);
    }

    public static List<PartitionUpdate> mergePartitionUpdates(Iterable<PartitionUpdate> unMergedUpdates) {
        ImmutableList.Builder partitionUpdates = ImmutableList.builder();
        for (Collection partitionGroup : Multimaps.index(unMergedUpdates, PartitionUpdate::getName).asMap().values()) {
            PartitionUpdate firstPartition = (PartitionUpdate)partitionGroup.iterator().next();
            ImmutableList.Builder allFileNames = ImmutableList.builder();
            long totalRowCount = 0L;
            long totalInMemoryDataSizeInBytes = 0L;
            long totalOnDiskDataSizeInBytes = 0L;
            for (PartitionUpdate partition : partitionGroup) {
                if (partition.getUpdateMode() != firstPartition.getUpdateMode() || !partition.getWritePath().equals((Object)firstPartition.getWritePath()) || !partition.getTargetPath().equals((Object)firstPartition.getTargetPath())) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, String.format("Partition %s was added or modified during INSERT", firstPartition.getName()));
                }
                allFileNames.addAll(partition.getFileNames());
                totalRowCount += partition.getRowCount();
                totalInMemoryDataSizeInBytes += partition.getInMemoryDataSizeInBytes();
                totalOnDiskDataSizeInBytes += partition.getOnDiskDataSizeInBytes();
            }
            partitionUpdates.add((Object)new PartitionUpdate(firstPartition.getName(), firstPartition.getUpdateMode(), firstPartition.getWritePath(), firstPartition.getTargetPath(), (List<String>)allFileNames.build(), totalRowCount, totalInMemoryDataSizeInBytes, totalOnDiskDataSizeInBytes));
        }
        return partitionUpdates.build();
    }

    public static enum UpdateMode {
        NEW,
        APPEND,
        OVERWRITE;

    }
}

