/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.NativeLogicalTypesAvroTypeManager;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.avro.Schema;
import org.joda.time.DateTimeZone;

public class HiveAvroTypeManager
extends NativeLogicalTypesAvroTypeManager {
    private final AtomicReference<ZoneId> convertToTimezone = new AtomicReference<ZoneOffset>(ZoneOffset.UTC);
    private final TimestampType upcastMillisToType;

    public HiveAvroTypeManager(HiveTimestampPrecision hiveTimestampPrecision) {
        this.upcastMillisToType = TimestampType.createTimestampType((int)Objects.requireNonNull(hiveTimestampPrecision, "hiveTimestampPrecision is null").getPrecision());
    }

    public void configure(Map<String, byte[]> fileMetadata) {
        if (fileMetadata.containsKey("writer.time.zone")) {
            this.convertToTimezone.set(ZoneId.of(new String(fileMetadata.get("writer.time.zone"), StandardCharsets.UTF_8)));
        } else {
            this.convertToTimezone.set(TimeZone.getDefault().toZoneId());
        }
    }

    public Optional<Type> overrideTypeForSchema(Schema schema) throws AvroTypeException {
        if (schema.getType() == Schema.Type.NULL) {
            return Optional.of(BooleanType.BOOLEAN);
        }
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult result = HiveAvroTypeManager.validateLogicalType((Schema)schema);
        if (result instanceof NativeLogicalTypesAvroTypeManager.NoLogicalType) {
            NativeLogicalTypesAvroTypeManager.NoLogicalType ignored = (NativeLogicalTypesAvroTypeManager.NoLogicalType)result;
            return Optional.empty();
        }
        if (result instanceof NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType) {
            NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType nonNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType)result;
            return switch (nonNativeAvroLogicalType.getLogicalTypeName()) {
                case "varchar", "char" -> Optional.of(HiveAvroTypeManager.getHiveLogicalVarCharOrCharType(schema, nonNativeAvroLogicalType));
                default -> Optional.empty();
            };
        }
        if (result instanceof NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType) {
            NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType invalidNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType)result;
            switch (invalidNativeAvroLogicalType.getLogicalTypeName()) {
                case "timestamp-millis": 
                case "date": 
                case "decimal": {
                    throw invalidNativeAvroLogicalType.getCause();
                }
            }
            return Optional.empty();
        }
        if (result instanceof NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType) {
            NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType validNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType)result;
            return switch (validNativeAvroLogicalType.getLogicalType().getName()) {
                case "date" -> super.overrideTypeForSchema(schema);
                case "timestamp-millis" -> Optional.of(this.upcastMillisToType);
                case "decimal" -> {
                    if (schema.getType() == Schema.Type.FIXED) {
                        throw new AvroTypeException("Hive does not support fixed decimal types");
                    }
                    yield super.overrideTypeForSchema(schema);
                }
                default -> Optional.empty();
            };
        }
        throw new IllegalStateException("Unhandled validate logical type result");
    }

    public Optional<BiConsumer<BlockBuilder, Object>> overrideBuildingFunctionForSchema(Schema schema) throws AvroTypeException {
        NativeLogicalTypesAvroTypeManager.ValidateLogicalTypeResult result = HiveAvroTypeManager.validateLogicalType((Schema)schema);
        if (result instanceof NativeLogicalTypesAvroTypeManager.NoLogicalType) {
            NativeLogicalTypesAvroTypeManager.NoLogicalType ignored = (NativeLogicalTypesAvroTypeManager.NoLogicalType)result;
            return Optional.empty();
        }
        if (result instanceof NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType) {
            NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType nonNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType)result;
            return switch (nonNativeAvroLogicalType.getLogicalTypeName()) {
                case "varchar", "char" -> {
                    Type type = HiveAvroTypeManager.getHiveLogicalVarCharOrCharType(schema, nonNativeAvroLogicalType);
                    if (nonNativeAvroLogicalType.getLogicalTypeName().equals("varchar")) {
                        yield Optional.of((blockBuilder, obj) -> type.writeSlice(blockBuilder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)obj.toString()), (Type)type)));
                    }
                    yield Optional.of((blockBuilder, obj) -> type.writeSlice(blockBuilder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)obj.toString()), (Type)type)));
                }
                default -> Optional.empty();
            };
        }
        if (result instanceof NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType) {
            NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType invalidNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.InvalidNativeAvroLogicalType)result;
            switch (invalidNativeAvroLogicalType.getLogicalTypeName()) {
                case "timestamp-millis": 
                case "date": 
                case "decimal": {
                    throw invalidNativeAvroLogicalType.getCause();
                }
            }
            return Optional.empty();
        }
        if (result instanceof NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType) {
            NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType validNativeAvroLogicalType = (NativeLogicalTypesAvroTypeManager.ValidNativeAvroLogicalType)result;
            return switch (validNativeAvroLogicalType.getLogicalType().getName()) {
                case "timestamp-millis" -> {
                    if (this.upcastMillisToType.isShort()) {
                        yield Optional.of((blockBuilder, obj) -> {
                            Long millisSinceEpochUTC = (Long)obj;
                            this.upcastMillisToType.writeLong(blockBuilder, DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.convertToTimezone.get())).convertUTCToLocal(millisSinceEpochUTC.longValue()) * 1000L);
                        });
                    }
                    yield Optional.of((blockBuilder, obj) -> {
                        Long millisSinceEpochUTC = (Long)obj;
                        LongTimestamp longTimestamp = new LongTimestamp(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.convertToTimezone.get())).convertUTCToLocal(millisSinceEpochUTC.longValue()) * 1000L, 0);
                        this.upcastMillisToType.writeObject(blockBuilder, (Object)longTimestamp);
                    });
                }
                case "date", "decimal" -> super.overrideBuildingFunctionForSchema(schema);
                default -> Optional.empty();
            };
        }
        throw new IllegalStateException("Unhandled validate logical type result");
    }

    private static Type getHiveLogicalVarCharOrCharType(Schema schema, NativeLogicalTypesAvroTypeManager.NonNativeAvroLogicalType nonNativeAvroLogicalType) throws AvroTypeException {
        if (schema.getType() != Schema.Type.STRING) {
            throw new AvroTypeException("Unsupported Avro type for Hive Logical Type in schema " + schema);
        }
        Object maxLengthObject = schema.getObjectProp("maxLength");
        if (maxLengthObject == null) {
            throw new AvroTypeException("Missing property maxLength in schema for Hive Type " + nonNativeAvroLogicalType.getLogicalTypeName());
        }
        try {
            int maxLength;
            if (maxLengthObject instanceof String) {
                String maxLengthString = (String)maxLengthObject;
                maxLength = Integer.parseInt(maxLengthString);
            } else if (maxLengthObject instanceof Number) {
                Number maxLengthNumber = (Number)maxLengthObject;
                maxLength = maxLengthNumber.intValue();
            } else {
                throw new AvroTypeException("Unrecognized property type for maxLength in schema " + schema);
            }
            if (nonNativeAvroLogicalType.getLogicalTypeName().equals("varchar")) {
                return VarcharType.createVarcharType((int)maxLength);
            }
            return CharType.createCharType((int)maxLength);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AvroTypeException("Property maxLength not convertible to Integer in Hive Logical type schema " + schema);
        }
    }
}

