/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.RealType;
import io.trino.spi.type.VarcharType;
import java.util.function.Function;

public final class DecimalCoercers {
    private DecimalCoercers() {
    }

    public static Function<Block, Block> createDecimalToDecimalCoercer(DecimalType fromType, DecimalType toType) {
        if (fromType.isShort()) {
            if (toType.isShort()) {
                return new ShortDecimalToShortDecimalCoercer(fromType, toType);
            }
            return new ShortDecimalToLongDecimalCoercer(fromType, toType);
        }
        if (toType.isShort()) {
            return new LongDecimalToShortDecimalCoercer(fromType, toType);
        }
        return new LongDecimalToLongDecimalCoercer(fromType, toType);
    }

    public static Function<Block, Block> createDecimalToDoubleCoercer(DecimalType fromType) {
        if (fromType.isShort()) {
            return new ShortDecimalToDoubleCoercer(fromType);
        }
        return new LongDecimalToDoubleCoercer(fromType);
    }

    public static Function<Block, Block> createDecimalToRealCoercer(DecimalType fromType) {
        if (fromType.isShort()) {
            return new ShortDecimalToRealCoercer(fromType);
        }
        return new LongDecimalToRealCoercer(fromType);
    }

    public static Function<Block, Block> createDecimalToVarcharCoercer(DecimalType fromType, VarcharType toType) {
        if (fromType.isShort()) {
            return new ShortDecimalToVarcharCoercer(fromType, toType);
        }
        return new LongDecimalToVarcharCoercer(fromType, toType);
    }

    public static Function<Block, Block> createDoubleToDecimalCoercer(DecimalType toType) {
        if (toType.isShort()) {
            return new DoubleToShortDecimalCoercer(toType);
        }
        return new DoubleToLongDecimalCoercer(toType);
    }

    public static Function<Block, Block> createRealToDecimalCoercer(DecimalType toType) {
        if (toType.isShort()) {
            return new RealToShortDecimalCoercer(toType);
        }
        return new RealToLongDecimalCoercer(toType);
    }

    private static class ShortDecimalToShortDecimalCoercer
    extends TypeCoercer<DecimalType, DecimalType> {
        private final long rescale;

        public ShortDecimalToShortDecimalCoercer(DecimalType fromType, DecimalType toType) {
            super(fromType, toType);
            this.rescale = Decimals.longTenToNth((int)Math.abs(toType.getScale() - fromType.getScale()));
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            long returnValue = DecimalConversions.shortToShortCast((long)((DecimalType)this.fromType).getLong(block, position), (long)((DecimalType)this.fromType).getPrecision(), (long)((DecimalType)this.fromType).getScale(), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale(), (long)this.rescale, (long)(this.rescale / 2L));
            ((DecimalType)this.toType).writeLong(blockBuilder, returnValue);
        }
    }

    private static class ShortDecimalToLongDecimalCoercer
    extends TypeCoercer<DecimalType, DecimalType> {
        public ShortDecimalToLongDecimalCoercer(DecimalType fromType, DecimalType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            Int128 coercedValue = DecimalConversions.shortToLongCast((long)((DecimalType)this.fromType).getLong(block, position), (long)((DecimalType)this.fromType).getPrecision(), (long)((DecimalType)this.fromType).getScale(), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale());
            ((DecimalType)this.toType).writeObject(blockBuilder, (Object)coercedValue);
        }
    }

    private static class LongDecimalToShortDecimalCoercer
    extends TypeCoercer<DecimalType, DecimalType> {
        public LongDecimalToShortDecimalCoercer(DecimalType fromType, DecimalType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            long returnValue = DecimalConversions.longToShortCast((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (long)((DecimalType)this.fromType).getPrecision(), (long)((DecimalType)this.fromType).getScale(), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale());
            ((DecimalType)this.toType).writeLong(blockBuilder, returnValue);
        }
    }

    private static class LongDecimalToLongDecimalCoercer
    extends TypeCoercer<DecimalType, DecimalType> {
        public LongDecimalToLongDecimalCoercer(DecimalType fromType, DecimalType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            Int128 coercedValue = DecimalConversions.longToLongCast((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (long)((DecimalType)this.fromType).getPrecision(), (long)((DecimalType)this.fromType).getScale(), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale());
            ((DecimalType)this.toType).writeObject(blockBuilder, (Object)coercedValue);
        }
    }

    private static class ShortDecimalToDoubleCoercer
    extends TypeCoercer<DecimalType, DoubleType> {
        private final long rescale;

        public ShortDecimalToDoubleCoercer(DecimalType fromType) {
            super(fromType, DoubleType.DOUBLE);
            this.rescale = Decimals.longTenToNth((int)fromType.getScale());
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DoubleType)this.toType).writeDouble(blockBuilder, DecimalConversions.shortDecimalToDouble((long)((DecimalType)this.fromType).getLong(block, position), (long)this.rescale));
        }
    }

    private static class LongDecimalToDoubleCoercer
    extends TypeCoercer<DecimalType, DoubleType> {
        public LongDecimalToDoubleCoercer(DecimalType fromType) {
            super(fromType, DoubleType.DOUBLE);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DoubleType)this.toType).writeDouble(blockBuilder, DecimalConversions.longDecimalToDouble((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (long)((DecimalType)this.fromType).getScale()));
        }
    }

    private static class ShortDecimalToRealCoercer
    extends TypeCoercer<DecimalType, RealType> {
        private final long rescale;

        public ShortDecimalToRealCoercer(DecimalType fromType) {
            super(fromType, RealType.REAL);
            this.rescale = Decimals.longTenToNth((int)fromType.getScale());
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((RealType)this.toType).writeLong(blockBuilder, DecimalConversions.shortDecimalToReal((long)((DecimalType)this.fromType).getLong(block, position), (long)this.rescale));
        }
    }

    private static class LongDecimalToRealCoercer
    extends TypeCoercer<DecimalType, RealType> {
        public LongDecimalToRealCoercer(DecimalType fromType) {
            super(fromType, RealType.REAL);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((RealType)this.toType).writeLong(blockBuilder, DecimalConversions.longDecimalToReal((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (long)((DecimalType)this.fromType).getScale()));
        }
    }

    private static class ShortDecimalToVarcharCoercer
    extends TypeCoercer<DecimalType, VarcharType> {
        private final int lengthLimit;

        protected ShortDecimalToVarcharCoercer(DecimalType fromType, VarcharType toType) {
            super(fromType, toType);
            this.lengthLimit = toType.getLength().orElse(Integer.MAX_VALUE);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            String stringValue = Decimals.toString((long)((DecimalType)this.fromType).getLong(block, position), (int)((DecimalType)this.fromType).getScale());
            if (stringValue.length() > this.lengthLimit) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Decimal value %s representation exceeds varchar(%s) bounds", stringValue, this.lengthLimit));
            }
            ((VarcharType)this.toType).writeString(blockBuilder, stringValue.substring(0, Math.min(this.lengthLimit, stringValue.length())));
        }
    }

    private static class LongDecimalToVarcharCoercer
    extends TypeCoercer<DecimalType, VarcharType> {
        private final int lengthLimit;

        protected LongDecimalToVarcharCoercer(DecimalType fromType, VarcharType toType) {
            super(fromType, toType);
            this.lengthLimit = toType.getLength().orElse(Integer.MAX_VALUE);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            String stringValue = Decimals.toString((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (int)((DecimalType)this.fromType).getScale());
            if (stringValue.length() > this.lengthLimit) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Decimal value %s representation exceeds varchar(%s) bounds", stringValue, this.lengthLimit));
            }
            ((VarcharType)this.toType).writeString(blockBuilder, stringValue.substring(0, Math.min(this.lengthLimit, stringValue.length())));
        }
    }

    private static class DoubleToShortDecimalCoercer
    extends TypeCoercer<DoubleType, DecimalType> {
        public DoubleToShortDecimalCoercer(DecimalType toType) {
            super(DoubleType.DOUBLE, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DecimalType)this.toType).writeLong(blockBuilder, DecimalConversions.doubleToShortDecimal((double)((DoubleType)this.fromType).getDouble(block, position), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale()));
        }
    }

    private static class DoubleToLongDecimalCoercer
    extends TypeCoercer<DoubleType, DecimalType> {
        public DoubleToLongDecimalCoercer(DecimalType toType) {
            super(DoubleType.DOUBLE, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DecimalType)this.toType).writeObject(blockBuilder, (Object)DecimalConversions.doubleToLongDecimal((double)((DoubleType)this.fromType).getDouble(block, position), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale()));
        }
    }

    private static class RealToShortDecimalCoercer
    extends TypeCoercer<RealType, DecimalType> {
        public RealToShortDecimalCoercer(DecimalType toType) {
            super(RealType.REAL, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DecimalType)this.toType).writeLong(blockBuilder, DecimalConversions.realToShortDecimal((float)((RealType)this.fromType).getFloat(block, position), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale()));
        }
    }

    private static class RealToLongDecimalCoercer
    extends TypeCoercer<RealType, DecimalType> {
        public RealToLongDecimalCoercer(DecimalType toType) {
            super(RealType.REAL, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DecimalType)this.toType).writeObject(blockBuilder, (Object)DecimalConversions.realToLongDecimal((float)((RealType)this.fromType).getFloat(block, position), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale()));
        }
    }
}

