/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;

public final class TimestampCoercer {
    private static final DateTimeFormatter LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withChronology(IsoChronology.INSTANCE);

    private TimestampCoercer() {
    }

    public static class LongTimestampToVarcharCoercer
    extends TypeCoercer<TimestampType, VarcharType> {
        public LongTimestampToVarcharCoercer(TimestampType fromType, VarcharType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            LongTimestamp timestamp = (LongTimestamp)((TimestampType)this.fromType).getObject(block, position);
            long epochSecond = Math.floorDiv(timestamp.getEpochMicros(), 1000000);
            long microsFraction = Math.floorMod(timestamp.getEpochMicros(), 1000000);
            long nanosFraction = microsFraction * 1000L + (long)(timestamp.getPicosOfMicro() / 1000);
            ((VarcharType)this.toType).writeSlice(blockBuilder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)LOCAL_DATE_TIME.format(LocalDateTime.ofEpochSecond(epochSecond, Math.toIntExact(nanosFraction), ZoneOffset.UTC))), (VarcharType)((VarcharType)this.toType)));
        }
    }

    public static class ShortTimestampToVarcharCoercer
    extends TypeCoercer<TimestampType, VarcharType> {
        public ShortTimestampToVarcharCoercer(TimestampType fromType, VarcharType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            long epochMicros = ((TimestampType)this.fromType).getLong(block, position);
            long epochSecond = Math.floorDiv(epochMicros, 1000000);
            int nanoFraction = Math.floorMod(epochMicros, 1000000) * 1000;
            ((VarcharType)this.toType).writeSlice(blockBuilder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)LOCAL_DATE_TIME.format(LocalDateTime.ofEpochSecond(epochSecond, nanoFraction, ZoneOffset.UTC))), (VarcharType)((VarcharType)this.toType)));
        }
    }
}

