/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import java.io.IOException;
import java.util.Objects;

final class MonitoredInputStream
extends TrinoInputStream {
    private final FileFormatDataSourceStats stats;
    private final TrinoInputStream delegate;

    public MonitoredInputStream(FileFormatDataSourceStats stats, TrinoInputStream delegate) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public long getPosition() throws IOException {
        return this.delegate.getPosition();
    }

    public void seek(long position) throws IOException {
        this.delegate.seek(position);
    }

    public int read() throws IOException {
        long readStart = System.nanoTime();
        int value = this.delegate.read();
        this.stats.readDataBytesPerSecond(1L, System.nanoTime() - readStart);
        return value;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        long readStart = System.nanoTime();
        int size = this.delegate.read(b, off, len);
        this.stats.readDataBytesPerSecond(size, System.nanoTime() - readStart);
        return size;
    }

    public long skip(long n) throws IOException {
        long readStart = System.nanoTime();
        long size = this.delegate.skip(n);
        this.stats.readDataBytesPerSecond(size, System.nanoTime() - readStart);
        return size;
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

