/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.trino.collect.cache.EvictableCacheBuilder;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.TransactionDirectoryListingCacheKey;
import io.trino.plugin.hive.fs.TransactionScopeCachingDirectoryLister;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class TransactionScopeCachingDirectoryListerFactory {
    private final Optional<Cache<TransactionDirectoryListingCacheKey, TransactionScopeCachingDirectoryLister.FetchingValueHolder>> cache;
    private final AtomicLong nextTransactionId = new AtomicLong();

    @Inject
    public TransactionScopeCachingDirectoryListerFactory(HiveConfig hiveConfig) {
        this(Objects.requireNonNull(hiveConfig, "hiveConfig is null").getPerTransactionFileStatusCacheMaxRetainedSize(), Optional.empty());
    }

    @VisibleForTesting
    TransactionScopeCachingDirectoryListerFactory(DataSize maxSize, Optional<Integer> concurrencyLevel) {
        if (maxSize.toBytes() > 0L) {
            EvictableCacheBuilder cacheBuilder = EvictableCacheBuilder.newBuilder().maximumWeight(maxSize.toBytes()).weigher((key, value) -> Math.toIntExact(key.getRetainedSizeInBytes() + value.getRetainedSizeInBytes()));
            concurrencyLevel.ifPresent(arg_0 -> ((EvictableCacheBuilder)cacheBuilder).concurrencyLevel(arg_0));
            this.cache = Optional.of(cacheBuilder.build());
        } else {
            this.cache = Optional.empty();
        }
    }

    public DirectoryLister get(DirectoryLister delegate) {
        return this.cache.map(cache -> new TransactionScopeCachingDirectoryLister(delegate, this.nextTransactionId.getAndIncrement(), (Cache<TransactionDirectoryListingCacheKey, TransactionScopeCachingDirectoryLister.FetchingValueHolder>)cache)).orElse(delegate);
    }
}

