/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.alluxio;

import alluxio.client.table.TableMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.Constraint;
import alluxio.grpc.table.TableInfo;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.alluxio.ProtoUtils;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AlluxioHiveMetastore
implements HiveMetastore {
    private final TableMasterClient client;

    public AlluxioHiveMetastore(TableMasterClient client, HiveMetastoreConfig hiveMetastoreConfig) {
        this.client = Objects.requireNonNull(client, "client is null");
        Preconditions.checkArgument((!hiveMetastoreConfig.isHideDeltaLakeTables() ? 1 : 0) != 0, (Object)"Hiding Delta Lake tables is not supported");
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            return Optional.of(ProtoUtils.fromProto(this.client.getDatabase(databaseName)));
        }
        catch (AlluxioStatusException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.client.getAllDatabases();
        }
        catch (AlluxioStatusException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        try {
            return Optional.of(ProtoUtils.fromProto(this.client.getTable(databaseName, tableName)));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
        catch (AlluxioStatusException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ThriftMetastoreUtil.getSupportedColumnStatistics(type);
    }

    private Map<String, HiveColumnStatistics> groupStatisticsByColumn(List<ColumnStatisticsInfo> statistics, OptionalLong rowCount) {
        return (Map)statistics.stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsInfo::getColName, statisticsObj -> ProtoUtils.fromProto(statisticsObj.getData(), rowCount)));
    }

    @Override
    public PartitionStatistics getTableStatistics(Table table) {
        try {
            HiveBasicStatistics basicStats = ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters());
            ArrayList<Column> columns = new ArrayList<Column>(table.getPartitionColumns());
            columns.addAll(table.getDataColumns());
            List columnNames = columns.stream().map(Column::getName).collect(Collectors.toList());
            List colStatsList = this.client.getTableColumnStatistics(table.getDatabaseName(), table.getTableName(), columnNames);
            return new PartitionStatistics(basicStats, this.groupStatisticsByColumn(colStatsList, basicStats.getRowCount()));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
        try {
            List dataColumns = (List)table.getDataColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
            List partitionColumns = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
            Map partitionBasicStatistics = (Map)partitions.stream().collect(ImmutableMap.toImmutableMap(partition -> HiveUtil.makePartName(partitionColumns, partition.getValues()), partition -> ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters())));
            Map partitionRowCounts = (Map)partitionBasicStatistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((HiveBasicStatistics)entry.getValue()).getRowCount()));
            long tableRowCount = partitionRowCounts.values().stream().mapToLong(count -> count.orElse(0L)).sum();
            if (!partitionRowCounts.isEmpty() && tableRowCount == 0L) {
                partitionBasicStatistics = (Map)partitionBasicStatistics.keySet().stream().map(key -> new AbstractMap.SimpleEntry<String, HiveBasicStatistics>((String)key, HiveBasicStatistics.createEmptyStatistics())).collect(ImmutableMap.toImmutableMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            }
            Map colStatsMap = this.client.getPartitionColumnStatistics(table.getDatabaseName(), table.getTableName(), (List)ImmutableList.copyOf(partitionBasicStatistics.keySet()), dataColumns);
            Map partitionColumnStatistics = (Map)colStatsMap.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.groupStatisticsByColumn((List)entry.getValue(), partitionRowCounts.getOrDefault(entry.getKey(), OptionalLong.empty()))));
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (String partitionName : partitionBasicStatistics.keySet()) {
                HiveBasicStatistics basicStatistics = (HiveBasicStatistics)partitionBasicStatistics.get(partitionName);
                Map columnStatistics = (Map)partitionColumnStatistics.getOrDefault(partitionName, ImmutableMap.of());
                result.put((Object)partitionName, (Object)new PartitionStatistics(basicStatistics, columnStatistics));
            }
            return result.buildOrThrow();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updateTableStatistics");
    }

    @Override
    public void updatePartitionStatistics(Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updatePartitionStatistics");
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        try {
            return this.client.getAllTables(databaseName);
        }
        catch (NotFoundException e) {
            return new ArrayList<String>(0);
        }
        catch (AlluxioStatusException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<SchemaTableName>> getAllTables() {
        return Optional.empty();
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        try {
            return this.client.getAllTables(databaseName).stream().filter(tableName -> {
                try {
                    TableInfo table = this.client.getTable(databaseName, tableName);
                    if (table == null) {
                        return false;
                    }
                    String value = (String)table.getParametersMap().get(parameterKey);
                    return value != null && value.equals(parameterValue);
                }
                catch (AlluxioStatusException e) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed to get info for table: " + tableName, (Throwable)e);
                }
            }).collect(Collectors.toList());
        }
        catch (AlluxioStatusException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        return Collections.emptyList();
    }

    @Override
    public Optional<List<SchemaTableName>> getAllViews() {
        return Optional.empty();
    }

    @Override
    public void createDatabase(Database database) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createDatabase");
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropDatabase");
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameDatabase");
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setDatabaseOwner");
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createTable");
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropTable");
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "replaceTable");
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameTable");
    }

    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "commentTable");
    }

    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTableOwner");
    }

    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "commentColumn");
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "addColumn");
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameColumn");
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropColumn");
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "getPartition");
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        try {
            List<PartitionInfo> partitionInfos = ProtoUtils.toPartitionInfoList(this.client.readTable(databaseName, tableName, Constraint.getDefaultInstance()));
            List partitionNames = partitionInfos.stream().map(PartitionInfo::getPartitionName).collect(Collectors.toList());
            return Optional.of(partitionNames);
        }
        catch (AlluxioStatusException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        if (partitionNames.isEmpty()) {
            return Collections.emptyMap();
        }
        String databaseName = table.getDatabaseName();
        String tableName = table.getTableName();
        try {
            List<Object> partitionInfos = ProtoUtils.toPartitionInfoList(this.client.readTable(databaseName, tableName, Constraint.getDefaultInstance()));
            partitionInfos = partitionInfos.stream().filter(partition -> partition.getTableName().equals(tableName)).collect(Collectors.toList());
            Map<String, Optional> result = partitionInfos.stream().filter(partitionName -> partitionNames.stream().anyMatch(partitionName.getPartitionName()::equals)).collect(Collectors.toMap(PartitionInfo::getPartitionName, partitionInfo -> Optional.of(ProtoUtils.fromProto(partitionInfo))));
            return Collections.unmodifiableMap(result);
        }
        catch (AlluxioStatusException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "addPartitions");
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropPartition");
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "alterPartition");
    }

    @Override
    public void createRole(String role, String grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createRole");
    }

    @Override
    public void dropRole(String role) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropRole");
    }

    @Override
    public Set<String> listRoles() {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "listRoles");
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean withAdminOption, HivePrincipal grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantRoles");
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOptionFor, HivePrincipal grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeRoles");
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "listRoleGrants");
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "listRoleGrants");
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantTablePrivileges");
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeTablePrivileges");
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "listTablePrivileges");
    }
}

