/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.model.Table;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import java.util.Map;
import java.util.function.Predicate;

public class DefaultGlueMetastoreTableFilterProvider
implements Provider<Predicate<Table>> {
    private final boolean hideDeltaLakeTables;

    @Inject
    public DefaultGlueMetastoreTableFilterProvider(@HideDeltaLakeTables boolean hideDeltaLakeTables) {
        this.hideDeltaLakeTables = hideDeltaLakeTables;
    }

    public Predicate<Table> get() {
        if (this.hideDeltaLakeTables) {
            return Predicate.not(DefaultGlueMetastoreTableFilterProvider::isDeltaLakeTable);
        }
        return table -> true;
    }

    public static boolean isDeltaLakeTable(Table table) {
        Map<String, String> parameters = GlueToTrinoConverter.getTableParameters(table);
        return parameters.getOrDefault("spark.sql.sources.provider", "").equalsIgnoreCase("delta");
    }
}

