/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@DefunctConfig(value={"hive.metastore.glue.use-instance-credentials"})
public class GlueHiveMetastoreConfig {
    private Optional<String> glueRegion = Optional.empty();
    private Optional<String> glueEndpointUrl = Optional.empty();
    private Optional<String> glueStsRegion = Optional.empty();
    private Optional<String> glueStsEndpointUrl = Optional.empty();
    private Optional<String> glueProxyApiId = Optional.empty();
    private boolean pinGlueClientToCurrentRegion;
    private int maxGlueErrorRetries = 10;
    private int maxGlueConnections = 30;
    private Optional<String> defaultWarehouseDir = Optional.empty();
    private Optional<String> iamRole = Optional.empty();
    private Optional<String> externalId = Optional.empty();
    private Optional<String> awsAccessKey = Optional.empty();
    private Optional<String> awsSecretKey = Optional.empty();
    private Optional<String> awsCredentialsProvider = Optional.empty();
    private Optional<String> catalogId = Optional.empty();
    private int partitionSegments = 5;
    private int getPartitionThreads = 20;
    private int readStatisticsThreads = 5;
    private int writeStatisticsThreads = 20;
    private boolean assumeCanonicalPartitionKeys;

    public Optional<String> getGlueRegion() {
        return this.glueRegion;
    }

    @Config(value="hive.metastore.glue.region")
    @ConfigDescription(value="AWS Region for Glue Data Catalog")
    public GlueHiveMetastoreConfig setGlueRegion(String region) {
        this.glueRegion = Optional.ofNullable(region);
        return this;
    }

    public Optional<String> getGlueEndpointUrl() {
        return this.glueEndpointUrl;
    }

    @Config(value="hive.metastore.glue.endpoint-url")
    @ConfigDescription(value="Glue API endpoint URL")
    public GlueHiveMetastoreConfig setGlueEndpointUrl(String glueEndpointUrl) {
        this.glueEndpointUrl = Optional.ofNullable(glueEndpointUrl);
        return this;
    }

    public Optional<String> getGlueStsRegion() {
        return this.glueStsRegion;
    }

    @Config(value="hive.metastore.glue.sts.region")
    @ConfigDescription(value="AWS STS signing region for Glue authentication")
    public GlueHiveMetastoreConfig setGlueStsRegion(String glueStsRegion) {
        this.glueStsRegion = Optional.ofNullable(glueStsRegion);
        return this;
    }

    public Optional<String> getGlueStsEndpointUrl() {
        return this.glueStsEndpointUrl;
    }

    @Config(value="hive.metastore.glue.sts.endpoint")
    @ConfigDescription(value="AWS STS endpoint for Glue authentication")
    public GlueHiveMetastoreConfig setGlueStsEndpointUrl(String glueStsEndpointUrl) {
        this.glueStsEndpointUrl = Optional.ofNullable(glueStsEndpointUrl);
        return this;
    }

    public Optional<String> getGlueProxyApiId() {
        return this.glueProxyApiId;
    }

    @Config(value="hive.metastore.glue.proxy-api-id")
    @ConfigDescription(value="ID of Glue Proxy API")
    public GlueHiveMetastoreConfig setGlueProxyApiId(String glueProxyApiId) {
        this.glueProxyApiId = Optional.ofNullable(glueProxyApiId);
        return this;
    }

    public boolean getPinGlueClientToCurrentRegion() {
        return this.pinGlueClientToCurrentRegion;
    }

    @Config(value="hive.metastore.glue.pin-client-to-current-region")
    @ConfigDescription(value="Should the Glue client be pinned to the current EC2 region")
    public GlueHiveMetastoreConfig setPinGlueClientToCurrentRegion(boolean pinGlueClientToCurrentRegion) {
        this.pinGlueClientToCurrentRegion = pinGlueClientToCurrentRegion;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxGlueConnections() {
        return this.maxGlueConnections;
    }

    @Config(value="hive.metastore.glue.max-connections")
    @ConfigDescription(value="Max number of concurrent connections to Glue")
    public GlueHiveMetastoreConfig setMaxGlueConnections(int maxGlueConnections) {
        this.maxGlueConnections = maxGlueConnections;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxGlueErrorRetries() {
        return this.maxGlueErrorRetries;
    }

    @Config(value="hive.metastore.glue.max-error-retries")
    @ConfigDescription(value="Maximum number of error retries for the Glue client")
    public GlueHiveMetastoreConfig setMaxGlueErrorRetries(int maxGlueErrorRetries) {
        this.maxGlueErrorRetries = maxGlueErrorRetries;
        return this;
    }

    public Optional<String> getDefaultWarehouseDir() {
        return this.defaultWarehouseDir;
    }

    @Config(value="hive.metastore.glue.default-warehouse-dir")
    @ConfigDescription(value="Hive Glue metastore default warehouse directory")
    public GlueHiveMetastoreConfig setDefaultWarehouseDir(String defaultWarehouseDir) {
        this.defaultWarehouseDir = Optional.ofNullable(defaultWarehouseDir);
        return this;
    }

    public Optional<String> getIamRole() {
        return this.iamRole;
    }

    @Config(value="hive.metastore.glue.iam-role")
    @ConfigDescription(value="ARN of an IAM role to assume when connecting to Glue")
    public GlueHiveMetastoreConfig setIamRole(String iamRole) {
        this.iamRole = Optional.ofNullable(iamRole);
        return this;
    }

    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @Config(value="hive.metastore.glue.external-id")
    @ConfigDescription(value="External ID for the IAM role trust policy when connecting to Glue")
    public GlueHiveMetastoreConfig setExternalId(String externalId) {
        this.externalId = Optional.ofNullable(externalId);
        return this;
    }

    public Optional<String> getAwsAccessKey() {
        return this.awsAccessKey;
    }

    @Config(value="hive.metastore.glue.aws-access-key")
    @ConfigDescription(value="Hive Glue metastore AWS access key")
    public GlueHiveMetastoreConfig setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = Optional.ofNullable(awsAccessKey);
        return this;
    }

    public Optional<String> getAwsSecretKey() {
        return this.awsSecretKey;
    }

    @Config(value="hive.metastore.glue.aws-secret-key")
    @ConfigDescription(value="Hive Glue metastore AWS secret key")
    @ConfigSecuritySensitive
    public GlueHiveMetastoreConfig setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = Optional.ofNullable(awsSecretKey);
        return this;
    }

    public Optional<String> getCatalogId() {
        return this.catalogId;
    }

    @Config(value="hive.metastore.glue.catalogid")
    @ConfigDescription(value="Hive Glue metastore catalog id")
    public GlueHiveMetastoreConfig setCatalogId(String catalogId) {
        this.catalogId = Optional.ofNullable(catalogId);
        return this;
    }

    public Optional<String> getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    @Config(value="hive.metastore.glue.aws-credentials-provider")
    @ConfigDescription(value="Fully qualified name of the Java class to use for obtaining AWS credentials")
    public GlueHiveMetastoreConfig setAwsCredentialsProvider(String awsCredentialsProvider) {
        this.awsCredentialsProvider = Optional.ofNullable(awsCredentialsProvider);
        return this;
    }

    @Min(value=1L)
    @Max(value=10L)
    public @Min(value=1L) @Max(value=10L) int getPartitionSegments() {
        return this.partitionSegments;
    }

    @Config(value="hive.metastore.glue.partitions-segments")
    @ConfigDescription(value="Number of segments for partitioned Glue tables")
    public GlueHiveMetastoreConfig setPartitionSegments(int partitionSegments) {
        this.partitionSegments = partitionSegments;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getGetPartitionThreads() {
        return this.getPartitionThreads;
    }

    @Config(value="hive.metastore.glue.get-partition-threads")
    @ConfigDescription(value="Number of threads for parallel partition fetches from Glue")
    public GlueHiveMetastoreConfig setGetPartitionThreads(int getPartitionThreads) {
        this.getPartitionThreads = getPartitionThreads;
        return this;
    }

    public boolean isAssumeCanonicalPartitionKeys() {
        return this.assumeCanonicalPartitionKeys;
    }

    @Config(value="hive.metastore.glue.assume-canonical-partition-keys")
    @ConfigDescription(value="Allow conversion of non-char types (eg BIGINT, timestamp) to canonical string formats")
    public GlueHiveMetastoreConfig setAssumeCanonicalPartitionKeys(boolean assumeCanonicalPartitionKeys) {
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getReadStatisticsThreads() {
        return this.readStatisticsThreads;
    }

    @Config(value="hive.metastore.glue.read-statistics-threads")
    @ConfigDescription(value="Number of threads for parallel statistics reads from Glue")
    public GlueHiveMetastoreConfig setReadStatisticsThreads(int getReadStatisticsThreads) {
        this.readStatisticsThreads = getReadStatisticsThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getWriteStatisticsThreads() {
        return this.writeStatisticsThreads;
    }

    @Config(value="hive.metastore.glue.write-statistics-threads")
    @ConfigDescription(value="Number of threads for parallel statistics writes to Glue")
    public GlueHiveMetastoreConfig setWriteStatisticsThreads(int writeStatisticsThreads) {
        this.writeStatisticsThreads = writeStatisticsThreads;
        return this;
    }

    @PostConstruct
    public void validate() {
        if (this.getGlueProxyApiId().isPresent()) {
            Preconditions.checkState((this.getGlueRegion().isPresent() && this.getGlueEndpointUrl().isPresent() ? 1 : 0) != 0, (Object)"Both Glue region and Glue endpoint URL must be provided when Glue proxy API ID is present");
        }
    }
}

