/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.recording;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.trino.collect.cache.NonEvictableCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.RecordingMetastoreConfig;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HivePartitionName;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.HiveTableName;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionFilter;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.TablesWithParameterCacheKey;
import io.trino.plugin.hive.metastore.UserTableKey;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.RoleGrant;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.concurrent.Immutable;
import org.weakref.jmx.Managed;

public class HiveMetastoreRecording {
    private final JsonCodec<Recording> recordingCodec;
    private final Path recordingPath;
    private final boolean replay;
    private volatile Optional<List<String>> allDatabases = Optional.empty();
    private volatile Optional<Set<String>> allRoles = Optional.empty();
    private final NonEvictableCache<String, Optional<Database>> databaseCache;
    private final NonEvictableCache<HiveTableName, Optional<Table>> tableCache;
    private final NonEvictableCache<HiveTableName, PartitionStatistics> tableStatisticsCache;
    private final NonEvictableCache<HivePartitionName, PartitionStatistics> partitionStatisticsCache;
    private final NonEvictableCache<String, List<String>> tableNamesCache;
    private final NonEvictableCache<SingletonCacheKey, Optional<List<SchemaTableName>>> allTableNamesCache;
    private final NonEvictableCache<TablesWithParameterCacheKey, List<String>> tablesWithParameterCache;
    private final NonEvictableCache<String, List<String>> viewNamesCache;
    private final NonEvictableCache<SingletonCacheKey, Optional<List<SchemaTableName>>> allViewNamesCache;
    private final NonEvictableCache<HivePartitionName, Optional<Partition>> partitionCache;
    private final NonEvictableCache<HiveTableName, Optional<List<String>>> partitionNamesCache;
    private final NonEvictableCache<PartitionFilter, Optional<List<String>>> partitionNamesByPartsCache;
    private final NonEvictableCache<HivePartitionName, Optional<Partition>> partitionsByNamesCache;
    private final NonEvictableCache<UserTableKey, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final NonEvictableCache<HivePrincipal, Set<RoleGrant>> roleGrantsCache;
    private final NonEvictableCache<String, Set<RoleGrant>> grantedPrincipalsCache;

    @Inject
    public HiveMetastoreRecording(RecordingMetastoreConfig config, JsonCodec<Recording> recordingCodec) throws IOException {
        this.recordingCodec = recordingCodec;
        this.recordingPath = Paths.get(Objects.requireNonNull(config.getRecordingPath(), "recordingPath is null"), new String[0]);
        this.replay = config.isReplay();
        Duration recordingDuration = config.getRecordingDuration();
        this.databaseCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.tableCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.tableStatisticsCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.partitionStatisticsCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.tableNamesCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.allTableNamesCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.tablesWithParameterCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.viewNamesCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.allViewNamesCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.partitionCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.partitionNamesCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.partitionNamesByPartsCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.partitionsByNamesCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.tablePrivilegesCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.roleGrantsCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        this.grantedPrincipalsCache = HiveMetastoreRecording.createCache(this.replay, recordingDuration);
        if (this.replay) {
            this.loadRecording();
        }
    }

    @VisibleForTesting
    void loadRecording() throws IOException {
        Recording recording;
        try (GZIPInputStream inputStream = new GZIPInputStream(Files.newInputStream(this.recordingPath, new OpenOption[0]));){
            recording = (Recording)this.recordingCodec.fromJson(inputStream.readAllBytes());
        }
        this.allDatabases = recording.getAllDatabases();
        this.allRoles = recording.getAllRoles();
        this.databaseCache.putAll(HiveMetastoreRecording.toMap(recording.getDatabases()));
        this.tableCache.putAll(HiveMetastoreRecording.toMap(recording.getTables()));
        this.tableStatisticsCache.putAll(HiveMetastoreRecording.toMap(recording.getTableStatistics()));
        this.partitionStatisticsCache.putAll(HiveMetastoreRecording.toMap(recording.getPartitionStatistics()));
        this.tableNamesCache.putAll(HiveMetastoreRecording.toMap(recording.getAllTables()));
        this.tablesWithParameterCache.putAll(HiveMetastoreRecording.toMap(recording.getTablesWithParameter()));
        this.viewNamesCache.putAll(HiveMetastoreRecording.toMap(recording.getAllViews()));
        this.partitionCache.putAll(HiveMetastoreRecording.toMap(recording.getPartitions()));
        this.partitionNamesCache.putAll(HiveMetastoreRecording.toMap(recording.getPartitionNames()));
        this.partitionNamesByPartsCache.putAll(HiveMetastoreRecording.toMap(recording.getPartitionNamesByParts()));
        this.partitionsByNamesCache.putAll(HiveMetastoreRecording.toMap(recording.getPartitionsByNames()));
        this.tablePrivilegesCache.putAll(HiveMetastoreRecording.toMap(recording.getTablePrivileges()));
        this.roleGrantsCache.putAll(HiveMetastoreRecording.toMap(recording.getRoleGrants()));
        this.grantedPrincipalsCache.putAll(HiveMetastoreRecording.toMap(recording.getGrantedPrincipals()));
    }

    public boolean isReplay() {
        return this.replay;
    }

    public Optional<Database> getDatabase(String databaseName, Supplier<Optional<Database>> valueSupplier) {
        return this.loadValue((Cache)this.databaseCache, (Object)databaseName, (Supplier)valueSupplier);
    }

    public List<String> getAllDatabases(Supplier<List<String>> valueSupplier) {
        if (this.replay) {
            return this.allDatabases.orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry for all databases"));
        }
        List<String> result = valueSupplier.get();
        this.allDatabases = Optional.of(result);
        return result;
    }

    public Optional<Table> getTable(HiveTableName hiveTableName, Supplier<Optional<Table>> valueSupplier) {
        return this.loadValue((Cache)this.tableCache, (Object)hiveTableName, (Supplier)valueSupplier);
    }

    public PartitionStatistics getTableStatistics(HiveTableName hiveTableName, Supplier<PartitionStatistics> valueSupplier) {
        return this.loadValue((Cache)this.tableStatisticsCache, (Object)hiveTableName, (Supplier)valueSupplier);
    }

    public Map<String, PartitionStatistics> getPartitionStatistics(Set<HivePartitionName> partitionNames, Supplier<Map<String, PartitionStatistics>> valueSupplier) {
        return this.loadPartitionValues(partitionNames, (Cache)this.partitionStatisticsCache, valueSupplier);
    }

    public List<String> getAllTables(String databaseName, Supplier<List<String>> valueSupplier) {
        return this.loadValue((Cache)this.tableNamesCache, (Object)databaseName, (Supplier)valueSupplier);
    }

    public List<String> getTablesWithParameter(TablesWithParameterCacheKey tablesWithParameterCacheKey, Supplier<List<String>> valueSupplier) {
        return this.loadValue((Cache)this.tablesWithParameterCache, (Object)tablesWithParameterCacheKey, (Supplier)valueSupplier);
    }

    public List<String> getAllViews(String databaseName, Supplier<List<String>> valueSupplier) {
        return this.loadValue((Cache)this.viewNamesCache, (Object)databaseName, (Supplier)valueSupplier);
    }

    public Optional<List<SchemaTableName>> getAllTables(Supplier<Optional<List<SchemaTableName>>> valueSupplier) {
        return this.loadValue((Cache)this.allTableNamesCache, (Object)((Object)SingletonCacheKey.INSTANCE), (Supplier)valueSupplier);
    }

    public Optional<List<SchemaTableName>> getAllViews(Supplier<Optional<List<SchemaTableName>>> valueSupplier) {
        return this.loadValue((Cache)this.allViewNamesCache, (Object)((Object)SingletonCacheKey.INSTANCE), (Supplier)valueSupplier);
    }

    public Optional<Partition> getPartition(HivePartitionName hivePartitionName, Supplier<Optional<Partition>> valueSupplier) {
        return this.loadValue((Cache)this.partitionCache, (Object)hivePartitionName, (Supplier)valueSupplier);
    }

    public Optional<List<String>> getPartitionNamesByFilter(PartitionFilter partitionFilter, Supplier<Optional<List<String>>> valueSupplier) {
        return this.loadValue((Cache)this.partitionNamesByPartsCache, (Object)partitionFilter, (Supplier)valueSupplier);
    }

    public Map<String, Optional<Partition>> getPartitionsByNames(Set<HivePartitionName> partitionNames, Supplier<Map<String, Optional<Partition>>> valueSupplier) {
        return this.loadPartitionValues(partitionNames, (Cache)this.partitionsByNamesCache, valueSupplier);
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(UserTableKey userTableKey, Supplier<Set<HivePrivilegeInfo>> valueSupplier) {
        return this.loadValue((Cache)this.tablePrivilegesCache, (Object)userTableKey, (Supplier)valueSupplier);
    }

    public Set<String> listRoles(Supplier<Set<String>> valueSupplier) {
        if (this.replay) {
            return this.allRoles.orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry for roles"));
        }
        Set<String> result = valueSupplier.get();
        this.allRoles = Optional.of(result);
        return result;
    }

    public Set<RoleGrant> listGrantedPrincipals(String role, Supplier<Set<RoleGrant>> valueSupplier) {
        return this.loadValue((Cache)this.grantedPrincipalsCache, (Object)role, (Supplier)valueSupplier);
    }

    public Set<RoleGrant> listRoleGrants(HivePrincipal principal, Supplier<Set<RoleGrant>> valueSupplier) {
        return this.loadValue((Cache)this.roleGrantsCache, (Object)principal, (Supplier)valueSupplier);
    }

    private static <K, V> NonEvictableCache<K, V> createCache(boolean reply, Duration recordingDuration) {
        if (reply) {
            return SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder());
        }
        return SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(recordingDuration.toMillis(), TimeUnit.MILLISECONDS));
    }

    @Managed
    public void writeRecording() throws IOException {
        if (this.replay) {
            throw new IllegalStateException("Cannot write recording in replay mode");
        }
        Recording recording = new Recording(this.allDatabases, this.allRoles, HiveMetastoreRecording.toPairs(this.databaseCache), HiveMetastoreRecording.toPairs(this.tableCache), HiveMetastoreRecording.toPairs(this.tableStatisticsCache), HiveMetastoreRecording.toPairs(this.partitionStatisticsCache), HiveMetastoreRecording.toPairs(this.tableNamesCache), HiveMetastoreRecording.toPairs(this.tablesWithParameterCache), HiveMetastoreRecording.toPairs(this.viewNamesCache), HiveMetastoreRecording.toPairs(this.partitionCache), HiveMetastoreRecording.toPairs(this.partitionNamesCache), HiveMetastoreRecording.toPairs(this.partitionNamesByPartsCache), HiveMetastoreRecording.toPairs(this.partitionsByNamesCache), HiveMetastoreRecording.toPairs(this.tablePrivilegesCache), HiveMetastoreRecording.toPairs(this.roleGrantsCache), HiveMetastoreRecording.toPairs(this.grantedPrincipalsCache));
        try (GZIPOutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(this.recordingPath, new OpenOption[0]));){
            outputStream.write(this.recordingCodec.toJsonBytes((Object)recording));
        }
    }

    private static <K, V> Map<K, V> toMap(List<Pair<K, V>> pairs) {
        return (Map)pairs.stream().collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    private static <K, V> List<Pair<K, V>> toPairs(Cache<K, V> cache) {
        return (List)cache.asMap().entrySet().stream().map(entry -> new Pair(entry.getKey(), entry.getValue())).collect(ImmutableList.toImmutableList());
    }

    private <T> Map<String, T> loadPartitionValues(Set<HivePartitionName> partitionNames, Cache<HivePartitionName, T> cache, Supplier<Map<String, T>> valueSupplier) {
        if (this.replay) {
            return (Map)partitionNames.stream().collect(ImmutableMap.toImmutableMap(partitionName -> partitionName.getPartitionName().orElseThrow(), partitionName -> Optional.ofNullable(cache.getIfPresent(partitionName)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry found for key: " + partitionName))));
        }
        Map value = valueSupplier.get();
        partitionNames.forEach(partitionName -> cache.put(partitionName, value.get(partitionName.getPartitionName().orElseThrow())));
        return value;
    }

    private <K, V> V loadValue(Cache<K, V> cache, K key, Supplier<V> valueSupplier) {
        if (this.replay) {
            return (V)Optional.ofNullable(cache.getIfPresent(key)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry found for key: " + key));
        }
        V value = valueSupplier.get();
        cache.put(key, value);
        return value;
    }

    @Immutable
    public static class Recording {
        private final Optional<List<String>> allDatabases;
        private final Optional<Set<String>> allRoles;
        private final List<Pair<String, Optional<Database>>> databases;
        private final List<Pair<HiveTableName, Optional<Table>>> tables;
        private final List<Pair<HiveTableName, PartitionStatistics>> tableStatistics;
        private final List<Pair<HivePartitionName, PartitionStatistics>> partitionStatistics;
        private final List<Pair<String, List<String>>> allTables;
        private final List<Pair<TablesWithParameterCacheKey, List<String>>> tablesWithParameter;
        private final List<Pair<String, List<String>>> allViews;
        private final List<Pair<HivePartitionName, Optional<Partition>>> partitions;
        private final List<Pair<HiveTableName, Optional<List<String>>>> partitionNames;
        private final List<Pair<PartitionFilter, Optional<List<String>>>> partitionNamesByParts;
        private final List<Pair<HivePartitionName, Optional<Partition>>> partitionsByNames;
        private final List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> tablePrivileges;
        private final List<Pair<HivePrincipal, Set<RoleGrant>>> roleGrants;
        private final List<Pair<String, Set<RoleGrant>>> grantedPrincipals;

        @JsonCreator
        public Recording(@JsonProperty(value="allDatabases") Optional<List<String>> allDatabases, @JsonProperty(value="allRoles") Optional<Set<String>> allRoles, @JsonProperty(value="databases") List<Pair<String, Optional<Database>>> databases, @JsonProperty(value="tables") List<Pair<HiveTableName, Optional<Table>>> tables, @JsonProperty(value="tableStatistics") List<Pair<HiveTableName, PartitionStatistics>> tableStatistics, @JsonProperty(value="partitionStatistics") List<Pair<HivePartitionName, PartitionStatistics>> partitionStatistics, @JsonProperty(value="allTables") List<Pair<String, List<String>>> allTables, @JsonProperty(value="tablesWithParameter") List<Pair<TablesWithParameterCacheKey, List<String>>> tablesWithParameter, @JsonProperty(value="allViews") List<Pair<String, List<String>>> allViews, @JsonProperty(value="partitions") List<Pair<HivePartitionName, Optional<Partition>>> partitions, @JsonProperty(value="partitionNames") List<Pair<HiveTableName, Optional<List<String>>>> partitionNames, @JsonProperty(value="partitionNamesByParts") List<Pair<PartitionFilter, Optional<List<String>>>> partitionNamesByParts, @JsonProperty(value="partitionsByNames") List<Pair<HivePartitionName, Optional<Partition>>> partitionsByNames, @JsonProperty(value="tablePrivileges") List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> tablePrivileges, @JsonProperty(value="roleGrants") List<Pair<HivePrincipal, Set<RoleGrant>>> roleGrants, @JsonProperty(value="grantedPrincipals") List<Pair<String, Set<RoleGrant>>> grantedPrincipals) {
            this.allDatabases = allDatabases;
            this.allRoles = allRoles;
            this.databases = databases;
            this.tables = tables;
            this.tableStatistics = tableStatistics;
            this.partitionStatistics = partitionStatistics;
            this.allTables = allTables;
            this.tablesWithParameter = tablesWithParameter;
            this.allViews = allViews;
            this.partitions = partitions;
            this.partitionNames = partitionNames;
            this.partitionNamesByParts = partitionNamesByParts;
            this.partitionsByNames = partitionsByNames;
            this.tablePrivileges = tablePrivileges;
            this.roleGrants = roleGrants;
            this.grantedPrincipals = grantedPrincipals;
        }

        @JsonProperty
        public Optional<List<String>> getAllDatabases() {
            return this.allDatabases;
        }

        @JsonProperty
        public Optional<Set<String>> getAllRoles() {
            return this.allRoles;
        }

        @JsonProperty
        public List<Pair<String, Optional<Database>>> getDatabases() {
            return this.databases;
        }

        @JsonProperty
        public List<Pair<HiveTableName, Optional<Table>>> getTables() {
            return this.tables;
        }

        @JsonProperty
        public List<Pair<TablesWithParameterCacheKey, List<String>>> getTablesWithParameter() {
            return this.tablesWithParameter;
        }

        @JsonProperty
        public List<Pair<HiveTableName, PartitionStatistics>> getTableStatistics() {
            return this.tableStatistics;
        }

        @JsonProperty
        public List<Pair<HivePartitionName, PartitionStatistics>> getPartitionStatistics() {
            return this.partitionStatistics;
        }

        @JsonProperty
        public List<Pair<String, List<String>>> getAllTables() {
            return this.allTables;
        }

        @JsonProperty
        public List<Pair<String, List<String>>> getAllViews() {
            return this.allViews;
        }

        @JsonProperty
        public List<Pair<HivePartitionName, Optional<Partition>>> getPartitions() {
            return this.partitions;
        }

        @JsonProperty
        public List<Pair<HiveTableName, Optional<List<String>>>> getPartitionNames() {
            return this.partitionNames;
        }

        @JsonProperty
        public List<Pair<PartitionFilter, Optional<List<String>>>> getPartitionNamesByParts() {
            return this.partitionNamesByParts;
        }

        @JsonProperty
        public List<Pair<HivePartitionName, Optional<Partition>>> getPartitionsByNames() {
            return this.partitionsByNames;
        }

        @JsonProperty
        public List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> getTablePrivileges() {
            return this.tablePrivileges;
        }

        @JsonProperty
        public List<Pair<String, Set<RoleGrant>>> getGrantedPrincipals() {
            return this.grantedPrincipals;
        }

        @JsonProperty
        public List<Pair<HivePrincipal, Set<RoleGrant>>> getRoleGrants() {
            return this.roleGrants;
        }
    }

    private static enum SingletonCacheKey {
        INSTANCE;

    }

    @Immutable
    public static class Pair<K, V> {
        private final K key;
        private final V value;

        @JsonCreator
        public Pair(@JsonProperty(value="key") K key, @JsonProperty(value="value") V value) {
            this.key = Objects.requireNonNull(key, "key is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        @JsonProperty
        public K getKey() {
            return this.key;
        }

        @JsonProperty
        public V getValue() {
            return this.value;
        }
    }
}

