/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.net.HostAndPort;
import io.trino.plugin.hive.metastore.thrift.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.TFilterTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public final class Transport {
    public static TTransport create(HostAndPort address, Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, int timeoutMillis, HiveMetastoreAuthentication authentication, Optional<String> delegationToken) throws TTransportException {
        Objects.requireNonNull(address, "address is null");
        try {
            TTransport rawTransport = Transport.createRaw(address, sslContext, socksProxy, timeoutMillis);
            TTransport authenticatedTransport = authentication.authenticate(rawTransport, address.getHost(), delegationToken);
            if (!authenticatedTransport.isOpen()) {
                authenticatedTransport.open();
            }
            return new TTransportWrapper(authenticatedTransport, address);
        }
        catch (TTransportException e) {
            throw Transport.rewriteException(e, address);
        }
    }

    private Transport() {
    }

    private static TTransport createRaw(HostAndPort address, Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, int timeoutMillis) throws TTransportException {
        Proxy proxy = socksProxy.map(socksAddress -> new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved(socksAddress.getHost(), socksAddress.getPort()))).orElse(Proxy.NO_PROXY);
        Socket socket = new Socket(proxy);
        try {
            socket.connect(new InetSocketAddress(address.getHost(), address.getPort()), timeoutMillis);
            socket.setSoTimeout(timeoutMillis);
            if (sslContext.isPresent()) {
                HostAndPort sslConnectAddress = socksProxy.orElse(address);
                socket = sslContext.get().getSocketFactory().createSocket(socket, sslConnectAddress.getHost(), sslConnectAddress.getPort(), true);
            }
            return new TSocket(socket);
        }
        catch (Throwable t) {
            try {
                socket.close();
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            throw new TTransportException(t);
        }
    }

    private static TTransportException rewriteException(TTransportException e, HostAndPort address) {
        String message = e.getMessage() != null ? String.format("%s: %s", address, e.getMessage()) : address.toString();
        return new TTransportException(e.getType(), message, (Throwable)e);
    }

    private static class TTransportWrapper
    extends TFilterTransport {
        private final HostAndPort address;

        public TTransportWrapper(TTransport transport, HostAndPort address) {
            super(transport);
            this.address = Objects.requireNonNull(address, "address is null");
        }

        @Override
        public void open() throws TTransportException {
            try {
                this.transport.open();
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        @Override
        public int readAll(byte[] bytes, int off, int len) throws TTransportException {
            try {
                return this.transport.readAll(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws TTransportException {
            try {
                return this.transport.read(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        @Override
        public void write(byte[] bytes) throws TTransportException {
            try {
                this.transport.write(bytes);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws TTransportException {
            try {
                this.transport.write(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        @Override
        public void flush() throws TTransportException {
            try {
                this.transport.flush();
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }
    }
}

