/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.NameBasedFieldMapper;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.TupleDomainOrcPredicate;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.trino.plugin.hive.orc.OrcDeletedRows;
import io.trino.plugin.hive.orc.OrcPageSource;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcTypeTranslator;
import io.trino.plugin.hive.orc.OriginalFilesUtils;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.joda.time.DateTimeZone;

public class OrcPageSourceFactory
implements HivePageSourceFactory {
    private static final Pattern DEFAULT_HIVE_COLUMN_NAME_PATTERN = Pattern.compile("_col\\d+");
    private final OrcReaderOptions orcReaderOptions;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats stats;
    private final DateTimeZone legacyTimeZone;
    private final int domainCompactionThreshold;

    @Inject
    public OrcPageSourceFactory(OrcReaderConfig config, TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, HiveConfig hiveConfig) {
        this(config.toOrcReaderOptions(), fileSystemFactory, stats, hiveConfig.getOrcLegacyDateTimeZone(), hiveConfig.getDomainCompactionThreshold());
    }

    public OrcPageSourceFactory(OrcReaderOptions orcReaderOptions, TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, DateTimeZone legacyTimeZone) {
        this(orcReaderOptions, fileSystemFactory, stats, legacyTimeZone, 0);
    }

    public OrcPageSourceFactory(OrcReaderOptions orcReaderOptions, TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, DateTimeZone legacyTimeZone, int domainCompactionThreshold) {
        this.orcReaderOptions = Objects.requireNonNull(orcReaderOptions, "orcReaderOptions is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.legacyTimeZone = legacyTimeZone;
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    public static Properties stripUnnecessaryProperties(Properties schema) {
        if ("org.apache.hadoop.hive.ql.io.orc.OrcSerde".equals(HiveUtil.getDeserializerClassName(schema)) && !AcidTables.isFullAcidTable((Map<String, String>)Maps.fromProperties((Properties)schema))) {
            Properties stripped = new Properties();
            stripped.put("serialization.lib", schema.getProperty("serialization.lib"));
            return stripped;
        }
        return schema;
    }

    @Override
    public Optional<ReaderPageSource> createPageSource(Configuration configuration, ConnectorSession session, Location path, long start, long length, long estimatedFileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        if (!"org.apache.hadoop.hive.ql.io.orc.OrcSerde".equals(HiveUtil.getDeserializerClassName(schema))) {
            return Optional.empty();
        }
        List<HiveColumnHandle> readerColumnHandles = columns;
        Optional<ReaderColumns> readerColumns = HivePageSourceProvider.projectBaseColumns(columns);
        if (readerColumns.isPresent()) {
            readerColumnHandles = readerColumns.get().get().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList());
        }
        ConnectorPageSource orcPageSource = this.createOrcPageSource(session, path, start, length, estimatedFileSize, readerColumnHandles, columns, HiveSessionProperties.isUseOrcColumnNames(session), AcidTables.isFullAcidTable((Map<String, String>)Maps.fromProperties((Properties)schema)), effectivePredicate, this.legacyTimeZone, this.orcReaderOptions.withMaxMergeDistance(HiveSessionProperties.getOrcMaxMergeDistance(session)).withMaxBufferSize(HiveSessionProperties.getOrcMaxBufferSize(session)).withStreamBufferSize(HiveSessionProperties.getOrcStreamBufferSize(session)).withTinyStripeThreshold(HiveSessionProperties.getOrcTinyStripeThreshold(session)).withMaxReadBlockSize(HiveSessionProperties.getOrcMaxReadBlockSize(session)).withLazyReadSmallRanges(HiveSessionProperties.getOrcLazyReadSmallRanges(session)).withNestedLazy(HiveSessionProperties.isOrcNestedLazy(session)).withBloomFiltersEnabled(HiveSessionProperties.isOrcBloomFiltersEnabled(session)), acidInfo, bucketNumber, originalFile, transaction, this.stats);
        return Optional.of(new ReaderPageSource(orcPageSource, readerColumns));
    }

    private ConnectorPageSource createOrcPageSource(ConnectorSession session, Location path, long start, long length, long estimatedFileSize, List<HiveColumnHandle> columns, List<HiveColumnHandle> projections, boolean useOrcColumnNames, boolean isFullAcid, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone legacyFileTimeZone, OrcReaderOptions options, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction, FileFormatDataSourceStats stats) {
        HdfsOrcDataSource orcDataSource;
        for (HiveColumnHandle column : columns) {
            Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (String)"column type must be regular: %s", (Object)column);
        }
        Preconditions.checkArgument((!effectivePredicate.isNone() ? 1 : 0) != 0);
        boolean originalFilesPresent = acidInfo.isPresent() && !acidInfo.get().getOriginalFiles().isEmpty();
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity());
            TrinoInputFile inputFile = fileSystem.newInputFile(path);
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), estimatedFileSize, options, inputFile, stats);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, HiveUtil.splitError(e, path, start, length), (Throwable)e);
        }
        AggregatedMemoryContext memoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        try {
            Optional optionalOrcReader = OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options);
            if (optionalOrcReader.isEmpty()) {
                return new EmptyPageSource();
            }
            OrcReader reader = (OrcReader)optionalOrcReader.get();
            if (!originalFile && acidInfo.isPresent() && !acidInfo.get().isOrcAcidVersionValidated()) {
                OrcPageSourceFactory.validateOrcAcidVersion(path, reader);
            }
            List<OrcColumn> fileColumns = reader.getRootColumn().getNestedColumns();
            int actualColumnCount = columns.size() + (isFullAcid ? 3 : 0);
            ArrayList<OrcColumn> fileReadColumns = new ArrayList<OrcColumn>(actualColumnCount);
            ArrayList<Object> fileReadTypes = new ArrayList<Object>(actualColumnCount);
            ArrayList<OrcReader.ProjectedLayout> fileReadLayouts = new ArrayList<OrcReader.ProjectedLayout>(actualColumnCount);
            if (isFullAcid && !originalFilesPresent) {
                OrcPageSourceFactory.verifyAcidSchema(reader, path);
                ImmutableMap acidColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
                fileColumns = OrcPageSourceFactory.ensureColumnNameConsistency(((OrcColumn)acidColumnsByName.get("row".toLowerCase(Locale.ENGLISH))).getNestedColumns(), columns);
                fileReadColumns.add((OrcColumn)acidColumnsByName.get("originalTransaction".toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadLayouts.add(OrcReader.fullyProjectedLayout());
                fileReadColumns.add((OrcColumn)acidColumnsByName.get("bucket".toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(IntegerType.INTEGER);
                fileReadLayouts.add(OrcReader.fullyProjectedLayout());
                fileReadColumns.add((OrcColumn)acidColumnsByName.get("rowId".toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadLayouts.add(OrcReader.fullyProjectedLayout());
            }
            ImmutableMap fileColumnsByName = ImmutableMap.of();
            if (useOrcColumnNames || isFullAcid) {
                OrcPageSourceFactory.verifyFileHasColumnNames(fileColumns, path);
                fileColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
            }
            Object projectionsByColumnName = ImmutableMap.of();
            Object projectionsByColumnIndex = ImmutableMap.of();
            if (useOrcColumnNames || isFullAcid) {
                projectionsByColumnName = projections.stream().collect(Collectors.groupingBy(HiveColumnHandle::getBaseColumnName, Collectors.mapping(OrcPageSourceFactory::getDereferencesAsList, Collectors.toList())));
            } else {
                projectionsByColumnIndex = projections.stream().collect(Collectors.groupingBy(HiveColumnHandle::getBaseHiveColumnIndex, Collectors.mapping(OrcPageSourceFactory::getDereferencesAsList, Collectors.toList())));
            }
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(options.isBloomFiltersEnabled()).setDomainCompactionThreshold(this.domainCompactionThreshold);
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            ArrayList<OrcPageSource.ColumnAdaptation> columnAdaptations = new ArrayList<OrcPageSource.ColumnAdaptation>(columns.size());
            for (HiveColumnHandle column : columns) {
                OrcColumn orcColumn2 = null;
                OrcReader.ProjectedLayout projectedLayout = null;
                Map columnDomains = null;
                if (useOrcColumnNames || isFullAcid) {
                    String columnName = column.getName().toLowerCase(Locale.ENGLISH);
                    orcColumn2 = (OrcColumn)fileColumnsByName.get(columnName);
                    if (orcColumn2 != null) {
                        projectedLayout = OrcReader.NameBasedProjectedLayout.createProjectedLayout((OrcColumn)orcColumn2, (List)((List)projectionsByColumnName.get(columnName)));
                        columnDomains = (Map)effectivePredicateDomains.entrySet().stream().filter(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getBaseColumnName().toLowerCase(Locale.ENGLISH).equals(columnName)).collect(ImmutableMap.toImmutableMap(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getHiveColumnProjectionInfo(), Map.Entry::getValue));
                    }
                } else if (column.getBaseHiveColumnIndex() < fileColumns.size() && (orcColumn2 = fileColumns.get(column.getBaseHiveColumnIndex())) != null) {
                    projectedLayout = OrcReader.NameBasedProjectedLayout.createProjectedLayout((OrcColumn)orcColumn2, (List)((List)projectionsByColumnIndex.get(column.getBaseHiveColumnIndex())));
                    columnDomains = (Map)effectivePredicateDomains.entrySet().stream().filter(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getBaseHiveColumnIndex() == column.getBaseHiveColumnIndex()).collect(ImmutableMap.toImmutableMap(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getHiveColumnProjectionInfo(), Map.Entry::getValue));
                }
                Type readType = column.getType();
                if (orcColumn2 != null) {
                    int sourceIndex = fileReadColumns.size();
                    Optional<TypeCoercer<? extends Type, ? extends Type>> coercer = OrcTypeTranslator.createCoercer(orcColumn2.getColumnType(), readType, HiveSessionProperties.getTimestampPrecision(session));
                    if (coercer.isPresent()) {
                        fileReadTypes.add(coercer.get().getFromType());
                        columnAdaptations.add(OrcPageSource.ColumnAdaptation.coercedColumn(sourceIndex, coercer.get()));
                    } else {
                        columnAdaptations.add(OrcPageSource.ColumnAdaptation.sourceColumn(sourceIndex));
                        fileReadTypes.add(readType);
                    }
                    fileReadColumns.add(orcColumn2);
                    fileReadLayouts.add(projectedLayout);
                    for (Map.Entry columnDomain2 : columnDomains.entrySet()) {
                        OrcColumn nestedColumn = OrcPageSourceFactory.getNestedColumn(orcColumn2, (Optional)columnDomain2.getKey());
                        if (nestedColumn == null) continue;
                        predicateBuilder.addColumn(nestedColumn.getColumnId(), (Domain)columnDomain2.getValue());
                    }
                    continue;
                }
                columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn(readType));
            }
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, fileReadLayouts, (OrcPredicate)predicateBuilder.build(), start, length, legacyFileTimeZone, memoryUsage, 1, arg_0 -> OrcPageSourceFactory.lambda$createOrcPageSource$7((OrcDataSource)orcDataSource, arg_0), NameBasedFieldMapper::create);
            Optional<OrcDeletedRows> deletedRows = acidInfo.map(info -> new OrcDeletedRows(path.fileName(), new OrcDeleteDeltaPageSourceFactory(options, stats), session.getIdentity(), this.fileSystemFactory, (AcidInfo)info, bucketNumber, memoryUsage));
            Optional<Long> originalFileRowId = acidInfo.filter(OrcPageSourceFactory::hasOriginalFiles).map(info -> OriginalFilesUtils.getPrecedingRowCount(((AcidInfo)acidInfo.get()).getOriginalFiles(), path, this.fileSystemFactory, session.getIdentity(), options, stats));
            if (transaction.isMerge()) {
                if (originalFile) {
                    int bucket = bucketNumber.orElse(0);
                    long startingRowId = originalFileRowId.orElse(0L);
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.mergedRowColumnsWithOriginalFiles(startingRowId, bucket));
                } else {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.mergedRowColumns());
                }
            }
            return new OrcPageSource(recordReader, columnAdaptations, (OrcDataSource)orcDataSource, deletedRows, originalFileRowId, memoryUsage, stats, reader.getCompressionKind());
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)((Object)e);
            }
            if (e instanceof OrcCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, HiveUtil.splitError(e, path, start, length), (Throwable)e);
        }
    }

    private static void validateOrcAcidVersion(Location path, OrcReader reader) {
        if (reader.getFooter().getNumberOfRows() == 0L) {
            return;
        }
        int writerId = (Integer)reader.getFooter().getWriterId().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "writerId not set in ORC metadata in " + path));
        if (writerId == 4 || writerId == 2) {
            return;
        }
        Optional<Integer> hiveAcidVersion = OrcPageSourceFactory.getHiveAcidVersion(reader);
        if (hiveAcidVersion.isEmpty() || hiveAcidVersion.get() < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Hive transactional tables are supported since Hive 3.0. Expected `hive.acid.version` in ORC metadata in %s to be >=2 but was %s. If you have upgraded from an older version of Hive, make sure a major compaction has been run at least once after the upgrade.", path, hiveAcidVersion.map(String::valueOf).orElse("<empty>")));
        }
    }

    private static Optional<Integer> getHiveAcidVersion(OrcReader reader) {
        Slice slice = (Slice)reader.getFooter().getUserMetadata().get("hive.acid.version");
        if (slice == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.valueOf(slice.toString(StandardCharsets.UTF_8)));
        }
        catch (RuntimeException ignored) {
            return Optional.empty();
        }
    }

    private static List<OrcColumn> ensureColumnNameConsistency(List<OrcColumn> fileColumns, List<HiveColumnHandle> desiredColumns) {
        int columnCount = fileColumns.size();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)columnCount);
        Map desiredColumnsByNumber = (Map)desiredColumns.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getBaseHiveColumnIndex, Function.identity()));
        for (int index = 0; index < columnCount; ++index) {
            OrcColumn column = fileColumns.get(index);
            HiveColumnHandle handle = (HiveColumnHandle)desiredColumnsByNumber.get(index);
            if (handle != null && !column.getColumnName().equals(handle.getName())) {
                column = new OrcColumn(column.getPath(), column.getColumnId(), handle.getName(), column.getColumnType(), column.getOrcDataSourceId(), column.getNestedColumns(), column.getAttributes());
            }
            builder.add((Object)column);
        }
        return builder.build();
    }

    private static boolean hasOriginalFiles(AcidInfo acidInfo) {
        return !acidInfo.getOriginalFiles().isEmpty();
    }

    private static void verifyFileHasColumnNames(List<OrcColumn> columns, Location path) {
        if (!columns.isEmpty() && columns.stream().map(OrcColumn::getColumnName).allMatch(physicalColumnName -> DEFAULT_HIVE_COLUMN_NAME_PATTERN.matcher((CharSequence)physicalColumnName).matches())) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_MISSING_COLUMN_NAMES, "ORC file does not contain column names in the footer: " + path);
        }
    }

    static void verifyAcidSchema(OrcReader orcReader, Location path) {
        OrcColumn rootColumn = orcReader.getRootColumn();
        List nestedColumns = rootColumn.getNestedColumns();
        if (nestedColumns.size() != 6) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file should have 6 columns, found %s %s in %s", nestedColumns.size(), nestedColumns.stream().map(column -> String.format("%s (%s)", column.getColumnName(), column.getColumnType())).collect(ImmutableList.toImmutableList()), path));
        }
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 0, "operation", OrcType.OrcTypeKind.INT, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 1, "originalTransaction", OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 2, "bucket", OrcType.OrcTypeKind.INT, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 3, "rowId", OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 4, "currentTransaction", OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 5, "row", OrcType.OrcTypeKind.STRUCT, path);
    }

    private static void verifyAcidColumn(OrcReader orcReader, int columnIndex, String columnName, OrcType.OrcTypeKind columnType, Location path) {
        OrcColumn column = (OrcColumn)orcReader.getRootColumn().getNestedColumns().get(columnIndex);
        if (!column.getColumnName().toLowerCase(Locale.ENGLISH).equals(columnName.toLowerCase(Locale.ENGLISH))) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file column %s should be named %s: %s", columnIndex, columnName, path));
        }
        if (column.getColumnType() != columnType) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file %s column should be type %s: %s", columnName, columnType, path));
        }
    }

    private static OrcColumn getNestedColumn(OrcColumn baseColumn, Optional<HiveColumnProjectionInfo> projectionInfo) {
        if (projectionInfo.isEmpty()) {
            return baseColumn;
        }
        OrcColumn current = baseColumn;
        for (String field : projectionInfo.get().getDereferenceNames()) {
            Optional<OrcColumn> orcColumn = current.getNestedColumns().stream().filter(column -> column.getColumnName().toLowerCase(Locale.ENGLISH).equals(field)).findFirst();
            if (orcColumn.isEmpty()) {
                return null;
            }
            current = orcColumn.get();
        }
        return current;
    }

    private static List<String> getDereferencesAsList(HiveColumnHandle column) {
        return (List)column.getHiveColumnProjectionInfo().map(info -> (ImmutableList)info.getDereferenceNames().stream().map(dereference -> dereference.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }

    private static /* synthetic */ RuntimeException lambda$createOrcPageSource$7(OrcDataSource orcDataSource, Exception exception) {
        return OrcPageSource.handleException(orcDataSource.getId(), exception);
    }
}

