/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import io.trino.orc.metadata.OrcType;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.TimestampCoercer;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;

public final class OrcTypeTranslator {
    private OrcTypeTranslator() {
    }

    public static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercer(OrcType.OrcTypeKind fromOrcType, Type toTrinoType, HiveTimestampPrecision timestampPrecision) {
        if (fromOrcType.equals((Object)OrcType.OrcTypeKind.TIMESTAMP) && toTrinoType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)toTrinoType;
            TimestampType timestampType = TimestampType.createTimestampType((int)timestampPrecision.getPrecision());
            if (timestampType.isShort()) {
                return Optional.of(new TimestampCoercer.ShortTimestampToVarcharCoercer(timestampType, varcharType));
            }
            return Optional.of(new TimestampCoercer.LongTimestampToVarcharCoercer(timestampType, varcharType));
        }
        return Optional.empty();
    }
}

