/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.type;

import com.google.common.base.Preconditions;
import io.trino.plugin.hive.type.BaseCharTypeInfo;

public final class CharTypeInfo
extends BaseCharTypeInfo {
    public static final int MAX_CHAR_LENGTH = 255;

    public CharTypeInfo(int length) {
        super("char", length);
        Preconditions.checkArgument((length >= 1 && length <= 255 ? 1 : 0) != 0, (String)"invalid char length: %s", (int)length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CharTypeInfo)) return false;
        CharTypeInfo o = (CharTypeInfo)other;
        if (this.getLength() != o.getLength()) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.getLength();
    }
}

