/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.type;

import com.google.common.base.Preconditions;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import java.util.Objects;

public final class DecimalTypeInfo
extends PrimitiveTypeInfo {
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 38;
    private final int precision;
    private final int scale;

    public DecimalTypeInfo(int precision, int scale) {
        super("decimal");
        this.precision = precision;
        this.scale = scale;
        Preconditions.checkArgument((precision >= 1 && precision <= 38 ? 1 : 0) != 0, (String)"invalid decimal precision: %s", (int)precision);
        Preconditions.checkArgument((scale >= 0 && scale <= 38 ? 1 : 0) != 0, (String)"invalid decimal scale: %s", (int)scale);
        Preconditions.checkArgument((scale <= precision ? 1 : 0) != 0, (String)"decimal precision (%s) is greater than scale (%s)", (int)precision, (int)scale);
    }

    @Override
    public String getTypeName() {
        return DecimalTypeInfo.decimalTypeName(this.precision, this.scale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DecimalTypeInfo)) return false;
        DecimalTypeInfo o = (DecimalTypeInfo)other;
        if (this.precision != o.precision) return false;
        if (this.scale != o.scale) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.precision, this.scale);
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public static String decimalTypeName(int precision, int scale) {
        return "decimal(" + precision + "," + scale + ")";
    }
}

