/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.collect.ImmutableSet;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.s3select.S3SelectSerDeDataTypeMapper;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

public final class S3SelectPushdown {
    private static final Set<String> SUPPORTED_S3_PREFIXES = ImmutableSet.of((Object)"s3://", (Object)"s3a://", (Object)"s3n://");
    private static final Set<String> SUPPORTED_COLUMN_TYPES = ImmutableSet.of((Object)"boolean", (Object)"int", (Object)"tinyint", (Object)"smallint", (Object)"bigint", (Object)"string", (Object[])new String[]{"date"});

    private S3SelectPushdown() {
    }

    private static boolean isSerDeSupported(Properties schema) {
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        return S3SelectSerDeDataTypeMapper.doesSerDeExist(serdeName);
    }

    private static boolean isInputFormatSupported(Properties schema) {
        if (S3SelectPushdown.isTextInputFormat(schema)) {
            if (!Objects.equals(schema.getProperty("skip.header.line.count", "0"), "0")) {
                return false;
            }
            return Objects.equals(schema.getProperty("skip.footer.line.count", "0"), "0");
        }
        return false;
    }

    public static boolean isCompressionCodecSupported(Properties schema, String path) {
        if (S3SelectPushdown.isTextInputFormat(schema)) {
            return CompressionKind.forFile((String)path).map(kind -> kind == CompressionKind.GZIP || kind == CompressionKind.BZIP2).orElse(true);
        }
        return false;
    }

    public static boolean isSplittable(boolean s3SelectPushdownEnabled, Properties schema, String path) {
        if (!s3SelectPushdownEnabled) {
            return true;
        }
        if (S3SelectPushdown.isTextInputFormat(schema) && CompressionKind.forFile((String)path).isEmpty()) {
            return S3SelectPushdown.isSerDeSupported(schema);
        }
        return false;
    }

    private static boolean isTextInputFormat(Properties schema) {
        return "org.apache.hadoop.mapred.TextInputFormat".equals(HiveUtil.getInputFormatName(schema).orElse(null));
    }

    private static boolean areColumnTypesSupported(List<Column> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.isEmpty()) {
            return false;
        }
        for (Column column : columns) {
            if (SUPPORTED_COLUMN_TYPES.contains(column.getType().getHiveTypeName().toString())) continue;
            return false;
        }
        return true;
    }

    private static boolean isS3Storage(String path) {
        return SUPPORTED_S3_PREFIXES.stream().anyMatch(path::startsWith);
    }

    public static boolean shouldEnablePushdownForTable(ConnectorSession session, Table table, String path, Optional<Partition> optionalPartition) {
        if (!HiveSessionProperties.isS3SelectPushdownEnabled(session)) {
            return false;
        }
        if (path == null) {
            return false;
        }
        Properties schema = optionalPartition.map(partition -> MetastoreUtil.getHiveSchema(partition, table)).orElseGet(() -> MetastoreUtil.getHiveSchema(table));
        return S3SelectPushdown.shouldEnablePushdownForTable(table, path, schema);
    }

    private static boolean shouldEnablePushdownForTable(Table table, String path, Properties schema) {
        return S3SelectPushdown.isS3Storage(path) && S3SelectPushdown.isSerDeSupported(schema) && S3SelectPushdown.isInputFormatSupported(schema) && S3SelectPushdown.areColumnTypesSupported(table.getDataColumns());
    }
}

