/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.manager;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.azure.AzureFileSystemFactory;
import io.trino.filesystem.azure.AzureFileSystemModule;
import io.trino.filesystem.gcs.GcsFileSystemFactory;
import io.trino.filesystem.gcs.GcsFileSystemModule;
import io.trino.filesystem.manager.FileSystemConfig;
import io.trino.filesystem.manager.HdfsFileSystemLoader;
import io.trino.filesystem.manager.SwitchingFileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemModule;
import io.trino.filesystem.tracing.TracingFileSystemFactory;
import io.trino.spi.NodeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FileSystemModule
extends AbstractConfigurationAwareModule {
    private final String catalogName;
    private final NodeManager nodeManager;
    private final OpenTelemetry openTelemetry;

    public FileSystemModule(String catalogName, NodeManager nodeManager, OpenTelemetry openTelemetry) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
    }

    protected void setup(Binder binder) {
        FileSystemConfig config = (FileSystemConfig)this.buildConfigObject(FileSystemConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, HdfsFileSystemLoader.class);
        if (config.isHadoopEnabled()) {
            HdfsFileSystemLoader loader = new HdfsFileSystemLoader(this.getProperties(), !config.isNativeAzureEnabled(), !config.isNativeGcsEnabled(), !config.isNativeS3Enabled(), this.catalogName, this.nodeManager, this.openTelemetry);
            loader.configure().forEach(x$0 -> this.consumeProperty((String)x$0));
            binder.bind(HdfsFileSystemLoader.class).toInstance((Object)loader);
        }
        MapBinder factories = MapBinder.newMapBinder((Binder)binder, String.class, TrinoFileSystemFactory.class);
        if (config.isNativeAzureEnabled()) {
            this.install((Module)new AzureFileSystemModule());
            factories.addBinding((Object)"abfs").to(AzureFileSystemFactory.class);
            factories.addBinding((Object)"abfss").to(AzureFileSystemFactory.class);
        }
        if (config.isNativeS3Enabled()) {
            this.install((Module)new S3FileSystemModule());
            factories.addBinding((Object)"s3").to(S3FileSystemFactory.class);
            factories.addBinding((Object)"s3a").to(S3FileSystemFactory.class);
            factories.addBinding((Object)"s3n").to(S3FileSystemFactory.class);
        }
        if (config.isNativeGcsEnabled()) {
            this.install((Module)new GcsFileSystemModule());
            factories.addBinding((Object)"gs").to(GcsFileSystemFactory.class);
        }
    }

    @Provides
    @Singleton
    public TrinoFileSystemFactory createFileSystemFactory(Optional<HdfsFileSystemLoader> hdfsFileSystemLoader, LifeCycleManager lifeCycleManager, Map<String, TrinoFileSystemFactory> factories, Tracer tracer) {
        Optional<TrinoFileSystemFactory> hdfsFactory = hdfsFileSystemLoader.map(HdfsFileSystemLoader::create);
        hdfsFactory.ifPresent(arg_0 -> ((LifeCycleManager)lifeCycleManager).addInstance(arg_0));
        SwitchingFileSystemFactory delegate = new SwitchingFileSystemFactory(hdfsFactory, factories);
        return new TracingFileSystemFactory(tracer, (TrinoFileSystemFactory)delegate);
    }
}

