/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.manager;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.manager.SwitchingFileSystem;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SwitchingFileSystemFactory
implements TrinoFileSystemFactory {
    private final Optional<TrinoFileSystemFactory> hdfsFactory;
    private final Map<String, TrinoFileSystemFactory> factories;

    public SwitchingFileSystemFactory(Optional<TrinoFileSystemFactory> hdfsFactory, Map<String, TrinoFileSystemFactory> factories) {
        this.hdfsFactory = Objects.requireNonNull(hdfsFactory, "hdfsFactory is null");
        this.factories = ImmutableMap.copyOf(Objects.requireNonNull(factories, "factories is null"));
    }

    public TrinoFileSystem create(ConnectorSession session) {
        return new SwitchingFileSystem(Optional.of(session), Optional.empty(), this.hdfsFactory, this.factories);
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new SwitchingFileSystem(Optional.empty(), Optional.of(identity), this.hdfsFactory, this.factories);
    }
}

